import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * A Zombie enemy.
 * 
 * @author Joseph Lenton
 */
public class Zombie extends Hurter
{
    private static final int HP = 10;
    private static final float SPEED = 1f;
    private static final int DAMAGE = 1;
    private static final int SCORE = 7;
    
    public Zombie()
    {
        super( HP, SCORE, DAMAGE );
    }
    
    /**
     * 
     */
    public void act() 
    {
        final Player player = getPlayer();
        if ( player != null ) {
            setMoveAngle( getAngle(player), SPEED );
        } else {
            slowdown();
        }
        
        super.act();
    }
}
