import greenfoot.World;

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class WeaponSpecialShot  extends DelayedWeapon 
{
    private static final int SPECIAL_NUM_BULLETS = 20;
    private static final double SPECIAL_ANGLE = Math.toRadians( 45 );
    private static final double SPECIAL_HALF_ANGLE = SPECIAL_ANGLE/2.0;
    private static final double SPECIAL_ANGLE_INCREMENT = SPECIAL_ANGLE/SPECIAL_NUM_BULLETS;
    
    private static final long SHOOT_DELAY = 1000;
    
    public WeaponSpecialShot()
    {
        super( SHOOT_DELAY );
    }
    
    @Override
    protected boolean delayedShoot(Player player)
    {
        double angle = Math.toRadians(player.getRotation()) - SPECIAL_HALF_ANGLE;
        final World world = player.getWorld();
        final int x = player.getWeaponX();
        final int y = player.getWeaponY();
            
        for ( int i = 0; i < SPECIAL_NUM_BULLETS; i++ ) {
            world.addObject( new PlayerSpecial(angle), x, y );
            angle += SPECIAL_ANGLE_INCREMENT;
        }
        
        return true;
    }
}
