import greenfoot.World;

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class WeaponShotgun extends OneShotWeapon 
{
    private static final int NUM_BULLETS = 5;
    private static final int MAX_NUM_BULLETS = 15;
    
    private static final double START_ANGLE_OFFSET = Math.toRadians(14);
    
    public WeaponShotgun()
    {
    }
    
    @Override
    public boolean shoot(Player player)
    {
        double angle = Math.toRadians( player.getRotation() );
        final World world = player.getWorld();
        final int x = player.getWeaponX();
        final int y = player.getWeaponY();
        final int numBullets = Random.random( NUM_BULLETS, MAX_NUM_BULLETS );
        
        for ( int i = 0; i < numBullets; i++ ) {
            final double angleOffset = Random.random( -START_ANGLE_OFFSET, START_ANGLE_OFFSET );
            world.addObject( new ShotgunBullet(angle+angleOffset), x, y );
        }
        
        return true;
    }
}
