import greenfoot.World;

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class WeaponShot  extends DelayedWeapon 
{
    private static final long SHOOT_DELAY = 100;
    
    public WeaponShot()
    {
        super( SHOOT_DELAY );
    }
    
    @Override
    protected boolean delayedShoot(Player player)
    {
        player.getWorld().addObject(
                new PlayerShot( Math.toRadians(player.getRotation()) ),
                player.getWeaponX(), player.getWeaponY() );
        
        return true;
    }
}
