import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * 
 * 
 * @author Joseph Lenton
 */
public abstract class Spawner  extends Enemy
{
    private final Class<? extends Enemy> spawnClass;
    private final long spawnDelay;
    
    private long spawnTime;
    
    public Spawner(int hp, int score, Class<? extends Enemy> spawnClass, long spawnDelay)
    {
        super( hp, score );
        
        this.spawnClass = spawnClass;
        this.spawnDelay = spawnDelay;
        
        spawnTime = System.currentTimeMillis() + spawnDelay;
    }
    
    @Override
    public void addedToWorld(World world)
    {
        while ( getOneIntersectingObject(Player.class) != null ) {
            setLocation( Random.random(world.getWidth()), Random.random(world.getHeight()) );
        }
    }
    
    /**
     * 
     */
    public void act() 
    {
        super.act();
        actSpawn();
    }
    
    protected void actSpawn()
    {
        final Game game = (Game) getWorld();
        
        if ( game.isPlaying() ) {
            final long now = System.currentTimeMillis();
            
            if ( spawnTime < now ) {
                spawn();
                spawnTime = now + spawnDelay;
            }
        }
    }
    
    protected void spawn()
    {
        try {
            getWorld().addObject( spawnClass.newInstance(), getX(), getY() );
        } catch (IllegalAccessException ex) {
            throw new RuntimeException( ex );
        } catch (InstantiationException ex) {
            throw new RuntimeException( ex );
        }
    }
}
