import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class PressStart  extends Actor
{
    private static final GreenfootImage NO_IMAGE = new GreenfootImage(1, 1);
    private static final long DELAY = 750; // 0.75 seconds
    
    private final GreenfootImage img;
    private final GamePad pad;
    
    private long nextFlash;
    private boolean show;
    
    public PressStart(GamePad pad)
    {
        this.pad = pad;
        this.img = getImage();
        
        setImage( NO_IMAGE );
    }
    
    public void addedToWorld(World world)
    {
        nextFlash = System.currentTimeMillis() + DELAY;
        show = false;
    }
    
    /**
     * 
     */
    public void act() 
    {
        final long now = System.currentTimeMillis();
        
        if ( nextFlash < now ) {
            nextFlash = now + DELAY;
            show = !show;
            
            if ( show ) {
                setImage( img );
            } else {
                setImage( NO_IMAGE );
            }
        }
        
        if ( Greenfoot.isKeyDown("space") || ( pad != null && pad.isDown(GamePad.Button.START) ) ) {
            final Game game = (Game) getWorld();
            game.startGame();
        }
    }
}
