import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * 
 * 
 * @author Joseph Lenton
 */
public abstract class PlayerBullet  extends GameActor
{
    private final int damage;
    
    public PlayerBullet(double startAngle, int damage, float speed)
    {
        setMoveAngle( startAngle, speed );
        this.damage = damage;
    }
    
    public void act()
    {
        super.act();
        
        if ( hitEnemy() || isOnScreenEdge() ) {
            remove();
        }
    }
    
    /**
     * Tries to find, and then hits and damages an enemy.
     * If finds an enemy it will tell the enemy to be hurt
     * and then return true. Otherwise false.
     * 
     * @return True if an enemy was found and hurt, otherwise false.
     */
    protected boolean hitEnemy()
    {
        final Enemy e = (Enemy) getOneIntersectingObject( Enemy.class );
        
        if ( e != null ) {
            e.damage( damage );
            
            return true;
        } else {
            return false;
        }
    }
}
