import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.geom.AffineTransform;
import java.awt.RenderingHints;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.lang.ref.WeakReference;

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class OverlayMain extends Overlay
{
    private static final GreenfootImage CENTRE = new GreenfootImage("images\\overlay.png");
    
    private static class OverlayInner extends Overlay
    {
        public OverlayInner()
        {
            setImage( CENTRE );
        }
    }
    
    private static final int CENTRE_WIDTH = CENTRE.getWidth();
    private static final int CENTRE_HEIGHT = CENTRE.getHeight();
    
    private static final int DRAW_OFFSET_X = -145;
    private static final int DRAW_OFFSET_Y = -218;
    
    private static final int OVERLAY_LEFT = 815;
    private static final int OVERLAY_TOP = 742;
    private static final int OVERLAY_RIGHT = 518;
    
    private Actor overlayInner;
    
    public OverlayMain()
    {
    }
    
    @Override
    public void addedToWorld(World world)
    {
        super.addedToWorld( world );
        
        final int width = world.getWidth();
        final int height = world.getHeight();
        
        setImage( new GreenfootImage(width, height) );
        
        overlayInner = new OverlayInner();
        world.addObject( overlayInner, getX(), getY() );
        setLocation( width/2, height/2 );
        
        actUpdateImage();
    }
    
    private void actUpdateImage()
    {
        final List players = getWorld().getObjects( Player.class );
        
        if ( players.size() > 0 ) {
            final Player player = (Player) players.get( 0 );
            final int rotation = player.getRotation();
            final double angle = Math.toRadians( rotation );
            final int playerX = player.getX();
            final int playerY = player.getY();
            final int drawX = playerX - CENTRE_WIDTH/2;
            final int drawY = playerY - CENTRE_HEIGHT/2;
            
            final GreenfootImage image = getImage();
            final BufferedImage awtImage = image.getAwtImage();
            final Graphics2D g = awtImage.createGraphics();
            
            final AffineTransform aTrans = new AffineTransform();
            aTrans.rotate( angle, playerX, playerY );
            
            image.clear();
            g.setTransform( aTrans );
    
            // centre
            g.setColor( Color.BLACK );
            // left
            g.fillRect( drawX-OVERLAY_LEFT+1, drawY-OVERLAY_TOP, OVERLAY_LEFT, OVERLAY_TOP*2+CENTRE_HEIGHT );
            // right
            g.fillRect( drawX+CENTRE_WIDTH-2, drawY-OVERLAY_TOP, OVERLAY_RIGHT, OVERLAY_TOP*2+CENTRE_HEIGHT );
            // top
            g.fillRect( drawX, drawY-OVERLAY_TOP+1, CENTRE_WIDTH, OVERLAY_TOP );
            // bottom
            g.fillRect( drawX, drawY+CENTRE_HEIGHT-2, CENTRE_WIDTH, OVERLAY_TOP );
            
            g.dispose();
            
            overlayInner.setLocation( playerX, playerY );
            overlayInner.setRotation( rotation );
        }
    }
    
    /**
     * 
     */
    public void act() 
    {
        actUpdateImage();
        super.act();
    }
}
