
import java.awt.image.BufferedImage;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.GraphicsEnvironment;

/**
 * 
 * 
 * @author Joseph Lenton
 */
public class ImageUtil 
{
    private ImageUtil()
    {
    }
    
    
    private static void validateSize(int width, int height)
    {
        if (width <= 0) {
            throw new IllegalArgumentException("Width cannot be less than or equal to 0, width: " + width);
        } else if (height <= 0) {
            throw new IllegalArgumentException("Height cannot be less than or equal to 0, height: " + height);
        }
    }
    
    private static BufferedImage createTransparent(BufferedImage image)
    {
        return createTransparent(image.getWidth(), image.getHeight(), image.getTransparency());
    }
    
    private static BufferedImage createTransparent(int width, int height, int transparency)
    {
        validateSize(width, height);
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().
                createCompatibleImage(width, height, transparency);
    }
    
    /**
     * Rotates the given image by the given angle.
     * @param image The image to rotate.
     * @param angle The angle to rotate the image by, in degrees.
     * @return A copy of the image rotated to the given amount.
     */
    public static BufferedImage rotate(BufferedImage image, int angle)
    {
        return new AffineTransformOp(
                AffineTransform.getRotateInstance(Math.toRadians(angle), image.getWidth()/2.0, image.getHeight()/2.0),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR).filter(image, ImageUtil.createTransparent(image));
    }
}
