import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ghost here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ghost  extends Hurter
{
    private static final int HP = 10;
    private static final float SPEED = 1f;
    private static final int DAMAGE = 1;
    private static final int SCORE = 10;
    
    private static final float ROTATION_SPEED = 0.65f;
    
    private float rotation;
    
    public Ghost()
    {
        super( HP, SCORE, DAMAGE );
        
        setRotation( Random.random(360) );
    }
    
    @Override
    public void setRotation(int rotation)
    {
        this.setRotation( (float) rotation );
    }
    
    public void setRotation(float rotation)
    {
        super.setRotation( Math.round(rotation) );
        this.rotation = rotation;
    }
    
    /**
     * 
     */
    public void act() 
    {
        final Player player = getPlayer();
        
        if ( player != null ) {
            final float toAngle = (float) getAngle( player );
            final float diff = Angle.minDiff( (float) Math.toRadians(rotation), toAngle );
            final float delta = getWorld().getDeltaTime();
            
            final float newRotation;
            if ( diff < 0 ) {
                newRotation = rotation - ROTATION_SPEED*delta;
            } else {
                newRotation = rotation + ROTATION_SPEED*delta;
            }
            
            setMoveAngle( (float)Math.toRadians(newRotation), SPEED );
            rotation = newRotation;
        } else {
            slowdown();
        }
        
        super.act();
    }
}
