import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.List;

/**
 * 
 * @author Joseph Lenton
 */
public abstract class Enemy  extends HealthActor
{
    private static final long SLOWDOWN_TIME = 2000;
    
    private long slowdownStart;
    private float moveX;
    private float moveY;
    private final int score;
    
    public Enemy( int hp, int score )
    {
        super( hp );
        
        this.slowdownStart = 0;
        this.score = score;
    }
    
    @Override
    public void addedToWorld(World world)
    {
        final Game game = (Game) world;
        setMaxHP( getHP() + game.getHealthAdd() );
        
        super.addedToWorld( world );
    }
    
    public Player getPlayer()
    {
        final List ls = getWorld().getObjects(Player.class);
        
        if ( ls.size() > 0 ) {
            return (Player) ls.get(0);
        } else {
            return null;
        }
    }
    
    protected void slowdown()
    {
        final long now = System.currentTimeMillis();
        if ( slowdownStart == 0 ) {
            slowdownStart = now;
            moveX = getMoveX();
            moveY = getMoveY();
        }
        
        final long diff = now - slowdownStart;
        if ( diff < SLOWDOWN_TIME ) {
            final float slowdown = (float)(SLOWDOWN_TIME-diff) / (float)SLOWDOWN_TIME;
            setMoving( slowdown*moveX, slowdown*moveY );
        }
    }
    
    @Override
    public void remove()
    {
        final Game game = (Game) getWorld();
        game.incrementScore( score );
        
        super.remove();
    }
}
