/**
 * 
 * 
 * @author Joseph Lenton
 */
public class DeltaTime  
{
    private static final double IDEAL_FRAME_TIME = 1000.0 / 60.0;
    
    private float deltaTime;
    private long lastTime;
    
    public DeltaTime()
    {
        reset();
    }
    
    public final void reset()
    {
        deltaTime = 1f;
        lastTime = System.currentTimeMillis();
    }
    
    public void update()
    {
        final long now = System.currentTimeMillis();
        final long diff = now - lastTime;
        deltaTime = (float) ( (double)diff / IDEAL_FRAME_TIME );
        
        lastTime = now;
    }
    
    public float getDeltaTime()
    {
        return deltaTime;
    }
}
