/**
 * Write a description of class DelayedWeapon here.
 * 
 * @author Joseph Lenton
 */
public abstract class DelayedWeapon implements Weapon 
{
    private final long delay;
    
    private long endDelay;

    public boolean isRapidFire()
    {
        return true;
    }
    
    /**
     * Constructor for objects of class DelayedWeapon
     */
    public DelayedWeapon(long delay)
    {
        this.delay = delay;
        
        final long now = System.currentTimeMillis();
        
        // starts ready to shoot!
        endDelay = now;
    }
    
    @Override
    public boolean shoot(Player player)
    {
        final long now = System.currentTimeMillis();
        
        if ( endDelay < now ) {
            endDelay = now+delay;
            
            return delayedShoot( player );
        } else {
            return false;
        }
    }
    
    protected abstract boolean delayedShoot( Player player );
}
