/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.extensions.BClassTarget;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;

public class BDependency {
    private Identifier originId;
    private Identifier targetId;
    private Type type;

    BDependency(Identifier originId, Identifier targetId, Type type) throws IllegalArgumentException {
        if (!originId.equalsIgnoreClass(targetId)) {
            throw new IllegalArgumentException("The origin and target of a dependency must be in the same project in the same package");
        }
        this.originId = originId;
        this.targetId = targetId;
        this.type = type;
    }

    void originNameChanged(String newOriginName) {
        try {
            Project bluejProject = this.originId.getBluejProject();
            Package bluejPackage = this.originId.getBluejPackage();
            this.originId = new Identifier(bluejProject, bluejPackage, newOriginName);
        }
        catch (ProjectNotOpenException projectNotOpenException) {
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
    }

    void targetNameChanged(String newTargetName) {
        try {
            Project bluejProject = this.targetId.getBluejProject();
            Package bluejPackage = this.targetId.getBluejPackage();
            this.targetId = new Identifier(bluejProject, bluejPackage, newTargetName);
        }
        catch (ProjectNotOpenException projectNotOpenException) {
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
    }

    public Type getType() throws ProjectNotOpenException, PackageNotFoundException {
        Type result = Type.UNKNOWN;
        Dependency dependency = this.originId.getDependency(this.targetId, this.type);
        if (dependency != null) {
            result = dependency.getType();
        }
        return result;
    }

    public BClassTarget getFrom() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget origin = this.originId.getClassTarget();
        return origin != null ? origin.getBClassTarget() : null;
    }

    public BClassTarget getTo() throws ProjectNotOpenException, PackageNotFoundException {
        ClassTarget target = this.targetId.getClassTarget();
        return target != null ? target.getBClassTarget() : null;
    }

    public boolean isVisible() throws ProjectNotOpenException, PackageNotFoundException {
        Dependency dependency = this.originId.getDependency(this.targetId, this.type);
        return dependency != null ? dependency.isVisible() : false;
    }

    public void setVisible(boolean visible, boolean recalc) throws ProjectNotOpenException, PackageNotFoundException {
        Dependency dependency = this.originId.getDependency(this.targetId, this.type);
        if (dependency != null) {
            dependency.setVisible(visible);
            if (recalc) {
                dependency.getFrom().recalcOutUses();
                dependency.getTo().recalcInUses();
            }
        }
    }

    public String toString() {
        try {
            ClassTarget origin = this.originId.getClassTarget();
            ClassTarget target = this.targetId.getClassTarget();
            return "BDependency (" + (Object)((Object)this.type) + "): " + origin.getIdentifierName() + " --> " + target.getIdentifierName();
        }
        catch (ExtensionException e) {
            return "BDependency: INVALID";
        }
    }

    public static enum Type {
        UNKNOWN,
        USES,
        EXTENDS,
        IMPLEMENTS;

    }
}

