/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.builders;

import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.PackageSummaryWriter;
import bluej.doclet.doclets.internal.toolkit.builders.AbstractBuilder;
import bluej.doclet.doclets.internal.toolkit.builders.LayoutParser;
import bluej.doclet.doclets.internal.toolkit.util.DirectoryManager;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;

public class PackageSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "PackageDoc";
    private PackageDoc packageDoc;
    private PackageSummaryWriter packageWriter;

    private PackageSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static PackageSummaryBuilder getInstance(Configuration configuration, PackageDoc pkg, PackageSummaryWriter packageWriter) {
        PackageSummaryBuilder builder = new PackageSummaryBuilder(configuration);
        builder.packageDoc = pkg;
        builder.packageWriter = packageWriter;
        return builder;
    }

    @Override
    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    @Override
    public void build() throws IOException {
        if (this.packageWriter == null) {
            return;
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildPackageDoc(List elements) throws Exception {
        this.build(elements);
        this.packageWriter.close();
        Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.packageDoc), DirectoryManager.getDirectoryPath(this.packageDoc) + File.separator + "doc-files", true);
    }

    public void buildPackageHeader() {
        this.packageWriter.writePackageHeader(Util.getPackageName(this.packageDoc));
    }

    public void buildPackageDescription() {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.writePackageDescription();
    }

    public void buildPackageTags() {
        if (this.configuration.nocomment) {
            return;
        }
        this.packageWriter.writePackageTags();
    }

    public void buildSummary(List elements) {
        this.build(elements);
    }

    public void buildSummaryHeader() {
        this.packageWriter.writeSummaryHeader();
    }

    public void buildSummaryFooter() {
        this.packageWriter.writeSummaryFooter();
    }

    public void buildClassSummary() {
        ClassDoc[] classes;
        ClassDoc[] classDocArray = classes = this.packageDoc.isIncluded() ? this.packageDoc.ordinaryClasses() : this.configuration.classDocCatalog.ordinaryClasses(Util.getPackageName(this.packageDoc));
        if (classes.length > 0) {
            this.packageWriter.writeClassesSummary(classes, this.configuration.getText("doclet.Class_Summary"));
        }
    }

    public void buildInterfaceSummary() {
        ClassDoc[] interfaces;
        ClassDoc[] classDocArray = interfaces = this.packageDoc.isIncluded() ? this.packageDoc.interfaces() : this.configuration.classDocCatalog.interfaces(Util.getPackageName(this.packageDoc));
        if (interfaces.length > 0) {
            this.packageWriter.writeClassesSummary(interfaces, this.configuration.getText("doclet.Interface_Summary"));
        }
    }

    public void buildAnnotationTypeSummary() {
        AnnotationTypeDoc[] annotationTypes;
        Object[] objectArray = annotationTypes = this.packageDoc.isIncluded() ? this.packageDoc.annotationTypes() : this.configuration.classDocCatalog.annotationTypes(Util.getPackageName(this.packageDoc));
        if (annotationTypes.length > 0) {
            this.packageWriter.writeClassesSummary((ClassDoc[])annotationTypes, this.configuration.getText("doclet.Annotation_Types_Summary"));
        }
    }

    public void buildEnumSummary() {
        ClassDoc[] enums;
        ClassDoc[] classDocArray = enums = this.packageDoc.isIncluded() ? this.packageDoc.enums() : this.configuration.classDocCatalog.enums(Util.getPackageName(this.packageDoc));
        if (enums.length > 0) {
            this.packageWriter.writeClassesSummary(enums, this.configuration.getText("doclet.Enum_Summary"));
        }
    }

    public void buildExceptionSummary() {
        ClassDoc[] exceptions;
        ClassDoc[] classDocArray = exceptions = this.packageDoc.isIncluded() ? this.packageDoc.exceptions() : this.configuration.classDocCatalog.exceptions(Util.getPackageName(this.packageDoc));
        if (exceptions.length > 0) {
            this.packageWriter.writeClassesSummary(exceptions, this.configuration.getText("doclet.Exception_Summary"));
        }
    }

    public void buildErrorSummary() {
        ClassDoc[] errors;
        ClassDoc[] classDocArray = errors = this.packageDoc.isIncluded() ? this.packageDoc.errors() : this.configuration.classDocCatalog.errors(Util.getPackageName(this.packageDoc));
        if (errors.length > 0) {
            this.packageWriter.writeClassesSummary(errors, this.configuration.getText("doclet.Error_Summary"));
        }
    }

    public void buildPackageFooter() {
        this.packageWriter.writePackageFooter();
    }
}

