/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.AbstractTreeWriter;
import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.internal.toolkit.util.ClassTree;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationImpl configuration, String filename, ClassTree classtree) throws IOException {
        super(configuration, filename, classtree);
        this.packages = configuration.packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        String filename = "overview-tree.html";
        try {
            TreeWriter treegen = new TreeWriter(configuration, filename, classtree);
            treegen.generateTreeFile();
            treegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHtmlHeader(this.configuration.getText("doclet.Window_Class_Hierarchy"), null, true);
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.generateTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy");
        this.generateTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (this.packages.length == 1 && this.packages[0].name().length() == 0) {
            return;
        }
        if (!this.classesonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            for (int i = 0; i < this.packages.length; ++i) {
                if (this.packages[i].name().length() == 0) continue;
                String filename = this.pathString(this.packages[i], "package-tree.html");
                this.printHyperLink(filename, "", this.packages[i].name());
                if (i >= this.packages.length - 1) continue;
                this.print(", ");
            }
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.printTop();
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

