/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.io;

import com.jrockit.mc.common.io.FileResource;
import com.jrockit.mc.common.io.IOResource;
import com.jrockit.mc.common.io.IOResourceSet;
import com.jrockit.mc.common.io.JarFileResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class IOToolkit {
    private static final int[] ZIP_MAGIC = new int[]{80, 75, 3, 4};
    private static final int[] GZ_MAGIC = new int[]{31, 139};

    private IOToolkit() {
        throw new Error("Don't");
    }

    public static IOResourceSet createResourceSet(File file) throws IOException {
        if (file.isDirectory()) {
            return IOToolkit.createResourceSetFromDirectory(file);
        }
        if (IOToolkit.isZipFile(file)) {
            return IOToolkit.createResourceSetFromJarFile(file);
        }
        return null;
    }

    private static IOResourceSet createResourceSetFromDirectory(File directory) {
        ArrayList<IOResource> resources = new ArrayList<IOResource>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            resources.add(new FileResource(file));
            ++n2;
        }
        return new IOResourceSet(resources);
    }

    private static IOResourceSet createResourceSetFromJarFile(File file) throws IOException {
        ArrayList<IOResource> resources = new ArrayList<IOResource>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> files = jarFile.entries();
        while (files.hasMoreElements()) {
            JarEntry je = files.nextElement();
            resources.add(new JarFileResource(jarFile, je));
        }
        return new IOResourceSet(resources);
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream openUncompressedStream(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            BufferedInputStream in = new BufferedInputStream(fin);
            if (IOToolkit.hasMagic(file, GZ_MAGIC)) {
                return new GZIPInputStream(in);
            }
            if (IOToolkit.hasMagic(file, ZIP_MAGIC)) {
                return new ZipInputStream(in);
            }
            return in;
        }
        catch (RuntimeException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (IOException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (Error e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
    }

    public static boolean hasMagic(File file, int[] magic) throws IOException {
        boolean bl;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            bl = IOToolkit.hasMagic(fis, magic);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fis);
            throw throwable;
        }
        IOToolkit.closeSilently(fis);
        return bl;
    }

    public static boolean hasMagic(InputStream is, int[] magic) throws IOException {
        int[] nArray = magic;
        int n = magic.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            int b = is.read();
            if (b != element) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isGZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, GZ_MAGIC);
    }

    public static boolean isZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, ZIP_MAGIC);
    }

    public static List<String> loadFromFile(File file) throws IOException {
        FileReader fr = new FileReader(file);
        try {
            List<String> list = IOToolkit.loadFromReader(fr);
            return list;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOToolkit.closeSilently(fr);
        }
    }

    public static List<String> loadFromReader(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(reader);
        while (br.ready()) {
            lines.add(br.readLine());
        }
        return lines;
    }

    public static void saveToFile(File file, String text) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(text);
        IOToolkit.saveToFile(file, lines);
    }

    public static void saveToFile(File file, List<String> lines) throws IOException {
        PrintWriter pr = null;
        try {
            pr = new PrintWriter(new FileWriter(file));
            for (String line : lines) {
                pr.println(line);
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(pr);
            throw throwable;
        }
        IOToolkit.closeSilently(pr);
    }

    public static List<String> loadFromStream(InputStream is) throws IOException {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedInputStream bis = new BufferedInputStream(is);
            BufferedReader r = new BufferedReader(new InputStreamReader(bis));
            while (r.ready()) {
                lines.add(r.readLine());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            IOToolkit.closeSilently(is);
        }
    }

    public static void write(InputStream in, File toOutput, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(toOutput, append);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(fos);
            IOToolkit.copy(in, os);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(os);
            IOToolkit.closeSilently(fos);
            throw throwable;
        }
        IOToolkit.closeSilently(os);
        IOToolkit.closeSilently(fos);
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOToolkit.copy(is, os, 1024);
    }

    public static void copy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
        is.close();
    }

    public static boolean compareInputstreams(InputStream a, InputStream b) throws IOException {
        try {
            int aByte;
            do {
                aByte = a.read();
                int bByte = b.read();
                if (bByte == aByte) continue;
                return false;
            } while (aByte != -1);
            return true;
        }
        finally {
            IOToolkit.closeSilently(a);
            IOToolkit.closeSilently(b);
        }
    }

    public static void copyFile(File srcFile, File targetFile) throws IOException {
        if (srcFile.getCanonicalPath().equals(targetFile.getCanonicalPath())) {
            return;
        }
        FileChannel srcChannel = null;
        FileChannel targetChannel = null;
        try {
            srcChannel = new FileInputStream(srcFile).getChannel();
            targetChannel = new FileOutputStream(targetFile).getChannel();
            targetChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(srcChannel);
            IOToolkit.closeSilently(targetChannel);
            throw throwable;
        }
        IOToolkit.closeSilently(srcChannel);
        IOToolkit.closeSilently(targetChannel);
    }

    public static String calculateFileHash(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            int read;
            long seek = raf.length() / 10L;
            byte[] buffer = new byte[1024];
            MessageDigest hash = MessageDigest.getInstance("MD5");
            while ((read = raf.read(buffer)) > 0) {
                hash.update(buffer, 0, read);
                raf.seek(raf.getFilePointer() + seek);
            }
            String string = new BigInteger(1, hash.digest()).toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOToolkit.closeSilently(raf);
        }
    }
}

