/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers.event;

import bluej.extensions.BClass;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import bluej.utility.Debug;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import rmiextension.wrappers.RBlueJImpl;
import rmiextension.wrappers.event.RCompileEventImpl;
import rmiextension.wrappers.event.RCompileListener;

public class RCompileListenerWrapper
implements CompileListener {
    private RCompileListener remoteListener;
    private BProject project;
    private RBlueJImpl blueJ;

    public RCompileListenerWrapper(RCompileListener remoteListener, BProject project, RBlueJImpl blueJ) {
        this.remoteListener = remoteListener;
        this.project = project;
        this.blueJ = blueJ;
    }

    private boolean isInThisProject(File[] files) {
        if (files.length <= 0) {
            return true;
        }
        File file = files[0];
        try {
            BPackage[] packages = this.project.getPackages();
            for (int i = 0; i < packages.length; ++i) {
                BPackage pkg = packages[i];
                BClass[] classes = pkg.getClasses();
                for (int j = 0; j < classes.length; ++j) {
                    BClass cls = classes[j];
                    if (!cls.getJavaFile().equals(file)) continue;
                    return true;
                }
            }
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void compileStarted(final CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RCompileEventImpl rEvent = new RCompileEventImpl(event);
                        RCompileListenerWrapper.this.remoteListener.compileStarted(rEvent);
                    }
                    catch (ServerError se) {
                        Debug.reportError((String)"Remote compile listener ServerError", (Throwable)se.getCause());
                    }
                    catch (ServerException se) {
                        Debug.reportError((String)"Remote compile listener ServerException", (Throwable)se.getCause());
                    }
                    catch (RemoteException re) {
                        RCompileListenerWrapper.this.blueJ.removeCompileListener(RCompileListenerWrapper.this.remoteListener);
                    }
                }
            }.start();
        }
    }

    public void compileError(final CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RCompileEventImpl rEvent = new RCompileEventImpl(event);
                        RCompileListenerWrapper.this.remoteListener.compileError(rEvent);
                    }
                    catch (ServerError se) {
                        Debug.reportError((String)"Remote compile listener ServerError", (Throwable)se.getCause());
                    }
                    catch (ServerException se) {
                        Debug.reportError((String)"Remote compile listener ServerException", (Throwable)se.getCause());
                    }
                    catch (RemoteException re) {
                        RCompileListenerWrapper.this.blueJ.removeCompileListener(RCompileListenerWrapper.this.remoteListener);
                    }
                }
            }.start();
        }
    }

    public void compileWarning(final CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RCompileEventImpl rEvent = new RCompileEventImpl(event);
                        RCompileListenerWrapper.this.remoteListener.compileWarning(rEvent);
                    }
                    catch (ServerError se) {
                        Debug.reportError((String)"Remote compile listener ServerError", (Throwable)se.getCause());
                    }
                    catch (ServerException se) {
                        Debug.reportError((String)"Remote compile listener ServerException", (Throwable)se.getCause());
                    }
                    catch (RemoteException re) {
                        RCompileListenerWrapper.this.blueJ.removeCompileListener(RCompileListenerWrapper.this.remoteListener);
                    }
                }
            }.start();
        }
    }

    public void compileSucceeded(final CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RCompileEventImpl rEvent = new RCompileEventImpl(event);
                        RCompileListenerWrapper.this.remoteListener.compileSucceeded(rEvent);
                    }
                    catch (ServerError se) {
                        Debug.reportError((String)"Remote compile listener ServerError", (Throwable)se.getCause());
                    }
                    catch (ServerException se) {
                        Debug.reportError((String)"Remote compile listener ServerException", (Throwable)se.getCause());
                    }
                    catch (RemoteException re) {
                        RCompileListenerWrapper.this.blueJ.removeCompileListener(RCompileListenerWrapper.this.remoteListener);
                    }
                }
            }.start();
        }
    }

    public void compileFailed(final CompileEvent event) {
        if (this.isInThisProject(event.getFiles())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        RCompileEventImpl rEvent = new RCompileEventImpl(event);
                        RCompileListenerWrapper.this.remoteListener.compileFailed(rEvent);
                    }
                    catch (ServerError se) {
                        Debug.reportError((String)"Remote compile listener ServerError", (Throwable)se.getCause());
                    }
                    catch (ServerException se) {
                        Debug.reportError((String)"Remote compile listener ServerException", (Throwable)se.getCause());
                    }
                    catch (RemoteException re) {
                        RCompileListenerWrapper.this.blueJ.removeCompileListener(RCompileListenerWrapper.this.remoteListener);
                    }
                }
            }.start();
        }
    }
}

