/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.debugger.DebuggerThread;
import bluej.debugmgr.ExecControls;
import bluej.extensions.BClass;
import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.PackageAlreadyExistsException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.utility.Debug;
import greenfoot.util.DebugUtil;
import java.awt.EventQueue;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.WrapperPool;
import rmiextension.wrappers.event.RProjectListener;

public class RProjectImpl
extends UnicastRemoteObject
implements RProject {
    private final WeakReference<BProject> bProject;
    private WeakReference<DebuggerThread> simulationThread;
    private BObject transportObject = null;
    private List<RProjectListener> listeners = new ArrayList<RProjectListener>();
    private boolean vmRestarted = false;

    public RProjectImpl(BProject bProject) throws RemoteException {
        this.bProject = new WeakReference<BProject>(bProject);
        try {
            Project thisProject = Project.getProject((File)bProject.getDir());
            thisProject.getExecControls().setRestrictedClasses(DebugUtil.restrictedClassesAsNames());
        }
        catch (ProjectNotOpenException e) {
            Debug.message((String)"Project not open while setting up debugger");
        }
    }

    public synchronized void setTransportObject(BObject transportObject) {
        this.transportObject = transportObject;
        this.notifyAll();
    }

    @Override
    public void close() {
        this.notifyClosing();
        try {
            this.getBProject().close();
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosing() {
        ArrayList<RProjectListener> listeners;
        this.transportObject = null;
        List<RProjectListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<RProjectListener>(this.listeners);
        }
        for (RProjectListener listener : listeners) {
            try {
                listener.projectClosing();
            }
            catch (ServerError se) {
                Debug.reportError((String)"Error when scenario closing: ", (Throwable)se);
            }
            catch (ServerException se) {
                Debug.reportError((String)"Error when scenario closing: ", (Throwable)se);
            }
            catch (ConnectException ce) {
                this.removeListener(listener);
            }
            catch (ConnectIOException cioe) {
                this.removeListener(listener);
            }
            catch (RemoteException re) {
                Debug.reportError((String)"Error when scenario closing: ", (Throwable)re);
                this.removeListener(listener);
            }
        }
    }

    @Override
    public File getDir() throws ProjectNotOpenException {
        return this.getBProject().getDir();
    }

    @Override
    public String getName() throws ProjectNotOpenException {
        return this.getBProject().getName();
    }

    @Override
    public RPackage getPackage(String name) throws ProjectNotOpenException, RemoteException {
        BPackage bPackage = this.getBProject().getPackage(name);
        RPackage wrapper = null;
        if (bPackage != null) {
            wrapper = WrapperPool.instance().getWrapper(bPackage);
        }
        return wrapper;
    }

    @Override
    public RPackage newPackage(String fullyQualifiedName) throws ProjectNotOpenException, PackageAlreadyExistsException, RemoteException {
        BPackage bPackage = this.getBProject().newPackage(fullyQualifiedName);
        RPackage wrapper = null;
        wrapper = WrapperPool.instance().getWrapper(bPackage);
        return wrapper;
    }

    @Override
    public RPackage[] getPackages() throws ProjectNotOpenException, RemoteException {
        BPackage[] packages = this.getBProject().getPackages();
        int length = packages.length;
        RPackage[] wrapper = new RPackage[length];
        for (int i = 0; i < length; ++i) {
            wrapper[i] = WrapperPool.instance().getWrapper(packages[i]);
        }
        return wrapper;
    }

    @Override
    public void save() throws ProjectNotOpenException {
        this.getBProject().save();
    }

    @Override
    public void openReadmeEditor() throws ProjectNotOpenException {
        Project thisProject = Project.getProject((File)this.getBProject().getDir());
        Package defaultPackage = thisProject.getPackage("");
        ReadmeTarget readmeTarget = defaultPackage.getReadmeTarget();
        readmeTarget.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RProjectListener listener) throws RemoteException {
        List<RProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RProjectListener listener) {
        List<RProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized RObject getRemoteObject() throws RemoteException {
        try {
            while (this.transportObject == null) {
                this.wait();
            }
            BClass bClass = this.transportObject.getBClass();
            BField field = bClass.getField("transportField");
            final BObject value = (BObject)field.getValue(this.transportObject);
            if (value != null) {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String cName = value.getBClass().getName();
                            cName = cName.toLowerCase();
                            value.addToBench(cName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (PackageNotFoundException packageNotFoundException) {
                        }
                        catch (ProjectNotOpenException projectNotOpenException) {
                            // empty catch block
                        }
                    }
                });
                value.getInstanceName();
                return WrapperPool.instance().getWrapper(value);
            }
        }
        catch (InterruptedException bClass) {
        }
        catch (ClassNotFoundException bClass) {
        }
        catch (PackageNotFoundException bClass) {
        }
        catch (ProjectNotOpenException bClass) {
        }
        catch (InvocationTargetException ite) {
            Debug.reportError((String)"Error adding object to bench", (Throwable)ite);
        }
        return null;
    }

    @Override
    public boolean isExecControlVisible() throws RemoteException {
        class ExecControlsChecker
        implements Runnable {
            public boolean visible;

            ExecControlsChecker() {
            }

            @Override
            public void run() {
                try {
                    Project thisProject = Project.getProject((File)RProjectImpl.this.getBProject().getDir());
                    ExecControls execControls = thisProject.getExecControls();
                    execControls.setRestrictedClasses(DebugUtil.restrictedClassesAsNames());
                    this.visible = execControls.isVisible();
                }
                catch (ProjectNotOpenException projectNotOpenException) {
                    // empty catch block
                }
            }
        }
        ExecControlsChecker checker = new ExecControlsChecker();
        try {
            EventQueue.invokeAndWait(checker);
        }
        catch (InvocationTargetException ite) {
            Debug.reportError((String)"Error checking exec controls visibility", (Throwable)ite);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return checker.visible;
    }

    @Override
    public void toggleExecControls() throws RemoteException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Project thisProject = Project.getProject((File)RProjectImpl.this.getBProject().getDir());
                    ExecControls execControls = thisProject.getExecControls();
                    execControls.makeSureThreadIsSelected((DebuggerThread)RProjectImpl.this.simulationThread.get());
                    execControls.showHide(!execControls.isVisible());
                    execControls.setRestrictedClasses(DebugUtil.restrictedClassesAsNames());
                }
                catch (ProjectNotOpenException projectNotOpenException) {
                    // empty catch block
                }
            }
        });
    }

    public void setSimulationThread(DebuggerThread simulationThread) {
        this.simulationThread = new WeakReference<DebuggerThread>(simulationThread);
        try {
            final Project thisProject = Project.getProject((File)this.getBProject().getDir());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (thisProject.hasExecControls()) {
                        ExecControls execControls = thisProject.getExecControls();
                        execControls.makeSureThreadIsSelected((DebuggerThread)RProjectImpl.this.simulationThread.get());
                    }
                }
            });
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    @Override
    public void restartVM() throws RemoteException, ProjectNotOpenException {
        try {
            this.vmRestarted = true;
            this.getBProject().restartVM();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public boolean isVMRestarted() throws RemoteException {
        return this.vmRestarted;
    }

    @Override
    public void setVmRestarted(boolean vmRestarted) {
        this.vmRestarted = vmRestarted;
    }

    @Override
    public void setClosing(boolean closing) throws RemoteException, ProjectNotOpenException {
        ExtensionBridge.getProject((BProject)this.getBProject()).setClosing(closing);
    }

    @Override
    public void openBrowser(String customUrl) throws RemoteException, ProjectNotOpenException {
        this.getBProject().openWebViewTab(customUrl);
    }

    @Override
    public void greenfootReady() throws ProjectNotOpenException, RemoteException {
        this.getBProject().scheduleCompilation(false);
    }

    @Override
    public void startImportsScan() throws RemoteException, ProjectNotOpenException {
        ExtensionBridge.getProject((BProject)this.getBProject()).getImportScanner().startScanning();
    }

    private BProject getBProject() {
        return (BProject)this.bProject.get();
    }
}

