/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import java.awt.EventQueue;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.swing.SwingUtilities;
import rmiextension.wrappers.InvocationResultWatcher;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RJobQueue;
import rmiextension.wrappers.RJobQueueImpl;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.WrapperPool;

public class RPackageImpl
extends UnicastRemoteObject
implements RPackage {
    private final WeakReference<BPackage> bPackage;
    private static CompilationNotStartedException cnse;
    private static PackageNotFoundException pnfe;
    private static ProjectNotOpenException pnoe;
    private static RClass rclassResult;
    private static RClass[] rclassArrayResult;

    public RPackageImpl(BPackage bPackage) throws RemoteException {
        this.bPackage = new WeakReference<BPackage>(bPackage);
    }

    @Override
    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.getBPackage().compile(waitCompileEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileAll() throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Class<RPackageImpl> clazz = RPackageImpl.class;
        synchronized (RPackageImpl.class) {
            try {
                cnse = null;
                pnfe = null;
                pnoe = null;
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        this.getBPackage().compileAll(false);
                    }
                    catch (CompilationNotStartedException ce) {
                        cnse = ce;
                    }
                    catch (PackageNotFoundException pe) {
                        pnfe = pe;
                    }
                    catch (ProjectNotOpenException pe) {
                        pnoe = pe;
                    }
                });
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            if (cnse != null) {
                throw cnse;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            if (pnoe != null) {
                throw pnoe;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public RJobQueue getCompiler() throws RemoteException {
        return new RJobQueueImpl(this.getPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RClass getRClass(String name) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Class<RPackageImpl> clazz = RPackageImpl.class;
        synchronized (RPackageImpl.class) {
            pnoe = null;
            pnfe = null;
            try {
                EventQueue.invokeAndWait(() -> {
                    try {
                        rclassResult = WrapperPool.instance().getWrapper(this.getBPackage().getBClass(name));
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    catch (ProjectNotOpenException e) {
                        pnoe = e;
                    }
                    catch (PackageNotFoundException e) {
                        pnfe = e;
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rclassResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RClass[] getRClasses() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        RPackageImpl rPackageImpl = this;
        synchronized (rPackageImpl) {
            pnoe = null;
            pnfe = null;
            try {
                EventQueue.invokeAndWait(() -> {
                    try {
                        BClass[] bClasses = this.getBPackage().getClasses();
                        int length = bClasses.length;
                        RClass[] rClasses = new RClass[length];
                        for (int i = 0; i < length; ++i) {
                            rClasses[i] = WrapperPool.instance().getWrapper(bClasses[i]);
                        }
                        rclassArrayResult = rClasses;
                    }
                    catch (ProjectNotOpenException e) {
                        pnoe = e;
                    }
                    catch (PackageNotFoundException e) {
                        pnfe = e;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            return rclassArrayResult;
        }
    }

    @Override
    public String getName() throws ProjectNotOpenException, PackageNotFoundException {
        return this.getBPackage().getName();
    }

    @Override
    public RObject getObject(String instanceName) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BObject wrapped = this.getBPackage().getObject(instanceName);
        RObject wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    @Override
    public BObject[] getObjects() throws ProjectNotOpenException, PackageNotFoundException {
        return this.getBPackage().getObjects();
    }

    @Override
    public RProject getProject() throws RemoteException, ProjectNotOpenException {
        return WrapperPool.instance().getWrapper(this.getBPackage().getProject());
    }

    @Override
    public void reload() throws ProjectNotOpenException, PackageNotFoundException {
        final Exception[] exception = new Exception[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        RPackageImpl.this.getBPackage().reload();
                    }
                    catch (ProjectNotOpenException e) {
                        exception[0] = e;
                    }
                    catch (PackageNotFoundException e) {
                        exception[0] = e;
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (exception[0] != null) {
            if (exception[0] instanceof ProjectNotOpenException) {
                throw (ProjectNotOpenException)((Object)exception[0]);
            }
            throw (PackageNotFoundException)((Object)exception[0]);
        }
    }

    @Override
    public File getDir() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.getBPackage().getDir();
    }

    @Override
    public RClass newClass(final String className, final String extension) throws RemoteException, ProjectNotOpenException, PackageNotFoundException, MissingJavaFileException {
        final RClass[] wrapper = new RClass[1];
        final Exception[] exception = new Exception[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        BClass wrapped = RPackageImpl.this.getBPackage().newClass(className, extension);
                        wrapper[0] = WrapperPool.instance().getWrapper(wrapped);
                        RPackageImpl.this.getBPackage().reload();
                    }
                    catch (ProjectNotOpenException pnoe) {
                        exception[0] = pnoe;
                    }
                    catch (PackageNotFoundException pnfe) {
                        exception[0] = pnfe;
                    }
                    catch (MissingJavaFileException mjfe) {
                        exception[0] = mjfe;
                    }
                    catch (RemoteException re) {
                        exception[0] = re;
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (exception[0] != null) {
            if (exception[0] instanceof ProjectNotOpenException) {
                throw (ProjectNotOpenException)((Object)exception[0]);
            }
            if (exception[0] instanceof PackageNotFoundException) {
                throw (PackageNotFoundException)((Object)exception[0]);
            }
            if (exception[0] instanceof MissingJavaFileException) {
                throw (MissingJavaFileException)((Object)exception[0]);
            }
            throw (RemoteException)exception[0];
        }
        return wrapper[0];
    }

    @Override
    public String invokeMethod(String className, String methodName, String[] argTypes, String[] args) {
        Package pkg = this.getPackage();
        Class cl = pkg.loadClass(className);
        for (View mClassView = View.getView((Class)cl); mClassView != null; mClassView = mClassView.getSuper()) {
            MethodView[] methods = mClassView.getDeclaredMethods();
            block1: for (int i = 0; i < methods.length; ++i) {
                if ((methods[i].getModifiers() & 2) != 0 || (methods[i].getModifiers() & 8) == 0 || !methods[i].getName().equals(methodName) || methods[i].getParameterCount() != argTypes.length) continue;
                Class[] params = methods[i].getParameters();
                for (int j = 0; j < params.length; ++j) {
                    if (!params[j].getName().equals(argTypes[j])) continue block1;
                }
                return RPackageImpl.invokeCallable(PkgMgrFrame.findFrame((Package)pkg), (CallableView)methods[i], null, args);
            }
        }
        throw new IllegalArgumentException("method not found");
    }

    @Override
    public String invokeConstructor(String className, String[] argTypes, String[] args) {
        Package pkg = this.getPackage();
        Class cl = pkg.loadClass(className);
        View mClassView = View.getView((Class)cl);
        ConstructorView[] constructors = mClassView.getConstructors();
        block0: for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterCount() != argTypes.length) continue;
            Class[] params = constructors[i].getParameters();
            for (int j = 0; j < params.length; ++j) {
                if (!params[j].getName().equals(argTypes[j])) continue block0;
            }
            return RPackageImpl.invokeCallable(PkgMgrFrame.findFrame((Package)pkg), (CallableView)constructors[i], null, args);
        }
        throw new IllegalArgumentException("constructor not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String invokeCallable(PkgMgrFrame pmf, CallableView cv, ObjectWrapper ow, String[] argVals) {
        InvocationResultWatcher watcher = new InvocationResultWatcher();
        Invoker invoker = ow == null ? new Invoker(pmf, cv, (ResultWatcher)watcher) : new Invoker(pmf, (MethodView)cv, ow, (ResultWatcher)watcher);
        InvocationResultWatcher invocationResultWatcher = watcher;
        synchronized (invocationResultWatcher) {
            invoker.invokeDirect(argVals);
            try {
                watcher.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (watcher.errorMsg != null) {
            return "!" + watcher.errorMsg;
        }
        if (watcher.resultObj == null) {
            return null;
        }
        ObjectWrapper newOw = ObjectWrapper.getWrapper((PkgMgrFrame)pmf, (ObjectBench)pmf.getObjectBench(), (DebuggerObject)watcher.resultObj, (GenTypeClass)watcher.resultObj.getGenType(), (String)"result");
        pmf.getObjectBench().addObject(newOw);
        Package pkg = pmf.getPackage();
        pkg.getDebugger().addObject(pkg.getId(), newOw.getName(), newOw.getObject());
        return newOw.getName();
    }

    private Package getPackage() {
        try {
            Class<?> bPackageClass = this.getBPackage().getClass();
            Field packageId = bPackageClass.getDeclaredField("packageId");
            packageId.setAccessible(true);
            Object identifier = packageId.get(this.getBPackage());
            Class<?> identifierClass = identifier.getClass();
            Method getBluejPackage = identifierClass.getDeclaredMethod("getBluejPackage", new Class[0]);
            getBluejPackage.setAccessible(true);
            Package pkg = (Package)getBluejPackage.invoke(identifier, (Object[])null);
            return pkg;
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return null;
    }

    @Override
    public void close() throws RemoteException {
        try {
            PkgMgrFrame pkgMgrFrame = (PkgMgrFrame)this.getBPackage().getFrame();
            pkgMgrFrame.doClose(false, true);
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
    }

    private BPackage getBPackage() {
        return (BPackage)this.bPackage.get();
    }
}

