/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.CallableView;
import bluej.views.MethodView;
import bluej.views.View;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RPackageImpl;
import rmiextension.wrappers.WrapperPool;

public class RObjectImpl
extends UnicastRemoteObject
implements RObject {
    private final WeakReference<BObject> bObject;

    public RObjectImpl(BObject bObject) throws RemoteException {
        this.bObject = new WeakReference<BObject>(bObject);
        if (bObject == null) {
            throw new NullPointerException("Argument can't be null");
        }
    }

    @Override
    public void addToBench(String instanceName) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        this.getBObject().addToBench(instanceName);
    }

    @Override
    public RClass getRClass() throws ProjectNotOpenException, ClassNotFoundException, RemoteException, PackageNotFoundException {
        BClass wrapped = this.getBObject().getBClass();
        RClass wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    @Override
    public String getInstanceName() throws RemoteException {
        return this.getBObject().getInstanceName();
    }

    @Override
    public RPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BPackage wrapped = this.getBObject().getPackage();
        RPackage wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    @Override
    public void removeFromBench() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        this.getBObject().removeFromBench();
    }

    @Override
    public String invokeMethod(String method, String[] argTypes, String[] argVals) throws RemoteException {
        try {
            Class<BObject> BObjectClass = BObject.class;
            Field oWrapperField = BObjectClass.getDeclaredField("objectWrapper");
            oWrapperField.setAccessible(true);
            ObjectWrapper ow = (ObjectWrapper)oWrapperField.get(this.getBObject());
            String className = ow.getObject().getClassName();
            PkgMgrFrame pmf = ow.getFrame();
            Class oClass = ow.getPackage().loadClass(className);
            for (View mClassView = View.getView((Class)oClass); mClassView != null; mClassView = mClassView.getSuper()) {
                MethodView[] methods = mClassView.getDeclaredMethods();
                block4: for (int i = 0; i < methods.length; ++i) {
                    if ((methods[i].getModifiers() & 2) != 0 || !methods[i].getName().equals(method) || methods[i].getParameterCount() != argTypes.length) continue;
                    Class[] params = methods[i].getParameters();
                    for (int j = 0; j < params.length; ++j) {
                        if (!params[j].getName().equals(argTypes[j])) continue block4;
                    }
                    return RPackageImpl.invokeCallable(pmf, (CallableView)methods[i], ow, argVals);
                }
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        throw new IllegalArgumentException("method not found.");
    }

    private BObject getBObject() {
        return (BObject)this.bObject.get();
    }
}

