/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.extensions.BClass;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BMethod;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.extensions.editor.Editor;
import bluej.extensions.editor.EditorBridge;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.WrapperPool;

public class RClassImpl
extends UnicastRemoteObject
implements RClass {
    private BClass bClass;
    private static ProjectNotOpenException pnoe;
    private static PackageNotFoundException pnfe;

    RClassImpl(BClass bClass) throws RemoteException {
        this.bClass = bClass;
        if (bClass == null) {
            throw new NullPointerException("Argument can't be null");
        }
    }

    @Override
    public void compile(boolean waitCompileEnd, boolean forceQuiet) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.bClass.compile(waitCompileEnd, forceQuiet);
    }

    @Override
    public SourceType getSourceType() throws ProjectNotOpenException, PackageNotFoundException {
        return this.bClass.getSourceType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void edit() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            EventQueue.invokeLater(() -> {
                try {
                    Editor editor = this.bClass.getEditor();
                    if (editor != null) {
                        editor.setVisible(true);
                    }
                }
                catch (ProjectNotOpenException e) {
                    pnoe = e;
                }
                catch (PackageNotFoundException e) {
                    pnfe = e;
                }
            });
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEditor() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            EventQueue.invokeLater(() -> {
                try {
                    Editor editor = this.bClass.getEditor();
                    if (editor != null) {
                        editor.setVisible(false);
                    }
                }
                catch (ProjectNotOpenException e) {
                    pnoe = e;
                }
                catch (PackageNotFoundException e) {
                    pnfe = e;
                }
            });
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void showMessage(String message) throws RemoteException, ProjectNotOpenException, PackageNotFoundException {
        Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(() -> EditorBridge.getEditor((Editor)e).writeMessage(message));
    }

    @Override
    public void insertAppendMethod(String method, boolean showEditorOnCreate, boolean showEditorOnAppend) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(() -> EditorBridge.getEditor((Editor)e).insertAppendMethod(e, (NormalMethodElement)this.loadElement(method), inserted -> {
            if (inserted.booleanValue() && showEditorOnAppend) {
                EventQueue.invokeLater(() -> e.setVisible(true));
            } else if (!inserted.booleanValue() && showEditorOnCreate) {
                EventQueue.invokeLater(() -> e.setVisible(true));
            }
        }));
    }

    @Override
    public void insertMethodCallInConstructor(String methodCall, boolean showEditor) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Editor e = this.bClass.getEditor();
        String className = this.bClass.getName();
        EventQueue.invokeLater(() -> EditorBridge.getEditor((Editor)e).insertMethodCallInConstructor(e, className, (CallElement)this.loadElement(methodCall), inserted -> {
            if (showEditor && inserted.booleanValue()) {
                EventQueue.invokeLater(() -> e.setVisible(true));
            }
        }));
    }

    private CodeElement loadElement(String elementString) {
        return Loader.loadElement((String)elementString);
    }

    @Override
    public RConstructor getConstructor(Class<?>[] signature) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor bConstructor = this.bClass.getConstructor((Class[])signature);
        RConstructor rConstructor = WrapperPool.instance().getWrapper(bConstructor);
        return rConstructor;
    }

    @Override
    public RConstructor[] getConstructors() throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor[] bConstructors = this.bClass.getConstructors();
        int length = bConstructors.length;
        RConstructor[] rConstructors = new RConstructor[length];
        for (int i = 0; i < length; ++i) {
            rConstructors[i] = WrapperPool.instance().getWrapper(bConstructors[i]);
        }
        return rConstructors;
    }

    @Override
    public BMethod getDeclaredMethod(String methodName, Class<?>[] params) throws ProjectNotOpenException, ClassNotFoundException {
        return null;
    }

    @Override
    public BMethod[] getDeclaredMethods() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getDeclaredMethods();
    }

    @Override
    public RField getField(String fieldName) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BField wrapped = this.bClass.getField(fieldName);
        RField wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    @Override
    public BField[] getFields() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getFields();
    }

    @Override
    public RPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BPackage wrapped = this.bClass.getPackage();
        RPackage wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RClass getSuperclass(boolean inRemoteCallback) throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        if (!inRemoteCallback) {
            Class<RClassImpl> clazz = RClassImpl.class;
            synchronized (RClassImpl.class) {
                BClass[] wrapped = new BClass[1];
                ClassNotFoundException[] cnfe = new ClassNotFoundException[1];
                pnoe = null;
                pnfe = null;
                try {
                    EventQueue.invokeAndWait(() -> {
                        try {
                            wrapped[0] = this.bClass.getSuperclass();
                        }
                        catch (ProjectNotOpenException e) {
                            pnoe = e;
                        }
                        catch (PackageNotFoundException e) {
                            pnfe = e;
                        }
                        catch (ClassNotFoundException e) {
                            cnfe[0] = e;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (InvocationTargetException ite) {
                    throw new RuntimeException(ite.getCause());
                }
                if (pnoe != null) {
                    throw pnoe;
                }
                if (pnfe != null) {
                    throw pnfe;
                }
                if (cnfe[0] != null) {
                    throw cnfe[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return WrapperPool.instance().getWrapper(wrapped[0]);
            }
        }
        BClass sc = this.bClass.getSuperclass();
        return WrapperPool.instance().getWrapper(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompiled(boolean inRemoteCallback) throws ProjectNotOpenException, PackageNotFoundException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            boolean[] result = new boolean[1];
            try {
                Runnable r = () -> {
                    try {
                        result[0] = this.bClass.isCompiled();
                    }
                    catch (ProjectNotOpenException e) {
                        pnoe = e;
                    }
                    catch (PackageNotFoundException e) {
                        pnfe = e;
                    }
                };
                if (inRemoteCallback) {
                    r.run();
                } else {
                    EventQueue.invokeAndWait(r);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result[0];
        }
    }

    public String getToString() {
        return this.bClass.getName();
    }

    @Override
    public String getQualifiedName() throws RemoteException {
        return this.bClass.getName();
    }

    @Override
    public File getJavaFile() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.bClass.getJavaFile();
    }

    @Override
    public void remove() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        this.bClass.remove();
    }

    @Override
    public void removeStrideFile() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        this.bClass.removeStrideFile();
    }

    @Override
    public void setReadOnly(boolean b) throws RemoteException, ProjectNotOpenException, PackageNotFoundException {
        if (this.bClass != null && this.bClass.getEditor() != null) {
            this.bClass.getEditor().setReadOnly(b);
        }
    }

    @Override
    public void autoIndent() throws ProjectNotOpenException, PackageNotFoundException {
        Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(() -> {
            MoeEditor bje = (MoeEditor)EditorBridge.getEditor((Editor)e);
            MoeSyntaxDocument doc = bje.getSourceDocument();
            MoeIndent.calculateIndentsAndApply((MoeSyntaxDocument)doc, (int)0);
        });
    }

    @Override
    public void cancelFreshState() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        this.bClass.getEditor().cancelFreshState();
    }
}

