/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.Boot;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugmgr.ResultWatcher;
import bluej.extensions.BObject;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import bluej.pkgmgr.DocPathEntry;
import bluej.pkgmgr.Project;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import greenfoot.core.GreenfootLauncherDebugVM;
import greenfoot.core.GreenfootMain;
import greenfoot.core.ProjectProperties;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rmiextension.BlueJRMIServer;
import rmiextension.GreenfootDebugHandler;
import rmiextension.ObjectBench;
import rmiextension.wrappers.RProjectImpl;
import rmiextension.wrappers.WrapperPool;

public class ProjectManager
implements PackageListener {
    private static ProjectManager instance;
    private List<BPackage> openedPackages = new ArrayList<BPackage>();
    private List<File> projectsInCreation = new ArrayList<File>();
    private Map<File, RProjectImpl> openedProjects = new HashMap<File, RProjectImpl>();
    private String launchClass = GreenfootLauncherDebugVM.class.getName();
    private static final String launcherName = "greenfootLauncher";
    private static BlueJ bluej;
    private static volatile boolean launchFailed;
    boolean wizard;
    SourceType sourceType;

    private ProjectManager() {
    }

    public static ProjectManager instance() {
        if (bluej == null) {
            throw new IllegalStateException("Projectmanager has not been initialised.");
        }
        return instance;
    }

    public static void init(BlueJ bluej) {
        ProjectManager.bluej = bluej;
        instance = new ProjectManager();
    }

    private void launchProject(BProject project) {
        File projectDir;
        try {
            projectDir = project.getDir();
        }
        catch (ProjectNotOpenException pnoe) {
            return;
        }
        int versionOK = this.checkVersion(projectDir);
        if (versionOK != 2) {
            try {
                File apiDir;
                File langlib;
                if (versionOK == 1) {
                    project.getPackage("").reload();
                }
                GreenfootDebugHandler.addDebuggerListener(project);
                Project bjProject = Project.getProject((File)project.getDir());
                List sourcePath = bjProject.getSourcePath();
                String language = Config.getPropString((String)"bluej.language");
                if (!language.equals("english")) {
                    langlib = new File(Config.getBlueJLibDir(), language);
                    apiDir = new File(new File(langlib, "greenfoot"), "api");
                    sourcePath.add(new DocPathEntry(apiDir, ""));
                }
                langlib = new File(Config.getBlueJLibDir(), "english");
                apiDir = new File(new File(langlib, "greenfoot"), "api");
                sourcePath.add(new DocPathEntry(apiDir, ""));
            }
            catch (PackageNotFoundException | ProjectNotOpenException e) {
                Debug.reportError((String)"Could not create greenfoot launcher.", (Throwable)e);
                ProjectManager.greenfootLaunchFailed(project);
            }
        } else {
            try {
                project.close();
            }
            catch (ProjectNotOpenException e) {
                // empty catch block
            }
            if (bluej.getOpenProjects().length == 0) {
                File startupProject = new File(bluej.getSystemLibDir(), "startupProject");
                bluej.openProject(startupProject);
            }
        }
    }

    public static boolean checkLaunchFailed() {
        return launchFailed;
    }

    public void openGreenfoot(final BProject project) {
        try {
            final BPackage pkg = project.getPackage("");
            ResultWatcher watcher = new ResultWatcher(){

                public void beginCompile() {
                }

                public void beginExecution(InvokerRecord ir) {
                }

                public void putError(String message, InvokerRecord ir) {
                    Debug.message((String)("Greenfoot launch failed with error: " + message));
                    ProjectManager.greenfootLaunchFailed(project);
                }

                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    Debug.message((String)("Greenfoot launch failed due to exception in debug VM: " + exception.getText()));
                    ProjectManager.greenfootLaunchFailed(project);
                }

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    try {
                        BObject bObject = pkg.getObject(name);
                        RProjectImpl rProject = WrapperPool.instance().getWrapper(project);
                        rProject.setTransportObject(bObject);
                    }
                    catch (ProjectNotOpenException bObject) {
                    }
                    catch (PackageNotFoundException bObject) {
                    }
                    catch (RemoteException re) {
                        Debug.reportError((String)"Unexpected exception getting remote project wrapper", (Throwable)re);
                    }
                }

                public void putVMTerminated(InvokerRecord ir) {
                    Debug.message((String)"Greenfoot launch failed due to debug VM terminating.");
                    ProjectManager.greenfootLaunchFailed(project);
                }
            };
            ObjectBench.createObject(pkg, this.launchClass, launcherName, new String[]{project.getDir().getPath(), BlueJRMIServer.getBlueJService(), String.valueOf(this.wizard), String.valueOf(this.sourceType)}, watcher);
            this.wizard = false;
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    public static void greenfootLaunchFailed(BProject project) {
        launchFailed = true;
        String text = Config.getString((String)"greenfoot.launchFailed");
        DialogManager.showErrorText(null, (String)text);
        System.exit(1);
    }

    private int checkVersion(File projectDir) {
        if (this.isNewProject(projectDir)) {
            ProjectProperties newProperties = new ProjectProperties(projectDir);
            newProperties.setApiVersion(Boot.GREENFOOT_API_VERSION);
            newProperties.save();
        }
        return GreenfootMain.updateApi(projectDir, null, Boot.GREENFOOT_API_VERSION);
    }

    private boolean isNewProject(File projectDir) {
        return this.projectsInCreation.contains(projectDir);
    }

    public void addNewProject(File projectDir) {
        this.projectsInCreation.add(projectDir);
    }

    public void removeNewProject(File projectDir) {
        this.projectsInCreation.remove(projectDir);
    }

    private boolean isProjectOpen(BProject prj) {
        File prjFile = null;
        try {
            prjFile = prj.getDir();
        }
        catch (ProjectNotOpenException pnoe) {
            return false;
        }
        return this.openedProjects.get(prjFile) != null;
    }

    public void packageOpened(PackageEvent event) {
        try {
            BPackage pkg = event.getPackage();
            BProject project = pkg.getProject();
            if (!this.isProjectOpen(project)) {
                this.openedProjects.put(project.getDir(), WrapperPool.instance().getWrapper(project));
                this.launchProject(project);
            }
            this.openedPackages.add(event.getPackage());
        }
        catch (ProjectNotOpenException pkg) {
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Remote exception when package opened", (Throwable)re);
        }
    }

    public void packageClosing(PackageEvent event) {
        try {
            BProject project = event.getPackage().getProject();
            this.openedPackages.remove(event.getPackage());
            for (BPackage pkg : this.openedPackages) {
                try {
                    if (pkg.getProject() != project) continue;
                    return;
                }
                catch (ProjectNotOpenException projectNotOpenException) {
                }
            }
            this.openedProjects.remove(project.getDir());
        }
        catch (ProjectNotOpenException projectNotOpenException) {
            // empty catch block
        }
    }

    public void setWizard(boolean wizard) {
        this.wizard = wizard;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    static {
        launchFailed = false;
    }
}

