/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaReflective;
import com.sun.jdi.ObjectReference;
import greenfoot.localdebugger.LocalArray;
import greenfoot.localdebugger.LocalBooleanArray;
import greenfoot.localdebugger.LocalByteArray;
import greenfoot.localdebugger.LocalCharArray;
import greenfoot.localdebugger.LocalClass;
import greenfoot.localdebugger.LocalDoubleArray;
import greenfoot.localdebugger.LocalField;
import greenfoot.localdebugger.LocalFloatArray;
import greenfoot.localdebugger.LocalIntArray;
import greenfoot.localdebugger.LocalLongArray;
import greenfoot.localdebugger.LocalShortArray;
import greenfoot.util.DebugUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LocalObject
extends DebuggerObject {
    private static Field[] noFields = new Field[0];
    protected Object object;
    private Map<String, GenTypeParameter> genericParams = null;

    public static LocalObject getLocalObject(Object o) {
        if (o != null && o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return new LocalBooleanArray((boolean[])o);
            }
            if (o instanceof byte[]) {
                return new LocalByteArray((byte[])o);
            }
            if (o instanceof char[]) {
                return new LocalCharArray((char[])o);
            }
            if (o instanceof int[]) {
                return new LocalIntArray((int[])o);
            }
            if (o instanceof long[]) {
                return new LocalLongArray((long[])o);
            }
            if (o instanceof short[]) {
                return new LocalShortArray((short[])o);
            }
            if (o instanceof float[]) {
                return new LocalFloatArray((float[])o);
            }
            if (o instanceof double[]) {
                return new LocalDoubleArray((double[])o);
            }
            return new LocalArray((Object[])o);
        }
        return new LocalObject(o);
    }

    public static LocalObject getLocalObject(Object o, Map<String, GenTypeParameter> genericParams) {
        if (o != null && o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return new LocalBooleanArray((boolean[])o);
            }
            if (o instanceof byte[]) {
                return new LocalByteArray((byte[])o);
            }
            if (o instanceof char[]) {
                return new LocalCharArray((char[])o);
            }
            if (o instanceof int[]) {
                return new LocalIntArray((int[])o);
            }
            if (o instanceof long[]) {
                return new LocalLongArray((long[])o);
            }
            if (o instanceof short[]) {
                return new LocalShortArray((short[])o);
            }
            if (o instanceof float[]) {
                return new LocalFloatArray((float[])o);
            }
            if (o instanceof double[]) {
                return new LocalDoubleArray((double[])o);
            }
            return new LocalArray((Object[])o);
        }
        return new LocalObject(o, genericParams);
    }

    protected LocalObject(Object o) {
        this.object = o;
    }

    protected LocalObject(Object o, Map<String, GenTypeParameter> genericParams) {
        this.object = o;
        this.genericParams = genericParams;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LocalObject) {
            Object otherObj = ((LocalObject)((Object)other)).object;
            return this.object.equals(otherObj);
        }
        return false;
    }

    public String getClassName() {
        if (this.object != null) {
            return this.object.getClass().getName();
        }
        return "";
    }

    public DebuggerClass getClassRef() {
        return new LocalClass(this.object.getClass());
    }

    public GenTypeClass getGenType() {
        JavaReflective r = new JavaReflective(this.object.getClass());
        if (this.genericParams != null) {
            return new GenTypeClass((Reflective)r, this.genericParams);
        }
        return new GenTypeClass((Reflective)r);
    }

    public boolean isArray() {
        return this.object.getClass().isArray();
    }

    public boolean isNullObject() {
        return this.object == null;
    }

    public int getElementCount() {
        return -1;
    }

    public DebuggerObject getElementObject(int index) {
        return null;
    }

    public JavaType getElementType() {
        return null;
    }

    public String getElementValueString(int index) {
        return null;
    }

    public List<DebuggerField> getFields() {
        Field[] fields = this.getAllFields();
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<DebuggerField> rlist = new ArrayList<DebuggerField>(fields.length);
        Field[] fieldArray = fields;
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field;
            boolean visible = usedNames.add((field = fieldArray[i]).getName());
            rlist.add(new LocalField(this, field, !visible));
        }
        return rlist;
    }

    private Field[] getAllFields() {
        if (this.object == null) {
            return noFields;
        }
        ArrayList<AccessibleObject> allFields = new ArrayList<AccessibleObject>();
        for (Class<?> c = this.object.getClass(); c != null; c = c.getSuperclass()) {
            AccessibleObject[] declFields = c.getDeclaredFields();
            AccessibleObject.setAccessible(declFields, true);
            for (int j = 0; j < declFields.length; ++j) {
                AccessibleObject field = declFields[j];
                if (!this.keepField(c, (Field)field)) continue;
                allFields.add(field);
            }
        }
        return allFields.toArray(noFields);
    }

    public ObjectReference getObjectReference() {
        return null;
    }

    private boolean keepField(Class<?> cls, Field field) {
        List<String> fieldWhitelist = DebugUtil.restrictedClasses().get(cls);
        if (fieldWhitelist != null) {
            return fieldWhitelist.contains(field.getName());
        }
        return true;
    }

    public Object getObject() {
        return this.object;
    }
}

