/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.images;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.Debug;
import greenfoot.gui.EditableList;
import greenfoot.gui.MessageDialog;
import greenfoot.gui.images.ImageLibFrame;
import greenfoot.util.GraphicsUtilities;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.Selectable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ImageLibList
extends EditableList<ImageListEntry>
implements Selectable<File> {
    private File directory;
    private int prefHeight = 200;
    private LinkedList<ImageListEntry> data;
    private ImageLibFrame imageLibFrame;
    private int minWidth;
    private BufferedImage defaultImage;

    public ImageLibList(boolean editable, ImageLibFrame imageLibFrame) {
        super(editable);
        this.imageLibFrame = imageLibFrame;
        JLabel widthCalc = new JLabel("XXXXXXXXXXXXXXXXXXXXXXX");
        this.minWidth = widthCalc.getPreferredSize().width;
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new MyCellRenderer());
        tableColumn.setCellEditor(new MyCellEditor(new JTextField()));
        if (!editable) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() >= 2 && ImageLibList.this.getSelectedValue() != null && ImageLibList.this.getRootPane().getDefaultButton() != null) {
                        ImageLibList.this.getRootPane().getDefaultButton().doClick();
                    }
                }
            });
        }
    }

    public ImageLibList(File directory, boolean editable, ImageLibFrame imageLibFrame, BufferedImage defaultImage) {
        this(editable, imageLibFrame);
        this.defaultImage = defaultImage;
        this.setDirectory(directory);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        FilenameFilter filter = (dir, name) -> true;
        Object[] imageFiles = directory.listFiles(filter);
        if (imageFiles == null) {
            imageFiles = new File[]{};
        }
        Arrays.sort(imageFiles);
        this.data = new LinkedList();
        this.data.add(new ImageListEntry(this.defaultImage));
        for (int i = 0; i < imageFiles.length; ++i) {
            int height;
            ImageListEntry entry = new ImageListEntry((File)imageFiles[i], true);
            this.data.add(entry);
            Icon icon = entry.imageIcon;
            if (icon == null || (height = entry.imageIcon.getIconHeight()) <= this.getRowHeight()) continue;
            this.setRowHeight(height);
        }
        this.setListData(this.data);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void refresh() {
        if (this.getDirectory() != null) {
            this.setDirectory(this.getDirectory());
        }
    }

    public void refreshPreviews() {
        boolean anyReloaded = false;
        for (ImageListEntry entry : this.data) {
            boolean reloaded = entry.refreshPreview();
            anyReloaded |= reloaded;
        }
        if (anyReloaded) {
            this.repaint();
        }
    }

    @Override
    public void select(File imageFile) {
        this.refresh();
        int row = this.setSelectedValue(new ImageListEntry(imageFile, false));
        this.ensureIndexIsVisible(row);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        if (d.height > this.prefHeight) {
            d.height = this.prefHeight;
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Math.max(d.width, this.minWidth);
        return d;
    }

    public ImageListEntry[] getSelectedValues() {
        Object[] list = super.getSelectedValues();
        ImageListEntry[] entries = new ImageListEntry[list.length];
        for (int i = 0; i < list.length; ++i) {
            entries[i] = (ImageListEntry)list[i];
        }
        return entries;
    }

    public class ImageListEntry {
        public File imageFile;
        public Icon imageIcon;
        private long lastModified;

        private ImageListEntry(BufferedImage def) {
            this.imageFile = null;
            this.imageIcon = this.getPreview(def);
        }

        public boolean refreshPreview() {
            if (this.imageFile != null && this.imageFile.lastModified() != this.lastModified) {
                this.loadPreview();
                return true;
            }
            return false;
        }

        private ImageListEntry(File file, boolean loadImage) {
            this.imageFile = file;
            if (loadImage) {
                this.loadPreview();
            }
        }

        private void loadPreview() {
            if (this.imageFile != null) {
                this.lastModified = this.imageFile.lastModified();
                try {
                    this.imageIcon = this.getPreview(ImageIO.read(this.imageFile));
                }
                catch (IOException e) {
                    Debug.reportError((Throwable)e);
                }
            }
        }

        private ImageIcon getPreview(BufferedImage image) {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            try {
                if (image != null) {
                    Image scaledImage = GreenfootUtil.getScaledImage(image, dpi / 3, dpi / 3);
                    return new ImageIcon(scaledImage);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return new ImageIcon(GraphicsUtilities.createCompatibleTranslucentImage(dpi / 3, dpi / 3));
        }

        public boolean equals(Object other) {
            if (!(other instanceof ImageListEntry)) {
                return false;
            }
            ImageListEntry otherEntry = (ImageListEntry)other;
            if (otherEntry.imageFile == null && this.imageFile == null) {
                return true;
            }
            if (otherEntry.imageFile == null || this.imageFile == null) {
                return false;
            }
            return otherEntry.imageFile.equals(this.imageFile);
        }

        public int hashCode() {
            return this.imageFile.hashCode();
        }
    }

    private static class MyCellRenderer
    extends DefaultTableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MyCellRenderer item = this;
            if (value != null) {
                ImageListEntry entry = (ImageListEntry)value;
                if (null == entry.imageFile) {
                    item.setText("Unspecified");
                } else {
                    item.setText(entry.imageFile.getName());
                }
                item.setIcon(entry.imageIcon);
            }
            if (isSelected) {
                ((JComponent)item).setBackground(table.getSelectionBackground());
                ((JComponent)item).setForeground(table.getSelectionForeground());
            } else {
                ((JComponent)item).setBackground(table.getBackground());
                ((JComponent)item).setForeground(table.getForeground());
            }
            item.setEnabled(table.isEnabled());
            item.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                item.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        super.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(col);
                    }
                }
            } else {
                item.setBorder(noFocusBorder);
            }
            item.setOpaque(true);
            return item;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width += 5;
            return d;
        }
    }

    private static class MyCellEditor
    extends DefaultCellEditor {
        public MyCellEditor(final JTextField textField) {
            super(textField);
            textField.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private ImageListEntry value;

                @Override
                public void setValue(Object value) {
                    this.value = (ImageListEntry)value;
                    textField.setText(this.value != null ? this.value.imageFile.getName() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    String fileName = textField.getText();
                    File oldFile = this.value.imageFile;
                    File newFile = new File(oldFile.getParent(), fileName);
                    if (!oldFile.equals(newFile) && newFile.exists()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog msg = new MessageDialog((Frame)null, Config.getString((String)"imagelib.rename.exists.text"), Config.getString((String)"imagelib.rename.exists.title"), 100, new JButton[]{BlueJTheme.getCloseButton()});
                                msg.displayModal();
                            }
                        });
                    } else {
                        boolean success = oldFile.renameTo(newFile);
                        if (success) {
                            this.value.imageFile = newFile;
                        }
                    }
                    return this.value;
                }
            };
            textField.addActionListener(this.delegate);
        }
    }
}

