/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.Config;
import greenfoot.gui.export.LeftRightBorder;
import greenfoot.gui.export.TabbedIconPaneListener;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TabbedIconPane
extends JPanel
implements ActionListener {
    private static final Color backgroundColor = new Color(250, 250, 250);
    private static final Color selectedColor = new Color(220, 220, 220);
    private static final Color lineColor = new Color(180, 180, 180);
    private static final Border emptyBorder = new EmptyBorder(4, 10, 4, 10);
    private static final Border selectedBorder = new CompoundBorder(new LeftRightBorder(lineColor), new EmptyBorder(3, 9, 3, 9));
    private JRadioButton selected;
    private TabbedIconPaneListener listener;
    private Map<String, JRadioButton> buttons = new HashMap<String, JRadioButton>();

    public TabbedIconPane(String initialSelect) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(backgroundColor);
        this.add(this.makeButtonRow(initialSelect));
    }

    public void setListener(TabbedIconPaneListener listener) {
        this.listener = listener;
    }

    private JPanel makeButtonRow(String initialSelect) {
        JPanel panel = new JPanel(new FlowLayout(1, 0, 0));
        panel.setBorder(null);
        panel.setBackground(backgroundColor);
        this.makeButton(Config.getString((String)"export.icontab.publish"), "export-publish", "PUBLISH", initialSelect, panel);
        this.makeButton(Config.getString((String)"export.icontab.webpage"), "export-webpage", "WEB", initialSelect, panel);
        this.makeButton(Config.getString((String)"export.icontab.application"), "export-app", "APP", initialSelect, panel);
        this.makeButton(Config.getString((String)"export.icontab.project"), "export-project", "PROJECT", initialSelect, panel);
        return panel;
    }

    private JRadioButton makeButton(String text, String iconName, String command, String selectCommand, JPanel parent) {
        URL iconFile = this.getClass().getClassLoader().getResource(iconName + ".png");
        ImageIcon icon = null;
        if (iconFile != null) {
            icon = new ImageIcon(iconFile);
        }
        JRadioButton toggle = new JRadioButton(text, icon);
        toggle.setHorizontalTextPosition(0);
        toggle.setVerticalTextPosition(3);
        toggle.setActionCommand(command);
        toggle.addActionListener(this);
        toggle.setOpaque(false);
        this.buttons.put(command, toggle);
        JPanel panel = new JPanel();
        panel.setBackground(backgroundColor);
        panel.setBorder(emptyBorder);
        panel.add(toggle);
        parent.add(panel);
        if (command.equals(selectCommand)) {
            toggle.setSelected(true);
            this.select(toggle);
        }
        return toggle;
    }

    public void select(String function) {
        JRadioButton button = this.buttons.get(function);
        if (button != null) {
            TabbedIconPane.deselect(this.selected);
            this.select(button);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TabbedIconPane.deselect(this.selected);
        JRadioButton button = (JRadioButton)e.getSource();
        this.select(button);
        this.listener.tabSelected(e.getActionCommand());
    }

    private void select(JRadioButton button) {
        JPanel parent = (JPanel)button.getParent();
        parent.setBackground(selectedColor);
        parent.setBorder(selectedBorder);
        this.selected = button;
    }

    private static void deselect(JRadioButton button) {
        JPanel parent = (JPanel)button.getParent();
        parent.setBackground(backgroundColor);
        parent.setBorder(emptyBorder);
    }
}

