/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.BlueJTheme;
import bluej.Config;
import greenfoot.gui.export.ExportPane;
import greenfoot.util.FileChoosers;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportWebPagePane
extends ExportPane {
    public static final String FUNCTION = "WEB";
    private static final String helpLine1 = Config.getString((String)"export.web.help");
    private static final String exportLocationLabelText = Config.getString((String)"export.web.exportLocation");
    private JTextField targetDirField;

    public ExportWebPagePane(String scenarioName, File defaultExportDir) {
        File exportDir = new File(defaultExportDir, scenarioName + "-export");
        if (exportDir.exists()) {
            exportDir.delete();
        }
        this.makePane(exportDir);
    }

    public String getExportLocation() {
        return this.targetDirField.getText();
    }

    private void makePane(final File defaultDir) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.dialogBorder);
        this.setBackground(backgroundColor);
        this.targetDirField = new JTextField(defaultDir.toString(), 24);
        this.targetDirField.setEditable(false);
        JLabel helpText1 = new JLabel(helpLine1);
        this.add(helpText1);
        this.add(Box.createVerticalStrut(10));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        inputPanel.setAlignmentX(0.0f);
        inputPanel.setBackground(backgroundColor);
        inputPanel.add(Box.createVerticalStrut(5));
        JPanel exportLocationPanel = new JPanel(new FlowLayout(0));
        exportLocationPanel.setBackground(backgroundColor);
        JLabel exportLocationLabel = new JLabel(exportLocationLabelText);
        exportLocationPanel.add(exportLocationLabel);
        exportLocationPanel.add(this.targetDirField);
        JButton browse = new JButton(Config.getString((String)"export.web.browse"));
        exportLocationPanel.add(browse);
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = FileChoosers.getFileName(ExportWebPagePane.this, defaultDir, Config.getString((String)"export.web.choose"));
                if (file != null) {
                    ExportWebPagePane.this.targetDirField.setText(file.getPath());
                }
            }
        });
        exportLocationPanel.setAlignmentX(0.0f);
        inputPanel.add(exportLocationPanel);
        inputPanel.add(Box.createVerticalStrut(4));
        inputPanel.add(this.lockScenario);
        this.add(inputPanel);
    }

    @Override
    public void activated() {
    }

    @Override
    public boolean prePublish() {
        return true;
    }

    @Override
    public void postPublish(boolean success) {
    }
}

