/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.export;

import bluej.BlueJTheme;
import bluej.Config;
import greenfoot.gui.export.ExportPane;
import greenfoot.util.FileChoosers;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportProjectPane
extends ExportPane {
    public static final String FUNCTION = "PROJECT";
    private static final String helpLine1 = Config.getString((String)"export.project.help");
    private static final String exportLocationLabelText = Config.getString((String)"export.project.location");
    private JTextField targetDirField;

    public ExportProjectPane(String scenarioName, File defaultExportDir) {
        File targetFile = new File(defaultExportDir, scenarioName + ".gfar");
        this.makePane(targetFile);
    }

    public String getExportName() {
        return this.targetDirField.getText();
    }

    private void makePane(final File targetFile) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.dialogBorder);
        this.setBackground(backgroundColor);
        this.targetDirField = new JTextField(targetFile.toString(), 26);
        this.targetDirField.setEditable(false);
        JLabel helpText1 = new JLabel(helpLine1);
        this.add(helpText1);
        this.add(Box.createVerticalStrut(10));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        inputPanel.setAlignmentX(0.0f);
        inputPanel.setBackground(backgroundColor);
        inputPanel.add(Box.createVerticalStrut(5));
        JPanel exportLocationPanel = new JPanel(new FlowLayout(0));
        exportLocationPanel.setBackground(backgroundColor);
        JLabel exportLocationLabel = new JLabel(exportLocationLabelText);
        exportLocationPanel.add(exportLocationLabel);
        exportLocationPanel.add(this.targetDirField);
        JButton browse = new JButton(Config.getString((String)"export.project.browse"));
        exportLocationPanel.add(browse);
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportProjectPane.this.getFileName(targetFile);
            }
        });
        exportLocationPanel.setAlignmentX(0.0f);
        inputPanel.add(exportLocationPanel);
        inputPanel.add(Box.createVerticalStrut(5));
        this.add(inputPanel);
    }

    private void getFileName(File targetFile) {
        File file = FileChoosers.getFileName(this, targetFile, Config.getString((String)"export.project.choose"));
        if (file != null) {
            String title;
            String message;
            int result;
            String newName = file.getPath();
            if (!newName.endsWith(".gfar")) {
                if (!newName.toLowerCase().endsWith(".gfar")) {
                    newName = newName + ".gfar";
                } else {
                    newName = newName.substring(0, newName.length() - ".gfar".length());
                    newName = newName + ".gfar";
                }
            }
            this.targetDirField.setText(newName);
            if (file.exists() && (result = JOptionPane.showConfirmDialog(this, message = newName + " " + Config.getString((String)"export.fileExists.message"), title = "Warning", 0)) == 1) {
                this.getFileName(targetFile);
                return;
            }
        }
    }

    @Override
    public void activated() {
    }

    @Override
    public boolean prePublish() {
        return true;
    }

    @Override
    public void postPublish(boolean success) {
    }
}

