/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser.role;

import bluej.Config;
import bluej.extensions.SourceType;
import greenfoot.actions.SelectImageAction;
import greenfoot.actions.ShowApiDocAction;
import greenfoot.core.GProject;
import greenfoot.event.WorldEvent;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import greenfoot.record.InteractionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class ActorClassRole
extends ImageClassRole {
    private final String templatePrefix = "actor";
    private static final String newline = System.getProperty("line.separator");
    public static final String imports = "import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)" + newline;
    private List<Action> constructorItems = new ArrayList<Action>();
    private boolean enableConstructors = false;

    public ActorClassRole(GProject project) {
        super(project);
    }

    @Override
    public List<Action> createConstructorActions(Class<?> realClass, GProject project, InteractionListener interactionListener) {
        List<Action> realActions = super.createConstructorActions(realClass, project, interactionListener);
        this.constructorItems = new ArrayList<Action>();
        for (Action realAction : realActions) {
            Action tempAction = this.createDragProxyAction(realAction);
            tempAction.setEnabled(this.enableConstructors);
            this.constructorItems.add(tempAction);
        }
        return this.constructorItems;
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menu, boolean coreClass) {
        if (!coreClass) {
            menu.add(this.createMenuItem(new SelectImageAction(this.classView, this)));
        } else {
            menu.add(this.createMenuItem(new ShowApiDocAction(Config.getString((String)"show.apidoc"), "greenfoot/Actor.html")));
        }
    }

    @Override
    public String getTemplateFileName(boolean useInterface, SourceType language) {
        return "actor" + language + ".tmpl";
    }

    @Override
    public void worldCreated(WorldEvent e) {
        this.enableConstructors = true;
        for (Action action : this.constructorItems) {
            action.setEnabled(true);
        }
    }

    @Override
    public void worldRemoved(WorldEvent e) {
        this.enableConstructors = false;
        for (Action action : this.constructorItems) {
            action.setEnabled(false);
        }
    }
}

