/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extensions.SourceType;
import bluej.utility.EscapeDialog;
import greenfoot.core.GPackage;
import greenfoot.event.ValidityEvent;
import greenfoot.event.ValidityListener;
import greenfoot.gui.ClassNameVerifier;
import greenfoot.util.GreenfootUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewClassDialog
extends EscapeDialog {
    private JTextField classNameTextField;
    private JComboBox<SourceType> languageSelectionBox;
    private boolean okPressed = false;
    private boolean useInterface;

    public NewClassDialog(JFrame parent, GPackage pkg) {
        super((Frame)parent, Config.getString((String)"newclass.dialog.title"), true);
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.generalBorder);
        JLabel helpLabel1 = GreenfootUtil.createHelpLabel();
        JLabel helpLabel2 = GreenfootUtil.createHelpLabel();
        helpLabel1.setText(Config.getString((String)"newclass.dialog.help1"));
        helpLabel2.setText(Config.getString((String)"newclass.dialog.help2"));
        helpLabel1.setAlignmentX(0.0f);
        helpLabel2.setAlignmentX(0.0f);
        mainPanel.add(helpLabel1);
        mainPanel.add(helpLabel2);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(GreenfootUtil.createSpacer(1, 10));
        JLabel label = new JLabel(Config.getString((String)"newclass.dialog.className"));
        label.setAlignmentX(0.0f);
        mainPanel.add(label);
        mainPanel.add(Box.createVerticalStrut(4));
        this.classNameTextField = new JTextField();
        this.classNameTextField.setAlignmentX(0.0f);
        Dimension classNameMax = this.classNameTextField.getMaximumSize();
        classNameMax.height = this.classNameTextField.getPreferredSize().height;
        this.classNameTextField.setMaximumSize(classNameMax);
        mainPanel.add(this.classNameTextField);
        mainPanel.add(GreenfootUtil.createSpacer(1, 5));
        final JLabel errorMsgLabel = new JLabel();
        errorMsgLabel.setAlignmentX(0.0f);
        errorMsgLabel.setVisible(false);
        errorMsgLabel.setForeground(Color.RED);
        mainPanel.add(errorMsgLabel);
        mainPanel.add(GreenfootUtil.createSpacer(1, 5));
        JPanel slectionPanel = new JPanel();
        slectionPanel.setLayout(new BoxLayout(slectionPanel, 0));
        slectionPanel.setAlignmentX(0.0f);
        JLabel selectionLabel = new JLabel(Config.getString((String)"newclass.dialog.selectionLabel"));
        selectionLabel.setAlignmentX(0.0f);
        slectionPanel.add(selectionLabel);
        slectionPanel.add(Box.createHorizontalStrut(15));
        SourceType[] items = new SourceType[]{SourceType.Stride, SourceType.Java};
        this.languageSelectionBox = new JComboBox<SourceType>(items);
        this.setSelectedLanguage(pkg.getDefaultSourceType());
        slectionPanel.add(this.languageSelectionBox);
        mainPanel.add(slectionPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        final JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(evt -> this.ok());
        okButton.setEnabled(false);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.setVerifyInputWhenFocusTarget(false);
        cancelButton.addActionListener(evt -> this.cancel());
        if (Config.isMacOS()) {
            buttonPanel.add(cancelButton);
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(okButton);
        } else {
            buttonPanel.add(okButton);
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(cancelButton);
        }
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.setAlignmentX(0.0f);
        Dimension buttonPanelMax = buttonPanel.getMaximumSize();
        buttonPanelMax.height = buttonPanel.getPreferredSize().height;
        buttonPanel.setMaximumSize(buttonPanelMax);
        ClassNameVerifier classNameVerifier = new ClassNameVerifier(this.classNameTextField, pkg);
        classNameVerifier.addValidityListener(new ValidityListener(){

            @Override
            public void changedToInvalid(ValidityEvent e) {
                errorMsgLabel.setText(e.getReason());
                errorMsgLabel.setVisible(true);
                okButton.setEnabled(false);
            }

            @Override
            public void changedToValid(ValidityEvent e) {
                errorMsgLabel.setVisible(false);
                okButton.setEnabled(true);
            }
        });
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(GreenfootUtil.createSpacer(1, 10));
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(buttonPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void ok() {
        this.okPressed = true;
        this.dispose();
    }

    private void cancel() {
        this.okPressed = false;
        this.dispose();
    }

    public String getClassName() {
        return this.classNameTextField.getText();
    }

    public void setSuggestedClassName(String suggestedClassName) {
        this.classNameTextField.setText(suggestedClassName);
    }

    public SourceType getSelectedLanguage() {
        return (SourceType)this.languageSelectionBox.getSelectedItem();
    }

    public void setSelectedLanguage(SourceType type) {
        this.languageSelectionBox.setSelectedItem(type);
    }

    public void disableLanguageSelectionBox() {
        this.languageSelectionBox.setEnabled(false);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public boolean getInterface() {
        return this.useInterface;
    }
}

