/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.utility.Debug;
import greenfoot.core.ClassStateManager;
import greenfoot.core.GClass;
import greenfoot.record.GreenfootRecorder;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class SaveWorldAction
extends AbstractAction
implements ClassStateManager.CompiledStateListener {
    private GreenfootRecorder recorder;
    private boolean recordingValid;
    private GClass lastWorldGClass;

    public SaveWorldAction(GreenfootRecorder recorder, ClassStateManager classStateManager) {
        super(Config.getString((String)"save.world"));
        this.setEnabled(false);
        this.recorder = recorder;
        if (classStateManager != null) {
            classStateManager.addCompiledStateListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        NormalMethodElement method = this.recorder.getPrepareMethod();
        CallElement methodCall = this.recorder.getPrepareMethodCall();
        try {
            GClass lastWorld = this.getLastWorldGClass();
            lastWorld.insertMethodCallInConstructor(methodCall.toXML().toXML(), false);
            lastWorld.insertAppendMethod(method.toXML().toXML(), true, false);
            this.recorder.clearCode(false);
            lastWorld.compile(false, true);
        }
        catch (CompilationNotStartedException | PackageNotFoundException | ProjectNotOpenException | RemoteException e) {
            Debug.reportError((String)"Error trying to get editor for world class and insert method (with call)", (Throwable)e);
        }
    }

    private synchronized boolean shouldBeEnabled() {
        GClass lastWorld = this.getLastWorldGClass();
        return this.recordingValid && lastWorld != null && lastWorld.isCompiled();
    }

    public synchronized void setRecordingValid(boolean valid) {
        boolean oldValid = this.recordingValid;
        this.recordingValid = valid;
        if (oldValid != this.recordingValid) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SaveWorldAction.this.updateEnabledStatus();
                }
            });
        }
    }

    private void updateEnabledStatus() {
        this.setEnabled(this.shouldBeEnabled());
    }

    @Override
    public void compiledStateChanged(final GClass gclass, boolean compiled) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GClass lastClass = SaveWorldAction.this.getLastWorldGClass();
                if (lastClass != null && gclass.getQualifiedName().equals(lastClass.getQualifiedName())) {
                    SaveWorldAction.this.updateEnabledStatus();
                }
            }
        });
    }

    private synchronized GClass getLastWorldGClass() {
        return this.lastWorldGClass;
    }

    public synchronized void setLastWorldGClass(GClass lastWorld) {
        this.lastWorldGClass = lastWorld;
    }
}

