/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.SourceType;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.record.InteractionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class DuplicateClassAction
extends AbstractAction {
    private ClassView originalClass;
    private ClassBrowser classBrowser;
    private InteractionListener interactionListener;

    public DuplicateClassAction(ClassView view, ClassBrowser classBrowser, InteractionListener interactionListener) {
        super(Config.getString((String)"duplicate.class"));
        this.originalClass = view;
        this.classBrowser = classBrowser;
        this.interactionListener = interactionListener;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        GClass originalG = this.originalClass.getGClass();
        String originalClassName = originalG.getName();
        SourceType sourceType = originalG.getSourceType();
        GreenfootFrame f = this.classBrowser.getFrame();
        GPackage pkg = this.classBrowser.getProject().getDefaultPackage();
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setSuggestedClassName("CopyOf" + originalClassName);
        dialog.setSelectedLanguage(sourceType);
        dialog.disableLanguageSelectionBox();
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        String className = dialog.getClassName();
        SourceType language = dialog.getSelectedLanguage();
        try {
            File dir = pkg.getProject().getDir();
            String extension = language.toString().toLowerCase();
            File newFile = new File(dir, className + "." + extension);
            File originalFile = new File(dir, originalClassName + "." + extension);
            GreenfootUtilDelegateIDE.getInstance().duplicate(originalClassName, className, originalFile, newFile, sourceType);
            GClass newClass = pkg.newClass(className, extension, false);
            ClassView classView = new ClassView(this.classBrowser, newClass, this.interactionListener);
            this.classBrowser.addClass(classView);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

