/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import greenfoot.gui.images.ImageFilePreview;
import greenfoot.gui.images.ImageFilter;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.Selectable;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;

public class BrowseImagesAction
extends AbstractAction {
    private JDialog owner;
    private File projImagesDir;
    private Selectable<File> selectable;

    public BrowseImagesAction(String name, JDialog owner, File destDir, Selectable<File> selectable) {
        super(name);
        this.owner = owner;
        this.projImagesDir = destDir;
        this.selectable = selectable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        new ImageFilePreview(chooser);
        chooser.setAcceptAllFileFilterUsed(false);
        ImageFilter filter = new ImageFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(Config.getString((String)"imagelib.browse.button"));
        int choice = chooser.showDialog(this.owner, Config.getString((String)"imagelib.choose.button"));
        if (choice == 0) {
            File file = chooser.getSelectedFile();
            File newFile = new File(this.projImagesDir, file.getName());
            GreenfootUtil.copyFile(file, newFile);
            if (this.selectable != null) {
                this.selectable.select(newFile);
            }
        }
    }
}

