/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.ImageDetailProvider;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilderRegistry;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class ImageBuilder {
    static final Logger LOGGER = Logger.getLogger(ImageDetailProvider.class.getName());
    private static final InstanceBuilder<String> TOOKIT_IMAGE_STRING_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<String>(String.class, "imagerep", "bimage");
    private static final InstanceBuilder<Image> TOOKIT_IMAGE_IMAGE_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<Image>(Image.class, "imagerep", "bimage");
    private static final InstanceBuilder<String> IMAGE_ICON_STRING_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<String>(String.class, "image");
    private static final InstanceBuilder<Image> IMAGE_ICON_IMAGE_BUILDER = new InstanceBuilder.ReferringInstanceBuilder<Image>(Image.class, "image");
    private static final InstanceBuilder<String> BUFFERED_IMAGE_STRING_BUILDER = new InstanceBuilder<String>(String.class){

        @Override
        public String convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            Instance instance2 = fieldAccessor.getInstance(instance, "raster", WritableRaster.class, true);
            int n = fieldAccessor.getInt(instance2, "width");
            int n2 = fieldAccessor.getInt(instance2, "height");
            Instance instance3 = fieldAccessor.getInstance(instance, "colorModel", ColorModel.class, true);
            int n3 = 0;
            if (FieldAccessor.isInstanceOf(instance3, IndexColorModel.class)) {
                n3 = DetailsUtils.getIntFieldValue(instance3, "map_size", 0);
            }
            if (n3 > 0) {
                return Bundle.ImageDetailProvider_ImageDescrColors(n, n2, n3);
            }
            return Bundle.ImageDetailProvider_ImageDescr(n, n2);
        }
    };
    private static final InstanceBuilder<Image> BUFFERED_IMAGE_IMAGE_BUILDER = new InstanceBuilder<Image>(Image.class){

        @Override
        public Image convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            try {
                int n = fieldAccessor.getInt(instance, "imageType");
                WritableRaster writableRaster = fieldAccessor.build(instance, "raster", WritableRaster.class, false);
                ColorModel colorModel = fieldAccessor.build(instance, "colorModel", ColorModel.class, false);
                boolean bl = fieldAccessor.getBoolean(instance, "isAlphaPremultiplied");
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, null);
                bufferedImage.setData(writableRaster);
                return bufferedImage;
            }
            catch (FieldAccessor.InvalidFieldException invalidFieldException) {
                throw invalidFieldException;
            }
            catch (Throwable throwable) {
                throw new FieldAccessor.InvalidFieldException("unable to recreate raster: %s", throwable.getMessage()).initCause(throwable);
            }
        }
    };
    private static final InstanceBuilder<ColorModel> INDEX_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "pixel_bits");
            int[] nArray = fieldAccessor.getIntArray(instance, "rgb", false);
            int n2 = fieldAccessor.getInt(instance, "map_size");
            int n3 = fieldAccessor.getInt(instance, "transparent_index");
            int n4 = fieldAccessor.getInt(instance, "transferType");
            return new IndexColorModel(n, n2, nArray, 0, true, n3, n4);
        }
    };
    private static final InstanceBuilder<ColorModel> DIRECT_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "pixel_bits");
            int n2 = fieldAccessor.getInt(instance, "red_mask");
            int n3 = fieldAccessor.getInt(instance, "green_mask");
            int n4 = fieldAccessor.getInt(instance, "blue_mask");
            int n5 = fieldAccessor.getInt(instance, "alpha_mask");
            boolean bl = fieldAccessor.getBoolean(instance, "isAlphaPremultiplied");
            int n6 = fieldAccessor.getInt(instance, "transferType");
            return new DirectColorModel(ColorSpace.getInstance(1000), n, n2, n3, n4, n5, bl, n6);
        }
    };
    private static final InstanceBuilder<ColorModel> COMPONENT_COLOR_MODEL_BUILDER = new InstanceBuilder<ColorModel>(ColorModel.class){

        @Override
        public ColorModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int[] nArray = fieldAccessor.getIntArray(instance, "nBits", false);
            int n = fieldAccessor.getInt(instance, "transparency");
            boolean bl = fieldAccessor.getBoolean(instance, "supportsAlpha");
            boolean bl2 = fieldAccessor.getBoolean(instance, "isAlphaPremultiplied");
            int n2 = fieldAccessor.getInt(instance, "transferType");
            return new ComponentColorModel(ColorSpace.getInstance(1000), nArray, bl, bl2, n, n2);
        }
    };
    private static final InstanceBuilder<ColorSpace> DEFAULT_COLOR_SPACE_BUILDER = new InstanceBuilder<ColorSpace>(ColorSpace.class){

        @Override
        public ColorSpace convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            return ColorSpace.getInstance(1000);
        }
    };
    private static final InstanceBuilder<WritableRaster> WRITABLE_RASTER_BUILDER = new InstanceBuilder<WritableRaster>(WritableRaster.class){

        @Override
        public WritableRaster convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            WritableRaster writableRaster = fieldAccessor.build(instance, "parent", WritableRaster.class, true);
            if (writableRaster == null) {
                DataBuffer dataBuffer = fieldAccessor.build(instance, "dataBuffer", DataBuffer.class, false);
                SampleModel sampleModel = fieldAccessor.build(instance, "sampleModel", SampleModel.class, false);
                int n = fieldAccessor.getInt(instance, "sampleModelTranslateX");
                int n2 = fieldAccessor.getInt(instance, "sampleModelTranslateY");
                return Raster.createWritableRaster(sampleModel, dataBuffer, new Point(n, n2));
            }
            int n = fieldAccessor.getInt(instance, "width");
            int n3 = fieldAccessor.getInt(instance, "height");
            int n4 = fieldAccessor.getInt(instance, "minX");
            int n5 = fieldAccessor.getInt(instance, "minY");
            int n6 = fieldAccessor.getInt(instance, "sampleModelTranslateX");
            int n7 = fieldAccessor.getInt(instance, "sampleModelTranslateY");
            int n8 = writableRaster.getSampleModelTranslateX();
            int n9 = writableRaster.getSampleModelTranslateY();
            return writableRaster.createWritableChild(n4, n5, n, n3, n6 - n8 + n4, n7 - n9 + n5, null);
        }
    };
    private static final InstanceBuilder<SampleModel> SPP_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "width");
            int n2 = fieldAccessor.getInt(instance, "height");
            int n3 = fieldAccessor.getInt(instance, "dataType");
            int n4 = fieldAccessor.getInt(instance, "scanlineStride");
            int[] nArray = fieldAccessor.getIntArray(instance, "bitMasks", false);
            return new SinglePixelPackedSampleModel(n3, n, n2, n4, nArray);
        }
    };
    private static final InstanceBuilder<SampleModel> PI_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "width");
            int n2 = fieldAccessor.getInt(instance, "height");
            int n3 = fieldAccessor.getInt(instance, "dataType");
            int n4 = fieldAccessor.getInt(instance, "pixelStride");
            int n5 = fieldAccessor.getInt(instance, "scanlineStride");
            int[] nArray = fieldAccessor.getIntArray(instance, "bandOffsets", false);
            return new PixelInterleavedSampleModel(n3, n, n2, n4, n5, nArray);
        }
    };
    private static final InstanceBuilder<SampleModel> B_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "width");
            int n2 = fieldAccessor.getInt(instance, "height");
            int n3 = fieldAccessor.getInt(instance, "dataType");
            int n4 = fieldAccessor.getInt(instance, "scanlineStride");
            int[] nArray = fieldAccessor.getIntArray(instance, "bankIndices", false);
            int[] nArray2 = fieldAccessor.getIntArray(instance, "bandOffsets", false);
            return new BandedSampleModel(n3, n, n2, n4, nArray, nArray2);
        }
    };
    private static final InstanceBuilder<SampleModel> MPP_SAMPLE_MODEL_BUILDER = new InstanceBuilder<SampleModel>(SampleModel.class){

        @Override
        public SampleModel convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "width");
            int n2 = fieldAccessor.getInt(instance, "height");
            int n3 = fieldAccessor.getInt(instance, "dataType");
            int n4 = fieldAccessor.getInt(instance, "scanlineStride");
            int n5 = fieldAccessor.getInt(instance, "numberOfBits");
            int n6 = fieldAccessor.getInt(instance, "dataBitOffset");
            return new MultiPixelPackedSampleModel(n3, n, n2, n5, n4, n6);
        }
    };
    private static final InstanceBuilder<DataBuffer> INT_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "size");
            int[] nArray = fieldAccessor.getIntArray(instance, "offsets", false);
            int[][] nArray2 = fieldAccessor.getIntArray2(instance, "bankdata", false);
            return new DataBufferInt(nArray2, n, nArray);
        }
    };
    private static final InstanceBuilder<DataBuffer> BYTE_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "size");
            int[] nArray = fieldAccessor.getIntArray(instance, "offsets", false);
            byte[][] byArray = fieldAccessor.getByteArray2(instance, "bankdata", false);
            return new DataBufferByte(byArray, n, nArray);
        }
    };
    private static final InstanceBuilder<DataBuffer> USHORT_DATA_BUFFER_BUILDER = new InstanceBuilder<DataBuffer>(DataBuffer.class){

        @Override
        public DataBuffer convert(FieldAccessor fieldAccessor, Instance instance) throws FieldAccessor.InvalidFieldException {
            int n = fieldAccessor.getInt(instance, "size");
            int[] nArray = fieldAccessor.getIntArray(instance, "offsets", false);
            short[][] sArray = fieldAccessor.getShortArray2(instance, "bankdata", false);
            return new DataBufferUShort(sArray, n, nArray);
        }
    };
    static final InstanceBuilderRegistry BUILDERS = new InstanceBuilderRegistry();

    public static Image buildImage(Instance instance, Heap heap) {
        try {
            return ImageBuilder.buildImageInternal(instance, heap);
        }
        catch (FieldAccessor.InvalidFieldException invalidFieldException) {
            LOGGER.log(Level.FINE, "Unable to create image for instance", invalidFieldException.getMessage());
            return null;
        }
    }

    static Image buildImageInternal(Instance instance, Heap heap) throws FieldAccessor.InvalidFieldException {
        InstanceBuilder<Image> instanceBuilder = BUILDERS.getBuilder(instance, Image.class);
        if (instanceBuilder == null) {
            throw new FieldAccessor.InvalidFieldException("Unable to get Image builder for %s#%d", instance.getJavaClass().getName(), instance.getInstanceNumber());
        }
        return instanceBuilder.convert(new FieldAccessor(heap, BUILDERS), instance);
    }

    static {
        BUILDERS.register(ColorSpace.class, true, DEFAULT_COLOR_SPACE_BUILDER);
        BUILDERS.register(IndexColorModel.class, true, INDEX_COLOR_MODEL_BUILDER);
        BUILDERS.register(ComponentColorModel.class, true, COMPONENT_COLOR_MODEL_BUILDER);
        BUILDERS.register(DirectColorModel.class, true, DIRECT_COLOR_MODEL_BUILDER);
        BUILDERS.register(SinglePixelPackedSampleModel.class, false, SPP_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(PixelInterleavedSampleModel.class, false, PI_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(BandedSampleModel.class, false, B_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(MultiPixelPackedSampleModel.class, false, MPP_SAMPLE_MODEL_BUILDER);
        BUILDERS.register(DataBufferInt.class, false, INT_DATA_BUFFER_BUILDER);
        BUILDERS.register(DataBufferByte.class, false, BYTE_DATA_BUFFER_BUILDER);
        BUILDERS.register(DataBufferUShort.class, false, USHORT_DATA_BUFFER_BUILDER);
        BUILDERS.register(WritableRaster.class, true, WRITABLE_RASTER_BUILDER);
        BUILDERS.register("sun.awt.image.ToolkitImage+", TOOKIT_IMAGE_STRING_BUILDER);
        BUILDERS.register("sun.awt.image.ToolkitImage+", TOOKIT_IMAGE_IMAGE_BUILDER);
        BUILDERS.register(ImageIcon.class, true, IMAGE_ICON_STRING_BUILDER);
        BUILDERS.register(ImageIcon.class, true, IMAGE_ICON_IMAGE_BUILDER);
        BUILDERS.register(BufferedImage.class, true, BUFFERED_IMAGE_STRING_BUILDER);
        BUILDERS.register(BufferedImage.class, true, BUFFERED_IMAGE_IMAGE_BUILDER);
    }
}

