/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.MultiListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;

public class FrameSelection {
    private final ObservableList<Frame> selection = FXCollections.observableList(new ArrayList());
    private final Canvas selectionHighlight = new Canvas();
    private final InteractionManager editor;
    private boolean deletePreview;
    private boolean pullUpPreview;

    public FrameSelection(InteractionManager editor) {
        this.editor = editor;
        this.selectionHighlight.setMouseTransparent(true);
        this.deletePreview = false;
        this.pullUpPreview = false;
        Function<Frame, MultiListener.RemoveAndUpdate> removeAndUpdate = f -> {
            FXRunnable removeA = JavaFXUtil.addChangeListener((ObservableValue)f.getNode().localToSceneTransformProperty(), x -> this.redraw());
            FXRunnable removeB = JavaFXUtil.addChangeListener((ObservableValue)f.getNode().boundsInLocalProperty(), x -> this.redraw());
            return () -> ((FXRunnable)JavaFXUtil.sequence((FXRunnable[])new FXRunnable[]{removeA, removeB})).run();
        };
        MultiListener positionListener = new MultiListener(removeAndUpdate);
        this.selection.addListener(arg -> {
            this.redraw();
            positionListener.listenOnlyTo(this.selection.stream());
        });
    }

    private void redraw() {
        this.editor.getCodeOverlayPane().removeOverlay((Node)this.selectionHighlight);
        if (!this.selection.isEmpty()) {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.selectionHighlight, ((Frame)this.selection.get(0)).getNode(), null, null);
            Node topNode = ((Frame)this.selection.get(0)).getNode();
            Node bottomNode = ((Frame)this.selection.get(this.selection.size() - 1)).getNode();
            this.selectionHighlight.setWidth(topNode.getBoundsInParent().getWidth());
            this.selectionHighlight.setHeight(bottomNode.getBoundsInParent().getMinY() + bottomNode.getLayoutBounds().getHeight() - topNode.getBoundsInParent().getMinY());
            GraphicsContext gc = this.selectionHighlight.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.selectionHighlight.getWidth(), this.selectionHighlight.getHeight());
            if (this.deletePreview || this.pullUpPreview) {
                gc.setFill((Paint)new Color(1.0, 0.4, 0.4, 0.7));
                if (this.pullUpPreview) {
                    gc.setFillRule(FillRule.EVEN_ODD);
                    for (Frame f : this.selection) {
                        gc.beginPath();
                        this.roundedRectPath(gc, 0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0);
                        for (FrameCanvas c : Utility.iterableStream((Stream)f.getCanvases())) {
                            Bounds sceneBounds = c.getContentSceneBounds();
                            Bounds b = this.selectionHighlight.sceneToLocal(sceneBounds);
                            this.roundedRectPath(gc, b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight(), 5.0);
                        }
                        gc.fill();
                        gc.closePath();
                    }
                } else {
                    gc.fillRoundRect(0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0, 7.0);
                }
            }
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(2.0);
            gc.strokeRoundRect(0.5, 0.5, this.selectionHighlight.getWidth() - 1.0, this.selectionHighlight.getHeight() - 1.0, 7.0, 7.0);
        }
    }

    private void roundedRectPath(GraphicsContext gc, double minX, double minY, double width, double height, double arc) {
        gc.moveTo(minX + arc, minY);
        gc.lineTo(minX + width - arc, minY);
        gc.arcTo(minX + width, minY, minX + width, minY + arc, arc);
        gc.lineTo(minX + width, minY + height - arc);
        gc.arcTo(minX + width, minY + height, minX + width - arc, minY + height, arc);
        gc.lineTo(minX + arc, minY + height);
        gc.arcTo(minX, minY + height, minX, minY + height - arc, arc);
        gc.lineTo(minX, minY + arc);
        gc.arcTo(minX, minY, minX + arc, minY, arc);
    }

    public void clear() {
        this.selection.clear();
    }

    public boolean contains(Frame f) {
        return this.selection.contains((Object)f);
    }

    public List<Frame> getSelected() {
        return Collections.unmodifiableList(this.selection);
    }

    public void toggleSelectDown(Frame f) {
        if (f == null) {
            return;
        }
        if (this.selection.size() > 0 && this.selection.get(0) == f) {
            this.selection.remove(0);
        } else {
            this.selection.add((Object)f);
        }
    }

    public void toggleSelectUp(Frame f) {
        if (f == null) {
            return;
        }
        if (this.selection.size() > 0 && this.selection.get(this.selection.size() - 1) == f) {
            this.selection.remove(this.selection.size() - 1);
        } else {
            this.selection.add(0, (Object)f);
        }
    }

    public EditableSlot.MenuItems getMenuItems(boolean contextMenu) {
        if (this.selection.size() == 0) {
            return new EditableSlot.MenuItems(FXCollections.observableArrayList());
        }
        if (this.selection.size() == 1) {
            return FrameSelection.asMenuItems(((Frame)this.selection.get(0)).getContextOperations(), 0, contextMenu);
        }
        HashMap ops = new HashMap();
        for (Frame f : this.selection) {
            for (FrameOperation op : f.getContextOperations()) {
                if (!ops.containsKey(op.getIdentifier())) {
                    ops.put(op.getIdentifier(), new ArrayList());
                }
                ((List)ops.get(op.getIdentifier())).add(op);
            }
        }
        ArrayList<FrameOperation> r = new ArrayList<FrameOperation>();
        for (List opEntry : ops.values()) {
            FrameOperation frameOperation = (FrameOperation)opEntry.get(0);
            if ((frameOperation.combine() != AbstractOperation.Combine.ALL || opEntry.size() != this.selection.size()) && frameOperation.combine() != AbstractOperation.Combine.ANY && (frameOperation.combine() != AbstractOperation.Combine.ONE || this.selection.size() != 1)) continue;
            r.add(frameOperation);
        }
        return FrameSelection.asMenuItems(r, 0, contextMenu);
    }

    public Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getEditMenuItems(boolean contextMenu) {
        return Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, this.getMenuItems(contextMenu));
    }

    private static EditableSlot.MenuItems asMenuItems(List<FrameOperation> originalOps, int depth, boolean contextMenu) {
        List ops = originalOps.stream().filter(op -> contextMenu || !op.onlyOnContextMenu()).collect(Collectors.toList());
        ArrayList<EditableSlot.SortedMenuItem> r = new ArrayList<EditableSlot.SortedMenuItem>();
        Set<AbstractOperation.ItemLabel> subMenuNames = ops.stream().filter(op -> op.getLabels().size() > depth + 1).map(op -> (AbstractOperation.ItemLabel)op.getLabels().get(depth)).collect(Collectors.toSet());
        subMenuNames.forEach(subMenuName -> {
            EditableSlot.MenuItems menuItems = FrameSelection.asMenuItems(ops.stream().filter(op -> ((AbstractOperation.ItemLabel)op.getLabels().get(depth)).equals(subMenuName)).collect(Collectors.toList()), depth + 1, contextMenu);
            Menu subMenu = menuItems.makeSubMenu();
            subMenu.textProperty().bind(subMenuName.getLabel());
            r.add(subMenuName.getOrder().item((MenuItem)subMenu));
        });
        final List opsAtRightLevel = ops.stream().filter(op -> op.getLabels().size() == depth + 1).collect(Collectors.toList());
        final IdentityHashMap<FrameOperation, EditableSlot.SortedMenuItem> opsAtRightLevelItems = new IdentityHashMap<FrameOperation, EditableSlot.SortedMenuItem>();
        for (FrameOperation op2 : opsAtRightLevel) {
            EditableSlot.SortedMenuItem item = op2.getMenuItem(contextMenu);
            r.add(item);
            opsAtRightLevelItems.put(op2, item);
        }
        return new EditableSlot.MenuItems(FXCollections.observableArrayList(r)){

            public void onShowing() {
                opsAtRightLevel.forEach(op -> {
                    EditableSlot.SortedMenuItem sortedMenuItem = (EditableSlot.SortedMenuItem)opsAtRightLevelItems.get(op);
                    MenuItem item = sortedMenuItem.getItem();
                    if (item instanceof CustomMenuItem) {
                        op.onMenuShowing((CustomMenuItem)item);
                    }
                });
            }

            public void onHidden() {
                opsAtRightLevel.forEach(op -> {
                    EditableSlot.SortedMenuItem sortedMenuItem = (EditableSlot.SortedMenuItem)opsAtRightLevelItems.get(op);
                    MenuItem item = sortedMenuItem.getItem();
                    if (item instanceof CustomMenuItem) {
                        op.onMenuHidden((CustomMenuItem)item);
                    }
                });
            }
        };
    }

    public ContextMenu getContextMenu() {
        EditableSlot.MenuItems ops = this.getMenuItems(true);
        if (ops.isEmpty()) {
            return null;
        }
        return EditableSlot.MenuItems.makeContextMenu(Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, ops));
    }

    public void setDeletePreview(boolean deletePreview) {
        this.deletePreview = deletePreview;
        this.pullUpPreview = false;
        this.redraw();
    }

    public void setPullUpPreview(boolean pullUpPreview) {
        this.deletePreview = false;
        this.pullUpPreview = pullUpPreview;
        this.redraw();
    }

    public void set(List<Frame> frames) {
        this.selection.clear();
        this.selection.setAll(frames);
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public void addChangeListener(ListChangeListener<Frame> listener) {
        this.selection.addListener(listener);
    }

    public FrameCursor getCursorAfter() {
        if (this.selection.size() == 0) {
            return null;
        }
        return ((Frame)this.selection.get(this.selection.size() - 1)).getCursorAfter();
    }

    public FrameCursor getCursorBefore() {
        if (this.selection.size() == 0) {
            return null;
        }
        return ((Frame)this.selection.get(0)).getCursorBefore();
    }
}

