/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.editor.stride.BirdseyeManager;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.CursorOrSlot;
import bluej.editor.stride.ErrorOverviewBar;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditor;
import bluej.editor.stride.FrameMenuManager;
import bluej.editor.stride.FrameSelection;
import bluej.editor.stride.ImageCompletion;
import bluej.editor.stride.SoundCompletion;
import bluej.editor.stride.WindowOverlayPane;
import bluej.parser.AssistContent;
import bluej.parser.ConstructorCompletion;
import bluej.parser.PrimitiveTypeCompletion;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.PackageOrClass;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.links.PossibleKnownMethodLink;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleMethodUseLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.ast.links.PossibleVarLink;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.MethodWithBodyElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorAndFixDisplay;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.GreenfootFrameCategory;
import bluej.stride.framedjava.frames.GreenfootFrameDictionary;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameState;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.generic.SuggestedFollowUpDisplay;
import bluej.stride.operations.UndoRedoManager;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.LinkedIdentifier;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ViewportHeightBinding;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FrameEditorTab
extends FXTab
implements InteractionManager {
    private static final List<Future<List<AssistContentThreadSafe>>> popularImports = new ArrayList<Future<List<AssistContentThreadSafe>>>();
    private static Future<List<AssistContentThreadSafe>> javaLangImports;
    private static List<AssistContentThreadSafe> prims;
    private final SimpleObjectProperty<CursorOrSlot> focusedItem = new SimpleObjectProperty(null);
    private final TopLevelCodeElement initialSource;
    private final StringProperty nameProperty = new SimpleStringProperty();
    private final List<Future<List<AssistContentThreadSafe>>> importedTypes;
    private final FrameSelection selection = new FrameSelection(this);
    private final FrameEditor editor;
    private final UndoRedoManager undoRedoManager;
    private final ObjectProperty<Frame.View> viewProperty = new SimpleObjectProperty((Object)Frame.View.NORMAL);
    private final EntityResolver projectResolver;
    private final FrameMenuManager menuManager;
    private WindowOverlayPane windowOverlayPane;
    private CodeOverlayPane codeOverlayPane;
    private Observable observableScroll;
    private ViewportHeightBinding viewportHeight;
    private boolean manualScrolledSinceLastFocusChange = false;
    private CursorOrSlot focusOwnerDuringLastManualScroll = null;
    private TopLevelFrame<? extends TopLevelCodeElement> topLevelFrame;
    private ContextMenu menu;
    private HBox controlPanel;
    private FrameCursor dragTarget;
    private ContentBorderPane contentRoot;
    private StackPane scrollAndOverlays;
    private StackPane scrollContent;
    private final ObjectProperty<FXTabbedEditor> parent = new SimpleObjectProperty();
    private Project project;
    private ScrollPane scroll;
    private boolean selectingByDrag;
    private BirdseyeManager birdseyeManager;
    private Rectangle birdseyeSelection;
    private Pane birdseyeSelectionPane;
    private Node birdseyeDefaultFocusAfter;
    private FXRunnable birdseyeDefaultRequestFocusAfter;
    private Iterator<CodeError> errors;
    private SimpleBooleanProperty initialised = new SimpleBooleanProperty(false);
    private Frame stackHighlight;
    private EditableSlot showingUnderlinesFor = null;
    private ErrorOverviewBar errorOverviewBar;
    private boolean loading = false;
    private boolean animatingScroll = false;
    private boolean anyButtonsPressed = false;
    private SharedTransition viewChange;
    private ErrorAndFixDisplay cursorErrorDisplay;
    private boolean inScrollTo = false;

    public FrameEditorTab(Project project, EntityResolver resolver, FrameEditor editor, TopLevelCodeElement initialSource) {
        this.project = project;
        this.projectResolver = resolver;
        this.importedTypes = new ArrayList<Future<List<AssistContentThreadSafe>>>();
        this.editor = editor;
        this.initialSource = initialSource;
        this.undoRedoManager = new UndoRedoManager(new FrameState(initialSource));
        this.menuManager = new FrameMenuManager(this);
        if (javaLangImports == null) {
            javaLangImports = this.importsUpdated("java.lang.*");
        }
        if (popularImports.isEmpty()) {
            popularImports.addAll(Arrays.asList("java.io.*", "java.math.*", "java.net.*", "java.time.*", "java.util.*", "java.util.concurrent.*", "java.util.function.*", "java.util.stream.*", Config.isGreenfoot() ? "greenfoot.*" : null).stream().filter(i -> i != null).map(this::importsUpdated).collect(Collectors.toList()));
        }
    }

    public static String blockSkipModifierLabel() {
        return Config.isMacOS() ? "\u2325" : "^";
    }

    private static boolean hasBlockSkipModifierPressed(KeyEvent event) {
        if (Config.isMacOS()) {
            return event.isAltDown();
        }
        return event.isControlDown();
    }

    private static boolean isUselessDrag(FrameCursor dragTarget, List<Frame> dragging, boolean copying) {
        return !copying && (dragging.contains(dragTarget.getFrameAfter()) || dragging.contains(dragTarget.getFrameBefore()));
    }

    @OnThread(value=Tag.Any)
    private static <T> List<T> getFutureList(Future<List<T>> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            Debug.reportError((String)"Problem looking up types", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @OnThread(value=Tag.FX)
    private Future<List<AssistContentThreadSafe>> importsUpdated(String x) {
        JavadocResolver javadocResolver = this.project.getJavadocResolver();
        CompletableFuture<List<AssistContentThreadSafe>> f = new CompletableFuture<List<AssistContentThreadSafe>>();
        Utility.runBackground(() -> {
            try {
                f.complete(this.project.getImportScanner().getImportedTypes(x, javadocResolver));
            }
            catch (Throwable t) {
                f.complete(Collections.emptyList());
            }
        });
        return f;
    }

    @Override
    @OnThread(value=Tag.FX)
    public void initialiseFX() {
        if (this.initialised.get()) {
            return;
        }
        this.setText("");
        Label titleLabel = new Label(this.initialSource.getName());
        titleLabel.textProperty().bind((ObservableValue)this.nameProperty);
        HBox tabHeader = new HBox(new Node[]{titleLabel});
        tabHeader.setAlignment(Pos.CENTER);
        tabHeader.setSpacing(3.0);
        tabHeader.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.MIDDLE) {
                this.setWindowVisible(false, false);
            }
        });
        this.setGraphic((Node)tabHeader);
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"frame-editor-tab", this.initialSource.getStylePrefix() + "frame-editor-tab"});
        JavaFXUtil.addChangeListener(this.focusedItem, focused -> {
            this.menuManager.setMenuItems(focused != null ? focused.getMenuItems(false) : (this.selection != null ? this.selection.getEditMenuItems(false) : Collections.emptyMap()));
            if (focused != null && !focused.equals(this.focusOwnerDuringLastManualScroll)) {
                this.manualScrolledSinceLastFocusChange = false;
            }
        });
        this.selection.addChangeListener((ListChangeListener<Frame>)((ListChangeListener)c -> this.menuManager.setMenuItems(this.focusedItem.get() != null ? ((CursorOrSlot)this.focusedItem.get()).getMenuItems(false) : Collections.emptyMap())));
        this.contentRoot = new ContentBorderPane();
        JavaFXUtil.addStyleClass((Styleable)this.contentRoot, (String[])new String[]{"frame-editor-tab-content", this.initialSource.getStylePrefix() + "frame-editor-tab-content"});
        this.scrollAndOverlays = new StackPane();
        this.windowOverlayPane = new WindowOverlayPane();
        this.scroll = new ScrollPane();
        this.scroll.getStyleClass().add((Object)"frame-editor-scroll-pane");
        this.scroll.setFitToWidth(true);
        this.observableScroll = this.scroll.vvalueProperty();
        this.viewportHeight = new ViewportHeightBinding(this.scroll);
        this.scrollAndOverlays.getChildren().addAll((Object[])new Node[]{this.scroll, this.windowOverlayPane.getNode()});
        this.scroll.setFitToWidth(true);
        JavaFXUtil.addChangeListener((ObservableValue)this.scroll.vvalueProperty(), v -> {
            if (!this.animatingScroll) {
                this.manualScrolledSinceLastFocusChange = true;
                if (this.focusedItem.get() != null) {
                    this.focusOwnerDuringLastManualScroll = (CursorOrSlot)this.focusedItem.get();
                }
            }
        });
        this.scrollAndOverlays.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            FrameCursor focusedCursor = this.getFocusedCursor();
            boolean blockCursorFocused = focusedCursor != null;
            switch (event.getCode()) {
                case UP: {
                    FrameCursor c;
                    if (!blockCursorFocused) break;
                    if (event.isShiftDown() && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                        c = focusedCursor.getPrevSkip();
                        this.selection.toggleSelectUp(focusedCursor.getFrameBefore());
                    } else if (FrameEditorTab.hasBlockSkipModifierPressed(event) || this.viewProperty.get() == Frame.View.JAVA_PREVIEW && focusedCursor.getFrameBefore() != null && !focusedCursor.getFrameBefore().isFrameEnabled()) {
                        this.selection.clear();
                        c = focusedCursor.getPrevSkip();
                    } else {
                        this.selection.clear();
                        c = focusedCursor.getParentCanvas().getPrevCursor(focusedCursor, true);
                    }
                    if (c != null) {
                        c.requestFocus();
                    }
                    event.consume();
                    break;
                }
                case DOWN: {
                    FrameCursor c;
                    if (!blockCursorFocused) break;
                    if (event.isShiftDown() && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                        c = focusedCursor.getNextSkip();
                        this.selection.toggleSelectDown(focusedCursor.getFrameAfter());
                    } else if (FrameEditorTab.hasBlockSkipModifierPressed(event) || this.viewProperty.get() == Frame.View.JAVA_PREVIEW && focusedCursor.getFrameAfter() != null && !focusedCursor.getFrameAfter().isFrameEnabled()) {
                        this.selection.clear();
                        c = focusedCursor.getNextSkip();
                    } else {
                        this.selection.clear();
                        c = focusedCursor.getParentCanvas().getNextCursor(focusedCursor, true);
                    }
                    if (c != null) {
                        c.requestFocus();
                    }
                    event.consume();
                    break;
                }
                case HOME: {
                    if (!blockCursorFocused) break;
                    this.topLevelFrame.focusOnBody(TopLevelFrame.BodyFocus.TOP);
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case END: {
                    if (!blockCursorFocused) break;
                    this.topLevelFrame.focusOnBody(TopLevelFrame.BodyFocus.BOTTOM);
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case LEFT: {
                    if (!blockCursorFocused) break;
                    Frame frameBefore = focusedCursor.getFrameBefore();
                    if (frameBefore != null) {
                        if (!frameBefore.focusFrameEnd(false)) {
                            focusedCursor.getUp().requestFocus();
                        }
                    } else {
                        Frame enclosingFrame = focusedCursor.getEnclosingFrame();
                        if (enclosingFrame != null) {
                            enclosingFrame.focusLeft((FrameContentItem)focusedCursor.getParentCanvas());
                        } else {
                            Debug.message((String)"No enclosing frame on cursor");
                        }
                    }
                    this.selection.clear();
                    event.consume();
                    break;
                }
                case RIGHT: {
                    if (!blockCursorFocused) break;
                    Frame frame = focusedCursor.getFrameAfter();
                    if (frame != null) {
                        if (!frame.focusFrameStart()) {
                            focusedCursor.getParentCanvas().getNextCursor(focusedCursor, true).requestFocus();
                        }
                    } else {
                        Frame enclosingFrame = focusedCursor.getEnclosingFrame();
                        if (enclosingFrame != null) {
                            enclosingFrame.focusRight((FrameContentItem)focusedCursor.getParentCanvas());
                        } else {
                            Debug.message((String)"No enclosing frame on cursor");
                        }
                    }
                    this.selection.clear();
                    event.consume();
                    break;
                }
                default: {
                    if (event.getCode() == this.getKey(InteractionManager.ShortcutKey.YES_ANYWHERE)) {
                        SuggestedFollowUpDisplay.shortcutTyped((InteractionManager)this, (InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.YES_ANYWHERE);
                        break;
                    }
                    if (event.getCode() != this.getKey(InteractionManager.ShortcutKey.NO_ANYWHERE)) break;
                    SuggestedFollowUpDisplay.shortcutTyped((InteractionManager)this, (InteractionManager.ShortcutKey)InteractionManager.ShortcutKey.NO_ANYWHERE);
                }
            }
        });
        this.scrollAndOverlays.addEventFilter(MouseEvent.ANY, e -> {
            this.anyButtonsPressed = e.isPrimaryButtonDown() || e.isSecondaryButtonDown() || e.isMiddleButtonDown();
        });
        this.controlPanel = new HBox();
        Button stepButton = new Button("Step");
        Button continueButton = new Button("Continue");
        this.controlPanel.getChildren().addAll((Object[])new Node[]{stepButton, continueButton});
        this.controlPanel.setSpacing(10.0);
        this.contentRoot.setCenter((Node)this.scrollAndOverlays);
        this.codeOverlayPane = new CodeOverlayPane();
        this.scrollContent = new StackPane();
        this.errorOverviewBar = new ErrorOverviewBar(this, (Pane)this.scrollContent, this::nextError);
        JavaFXUtil.addChangeListener((ObservableValue)this.errorOverviewBar.showingCount(), count -> {
            if (count.intValue() > 0) {
                JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"bj-tab-error"});
            } else {
                this.getStyleClass().removeAll((Object[])new String[]{"bj-tab-error"});
            }
        });
        this.contentRoot.setRight((Node)this.errorOverviewBar);
        this.loading = true;
        this.topLevelFrame = this.initialSource.createTopLevelFrame((InteractionManager)this);
        this.topLevelFrame.regenerateCode();
        TopLevelCodeElement el = (TopLevelCodeElement)this.topLevelFrame.getCode();
        el.updateSourcePositions();
        this.loading = false;
        this.nameProperty.bind((ObservableValue)this.topLevelFrame.nameProperty());
        JavaFXUtil.addChangeListener((ObservableValue)this.topLevelFrame.nameProperty(), n -> {
            this.editor.codeModified();
            EventQueue.invokeLater(() -> {
                try {
                    this.editor.save();
                }
                catch (IOException e) {
                    Debug.reportError((String)"Problem saving after name change", (Throwable)e);
                }
            });
        });
        JavaFXUtil.addChangeListener(this.viewProperty, this.menuManager::notifyView);
        this.birdseyeSelection = new Rectangle();
        JavaFXUtil.addStyleClass((Styleable)this.birdseyeSelection, (String[])new String[]{"birdseye-selection"});
        this.birdseyeSelectionPane = new Pane(new Node[]{this.birdseyeSelection});
        this.birdseyeSelectionPane.setVisible(false);
        this.birdseyeSelectionPane.setMouseTransparent(false);
        this.birdseyeSelectionPane.setOnMouseClicked(e -> {
            FrameCursor clickTarget = this.birdseyeManager.getClickedTarget(e.getSceneX(), e.getSceneY());
            if (clickTarget == null) {
                this.disableBirdseyeView();
            } else {
                this.disableBirdseyeView((Node)clickTarget.getNode(), () -> ((FrameCursor)clickTarget).requestFocus());
            }
            e.consume();
        });
        this.birdseyeSelectionPane.setOnMouseMoved(e -> this.birdseyeSelectionPane.setCursor(this.birdseyeManager.canClick(e.getSceneX(), e.getSceneY()) ? Cursor.HAND : Cursor.DEFAULT));
        this.scrollContent.getChildren().addAll((Object[])new Node[]{this.topLevelFrame.getNode(), this.codeOverlayPane.getNode(), this.birdseyeSelectionPane});
        this.scroll.setContent((Node)this.scrollContent);
        this.setContent((Node)this.contentRoot);
        this.contentRoot.addEventHandler(MouseEvent.MOUSE_PRESSED, Event::consume);
        this.topLevelFrame.bindMinHeight((DoubleBinding)this.viewportHeight);
        this.contentRoot.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case Y: {
                    if (Config.isMacOS() || !event.isShortcutDown() || event.isShiftDown()) break;
                    this.redo();
                    event.consume();
                    break;
                }
                case Z: {
                    if (!event.isShortcutDown()) break;
                    if (!event.isShiftDown()) {
                        if (this.undoRedoManager.isRecording()) {
                            this.endRecordingState(((CursorOrSlot)this.focusedItem.get()).getRecallableFocus());
                        }
                        this.undo();
                        event.consume();
                        break;
                    }
                    if (!Config.isMacOS()) break;
                    this.redo();
                    event.consume();
                    break;
                }
                case UP: {
                    if (this.viewProperty.get() != Frame.View.BIRDSEYE) break;
                    this.birdseyeManager.up();
                    this.calculateBirdseyeRectangle();
                    event.consume();
                    break;
                }
                case DOWN: {
                    if (this.viewProperty.get() != Frame.View.BIRDSEYE) break;
                    this.birdseyeManager.down();
                    this.calculateBirdseyeRectangle();
                    event.consume();
                    break;
                }
                case ENTER: {
                    if (this.viewProperty.get() != Frame.View.BIRDSEYE) break;
                    FrameCursor target = this.birdseyeManager.getCursorForCurrent();
                    this.disableBirdseyeView((Node)target.getNode(), () -> ((FrameCursor)target).requestFocus());
                    event.consume();
                    break;
                }
                case ESCAPE: {
                    if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
                        this.disableJavaPreview();
                        event.consume();
                        break;
                    }
                    if (this.viewProperty.get() != Frame.View.BIRDSEYE) break;
                    this.disableBirdseyeView();
                    event.consume();
                }
            }
        });
        this.contentRoot.addEventFilter(ScrollEvent.SCROLL, e -> {
            if (e.isShortcutDown()) {
                if (e.getDeltaY() > 0.0) {
                    this.increaseFontSize();
                } else {
                    this.decreaseFontSize();
                }
                e.consume();
            }
        });
        FrameEditorTab.addWeakFontSizeUpdater(this);
        this.updateFontSize();
        this.regenerateAndReparse(null);
        JavaFXUtil.bindMap(this.importedTypes, (ObservableList)this.topLevelFrame.getImports(), this::importsUpdated);
        if (this.topLevelFrame != null) {
            this.saved();
            this.topLevelFrame.getCode().findEarlyErrors().count();
            Platform.runLater(this::updateDisplays);
        }
        this.initialised.set(true);
    }

    public void cleanup() {
        FrameCursor.editorClosing((InteractionManager)this);
    }

    private static void addWeakFontSizeUpdater(FrameEditorTab ed) {
        PrefMgr.strideFontSizeProperty().addListener((ChangeListener)new WeakFontSizeUpdater(ed));
    }

    void resetFontSize() {
        PrefMgr.strideFontSizeProperty().set(11);
    }

    public void searchLink(PossibleLink link, FXConsumer<Optional<LinkedIdentifier>> paramCallback) {
        Consumer<Optional> callback = ol -> Platform.runLater(() -> paramCallback.accept(ol));
        if (link instanceof PossibleTypeLink) {
            String name = ((PossibleTypeLink)link).getTypeName();
            SwingUtilities.invokeLater(() -> {
                Package pkg = this.project.getPackage("");
                if (pkg.getAllClassnamesWithSource().contains(name)) {
                    Target t = pkg.getTarget(name);
                    if (t instanceof ClassTarget) {
                        callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                            link.getSlot().removeAllUnderlines();
                            SwingUtilities.invokeLater(() -> ((ClassTarget)t).open());
                        })));
                        return;
                    }
                } else {
                    TopLevelCodeElement code = (TopLevelCodeElement)this.topLevelFrame.getCode();
                    if (code != null) {
                        PackageOrClass resolved = code.getResolver().resolvePackageOrClass(name, null);
                        if (resolved.getName().startsWith("java.") || resolved.getName().startsWith("javax.")) {
                            callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openJavaCoreDocTab(resolved.getName()))));
                            return;
                        }
                        if (resolved.getName().startsWith("greenfoot.")) {
                            callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openGreenfootDocTab(resolved.getName()))));
                            return;
                        }
                    }
                }
                callback.accept(Optional.empty());
            });
        } else if (link instanceof PossibleKnownMethodLink) {
            PossibleKnownMethodLink pml = (PossibleKnownMethodLink)link;
            String qualClassName = pml.getQualClassName();
            String urlSuffix = pml.getURLMethodSuffix();
            SwingUtilities.invokeLater(() -> this.searchMethodLink(link, qualClassName, pml.getDisplayName(), pml.getDisplayName(), urlSuffix, callback));
        } else if (link instanceof PossibleMethodUseLink) {
            PossibleMethodUseLink pmul = (PossibleMethodUseLink)link;
            SwingUtilities.invokeLater(() -> {
                List candidates = this.editor.getAvailableMembers((TopLevelCodeElement)this.topLevelFrame.getCode(), (JavaFragment.PosInSourceDoc)pmul.getSourcePositionSupplier().get(), Collections.singleton(AssistContent.CompletionKind.METHOD), true).stream().filter(ac -> ac.getName().equals(pmul.getMethodName())).collect(Collectors.toList());
                if (candidates.size() > 1 && candidates.stream().anyMatch(ac -> ac.getParams().size() == pmul.getNumParams())) {
                    candidates.removeIf(ac -> ac.getParams().size() != pmul.getNumParams());
                }
                if (candidates.size() >= 1) {
                    AssistContent ac2 = (AssistContent)candidates.get(0);
                    String displayName = ac2.getName() + "(" + ac2.getParams().stream().map(AssistContent.ParamInfo::getUnqualifiedType).collect(Collectors.joining(", ")) + ")";
                    this.searchMethodLink(link, ac2.getDeclaringClass(), ac2.getName(), displayName, PossibleKnownMethodLink.encodeSuffix((String)ac2.getName(), (List)Utility.mapList((Collection)ac2.getParams(), AssistContent.ParamInfo::getQualifiedType)), callback);
                } else {
                    callback.accept(Optional.empty());
                }
            });
        } else if (link instanceof PossibleVarLink) {
            String name = ((PossibleVarLink)link).getVarName();
            CodeElement el = ((PossibleVarLink)link).getUsePoint();
            FrameEditorTab ed = (FrameEditorTab)ASTUtility.getTopLevelElement((CodeElement)el).getEditor();
            if (ed == this) {
                callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> el.show(Frame.ShowReason.LINK_TARGET))));
            } else {
                callback.accept(Optional.of(new LinkedIdentifier(name, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                    this.getParent().setWindowVisible(true, ed);
                    el.show(Frame.ShowReason.LINK_TARGET);
                })));
            }
        }
    }

    @OnThread(value=Tag.Swing)
    private void searchMethodLink(PossibleLink link, String qualClassName, String methodName, String methodDisplayName, String urlSuffix, Consumer<Optional<LinkedIdentifier>> callback) {
        Package pkg = this.project.getPackage("");
        if (pkg.getAllClassnamesWithSource().contains(qualClassName)) {
            Target t = pkg.getTarget(qualClassName);
            if (t instanceof ClassTarget) {
                ClassTarget classTarget = (ClassTarget)t;
                callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> {
                    link.getSlot().removeAllUnderlines();
                    SwingUtilities.invokeLater(() -> {
                        classTarget.open();
                        classTarget.getEditor().focusMethod(methodName);
                    });
                })));
                return;
            }
        } else {
            TopLevelCodeElement code = (TopLevelCodeElement)this.topLevelFrame.getCode();
            if (code != null) {
                PackageOrClass resolved = code.getResolver().resolvePackageOrClass(qualClassName, null);
                if (resolved.getName().startsWith("java.") || resolved.getName().startsWith("javax.")) {
                    callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openJavaCoreDocTab(resolved.getName(), urlSuffix))));
                    return;
                }
                if (resolved.getName().startsWith("greenfoot.")) {
                    callback.accept(Optional.of(new LinkedIdentifier(methodDisplayName, link.getStartPosition(), link.getEndPosition(), link.getSlot(), () -> this.getParent().openGreenfootDocTab(resolved.getName(), urlSuffix))));
                    return;
                }
            }
        }
        callback.accept(Optional.empty());
    }

    void enableBirdseyeView() {
        if (this.viewProperty.get() == Frame.View.NORMAL && this.topLevelFrame.canDoBirdseye()) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.viewChange.addOnStopped(() -> JavaFXUtil.runAfter((Duration)Duration.millis((double)50.0), () -> {
                this.birdseyeSelectionPane.setVisible(true);
                this.calculateBirdseyeRectangle();
            }));
            this.birdseyeDefaultFocusAfter = this.scroll.getScene().getFocusOwner();
            this.birdseyeDefaultRequestFocusAfter = () -> {
                if (this.birdseyeDefaultFocusAfter != null) {
                    this.birdseyeDefaultFocusAfter.requestFocus();
                }
            };
            this.birdseyeManager = this.topLevelFrame.prepareBirdsEyeView(this.viewChange);
            this.viewProperty.set((Object)Frame.View.BIRDSEYE);
            this.setupAnimateViewTo(Frame.View.NORMAL, Frame.View.BIRDSEYE, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)500.0));
        } else if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
            this.disableJavaPreview();
            this.enableBirdseyeView();
        }
    }

    void disableBirdseyeView(Node viewTarget, FXRunnable requestFocus) {
        if (this.viewProperty.get() == Frame.View.BIRDSEYE) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.birdseyeSelectionPane.setVisible(false);
            this.birdseyeManager = null;
            FXRunnable remove = JavaFXUtil.addChangeListener((ObservableValue)viewTarget.localToSceneTransformProperty(), t -> {
                if (!this.inScrollTo) {
                    this.scrollTo(viewTarget, -200.0);
                }
            });
            this.viewChange.addOnStopped(() -> {
                remove.run();
                if (requestFocus != null) {
                    requestFocus.run();
                }
            });
            this.viewProperty.set((Object)Frame.View.NORMAL);
            this.setupAnimateViewTo(Frame.View.BIRDSEYE, Frame.View.NORMAL, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)500.0));
        }
    }

    void disableBirdseyeView() {
        this.disableBirdseyeView(this.birdseyeDefaultFocusAfter, this.birdseyeDefaultRequestFocusAfter);
    }

    void enableJavaPreview() {
        if (this.viewProperty.get() == Frame.View.NORMAL) {
            this.selection.clear();
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.viewProperty.set((Object)Frame.View.JAVA_PREVIEW);
            this.setupAnimateViewTo(Frame.View.NORMAL, Frame.View.JAVA_PREVIEW, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)3000.0));
        } else if (this.viewProperty.get() == Frame.View.BIRDSEYE) {
            this.disableBirdseyeView();
            this.enableJavaPreview();
        }
    }

    void disableJavaPreview() {
        if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
            if (this.viewChange != null) {
                this.viewChange.stop();
            }
            this.viewChange = new SharedTransition();
            this.viewProperty.set((Object)Frame.View.NORMAL);
            this.setupAnimateViewTo(Frame.View.JAVA_PREVIEW, Frame.View.NORMAL, this.viewChange);
            this.viewChange.animateOver(Duration.millis((double)3000.0));
        }
    }

    private void setupAnimateViewTo(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        FrameCursor fixpoint = this.getFocusedCursor();
        double y = fixpoint == null ? 0.0 : fixpoint.getSceneBounds().getMinY() - this.scroll.localToScene(this.scroll.getBoundsInLocal()).getMinY();
        this.topLevelFrame.getAllFrames().forEach(f -> f.setView(oldView, newView, animateProgress));
        if (fixpoint != null) {
            FrameCursor finalFixpoint = fixpoint;
            FXRunnable remove = JavaFXUtil.addChangeListener((ObservableValue)this.getFocusedCursor().getNode().localToSceneTransformProperty(), ignore -> this.scrollTo((Node)finalFixpoint.getNode(), -y));
            animateProgress.addOnStopped(() -> FXRunnable.runLater((FXRunnable)remove));
        }
        this.getParent().scheduleUpdateCatalogue(this, newView == Frame.View.NORMAL ? this.getFocusedCursor() : null, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, newView, Collections.emptyList());
    }

    public BooleanProperty cheatSheetShowingProperty() {
        return this.getParent().catalogueShowingProperty();
    }

    @Override
    public void focusWhenShown() {
        this.topLevelFrame.focusOnBody(TopLevelFrame.BodyFocus.BEST_PICK);
    }

    public void cancelFreshState() {
        this.topLevelFrame.getAllFrames().forEach(Frame::markNonFresh);
    }

    public void blockDragBegin(Frame b, double mouseSceneX, double mouseSceneY) {
        if (this.dragTarget != null) {
            throw new IllegalStateException("Drag begun while drag in progress");
        }
        if (this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
            return;
        }
        if (this.selection.contains(b)) {
            this.getParent().frameDragBegin(this.selection.getSelected(), mouseSceneX, mouseSceneY);
        } else {
            this.getParent().frameDragBegin(Arrays.asList(b), mouseSceneX, mouseSceneY);
        }
    }

    public boolean isDragging() {
        return this.getParent().isDragging();
    }

    public void blockDragEnd(boolean copying) {
        this.getParent().frameDragEnd(copying);
    }

    void dragEndTab(List<Frame> dragSourceFrames, boolean copying) {
        if (dragSourceFrames != null && !dragSourceFrames.isEmpty() && this.dragTarget != null) {
            boolean canMove = true;
            for (Frame src : dragSourceFrames) {
                src.setDragSourceEffect(false);
                canMove &= this.dragTarget.getParentCanvas().acceptsType(src);
            }
            if (canMove && !FrameEditorTab.isUselessDrag(this.dragTarget, dragSourceFrames, copying)) {
                this.beginRecordingState((RecallableFocus)this.dragTarget);
                this.performDrag(dragSourceFrames, copying);
                this.endRecordingState((RecallableFocus)this.dragTarget);
            }
            this.selection.clear();
            this.dragTarget.stopShowAsDropTarget();
            this.dragTarget = null;
        }
    }

    private void performDrag(List<Frame> dragSourceFrames, boolean copying) {
        boolean shouldDisable = !this.dragTarget.getParentCanvas().getParent().getFrame().isFrameEnabled();
        Collections.reverse(dragSourceFrames);
        if (!copying) {
            for (Frame src : dragSourceFrames) {
                src.getParentCanvas().removeBlock(src);
                this.dragTarget.insertBlockAfter(src);
                if (shouldDisable) {
                    src.setFrameEnabled(false);
                }
                this.modifiedFrame(src);
            }
        } else {
            List elements = GreenfootFrameUtil.getElementsForMultipleFrames(dragSourceFrames);
            for (CodeElement codeElement : elements) {
                Frame frame = codeElement.createFrame((InteractionManager)this);
                this.dragTarget.insertBlockAfter(frame);
                if (!shouldDisable) continue;
                frame.setFrameEnabled(false);
            }
        }
    }

    protected void draggedTo(double sceneX, double sceneY, boolean copying) {
        this.getParent().draggedTo(sceneX, sceneY, copying);
    }

    void draggedToTab(List<Frame> dragSourceFrames, double sceneX, double sceneY, boolean copying) {
        FrameCursor newDragTarget = this.topLevelFrame.findCursor(sceneX, sceneY, null, null, dragSourceFrames, true, true);
        if (newDragTarget != null && this.dragTarget != newDragTarget) {
            if (this.dragTarget != null) {
                this.dragTarget.stopShowAsDropTarget();
                this.dragTarget = null;
            }
            boolean src = FrameEditorTab.isUselessDrag(newDragTarget, dragSourceFrames, copying);
            boolean acceptsAll = true;
            for (Frame srcFrame : dragSourceFrames) {
                acceptsAll &= newDragTarget.getParentCanvas().acceptsType(srcFrame);
            }
            newDragTarget.showAsDropTarget(src, acceptsAll, copying);
            this.dragTarget = newDragTarget;
        }
        if (this.dragTarget != null) {
            this.dragTarget.updateDragCopyState(copying);
        }
    }

    void draggedToAnotherTab() {
        if (this.dragTarget != null) {
            this.dragTarget.stopShowAsDropTarget();
            this.dragTarget = null;
        }
    }

    public void clickNearestCursor(double sceneX, double sceneY, boolean shiftDown) {
        FrameCursor target = this.topLevelFrame.findCursor(sceneX, sceneY, null, null, null, false, true);
        if (target != null) {
            if (shiftDown && this.viewProperty.get() != Frame.View.JAVA_PREVIEW) {
                FrameCursor anchor;
                if (this.selection.getSelected().size() == 0) {
                    anchor = this.getFocusedCursor();
                } else {
                    FrameCursor frameCursor = anchor = this.selection.getCursorAfter() == this.getFocusedCursor() ? this.selection.getCursorBefore() : this.selection.getCursorAfter();
                }
                if (this.getFocusedCursor() == null || target.getParentCanvas() != anchor.getParentCanvas()) {
                    return;
                }
                this.selection.set(target.getParentCanvas().framesBetween(anchor, target));
                target.requestFocus();
            } else {
                target.requestFocus();
                this.selection.clear();
            }
        }
    }

    public FrameDictionary<GreenfootFrameCategory> getDictionary() {
        return GreenfootFrameDictionary.getDictionary();
    }

    public void setupFrameCursor(final FrameCursor f) {
        f.getNode().setOnDragDetected(e -> {
            this.selectingByDrag = true;
            e.consume();
        });
        f.getNode().setOnMouseDragged(e -> {
            if (!this.selectingByDrag || this.viewProperty.get() == Frame.View.JAVA_PREVIEW) {
                return;
            }
            FrameCanvas fCanvas = f.getParentCanvas();
            FrameCursor closest = fCanvas.getParent().findCursor(e.getSceneX(), e.getSceneY(), fCanvas.getFirstCursor(), fCanvas.getLastCursor(), null, true, false);
            if (closest != null) {
                this.selection.set(fCanvas.framesBetween(closest, f));
            }
            e.consume();
        });
        f.getNode().setOnMouseReleased(e -> {
            if (this.selectingByDrag) {
                this.selectingByDrag = false;
                e.consume();
            }
        });
        JavaFXUtil.addChangeListener((ObservableValue)f.getNode().focusedProperty(), (FXConsumer)new FXConsumer<Boolean>(){
            private FXRunnable cancelTimer;

            public void accept(Boolean focused) {
                if (FrameEditorTab.this.getParent() != null) {
                    FrameEditorTab.this.getParent().scheduleUpdateCatalogue(FrameEditorTab.this, focused != false ? f : null, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, !FrameEditorTab.this.selection.getSelected().isEmpty(), FrameEditorTab.this.getView(), Collections.emptyList());
                }
                if (this.cancelTimer != null) {
                    this.cancelTimer.run();
                    this.cancelTimer = null;
                }
                if (!focused.booleanValue()) {
                    this.hideError();
                } else {
                    this.cancelTimer = JavaFXUtil.runRegular((Duration)Duration.millis((double)1000.0), this::updateFocusedDisplay);
                }
            }

            private void hideError() {
                if (FrameEditorTab.this.cursorErrorDisplay != null) {
                    FrameEditorTab.this.cursorErrorDisplay.hide();
                    FrameEditorTab.this.cursorErrorDisplay = null;
                }
            }

            private void updateFocusedDisplay() {
                if (!f.getNode().focusedProperty().get()) {
                    this.hideError();
                    return;
                }
                Optional maybeErr = Optional.ofNullable(f.getFrameAfter()).flatMap(fr -> fr.getCurrentErrors().findFirst());
                if (maybeErr.isPresent()) {
                    if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                        return;
                    }
                    this.hideError();
                    FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Below: ", (CodeError)maybeErr.get(), null);
                    FrameEditorTab.this.cursorErrorDisplay.showAbove(f.getNode());
                } else {
                    maybeErr = Optional.ofNullable(f.getFrameBefore()).flatMap(fr -> fr.getCurrentErrors().findFirst());
                    if (maybeErr.isPresent()) {
                        if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                            return;
                        }
                        this.hideError();
                        FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Above: ", (CodeError)maybeErr.get(), null);
                        FrameEditorTab.this.cursorErrorDisplay.showBelow(f.getNode());
                    } else {
                        maybeErr = Optional.ofNullable(f.getParentCanvas().getParent()).map(CanvasParent::getFrame).flatMap(fr -> fr.getCurrentErrors().findFirst());
                        if (maybeErr.isPresent() && ((CodeError)maybeErr.get()).visibleProperty().get()) {
                            if (FrameEditorTab.this.cursorErrorDisplay != null && maybeErr.get() == FrameEditorTab.this.cursorErrorDisplay.getError()) {
                                return;
                            }
                            this.hideError();
                            FrameEditorTab.this.cursorErrorDisplay = new ErrorAndFixDisplay((InteractionManager)FrameEditorTab.this, "Enclosing frame: ", (CodeError)maybeErr.get(), null);
                            FrameEditorTab.this.cursorErrorDisplay.showBelow(f.getNode());
                        } else {
                            this.hideError();
                        }
                    }
                }
            }
        });
        this.setupFocusable(new CursorOrSlot(f), (Node)f.getNode());
    }

    public void setupFrame(Frame f) {
        JavaFXUtil.listenForContextMenu((Node)f.getNode(), (x, y) -> {
            if (this.viewProperty.get() != Frame.View.NORMAL) {
                return true;
            }
            if (!this.selection.contains(f)) {
                this.selection.set(Arrays.asList(f));
            }
            if (this.menu != null) {
                this.menu.hide();
            }
            this.menu = this.selection.getContextMenu();
            if (this.menu != null) {
                this.menu.show(f.getNode(), x.doubleValue(), y.doubleValue());
                return true;
            }
            return false;
        });
        f.getNode().addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (this.getFocusedCursor() != null && e.isShiftDown()) {
                e.consume();
            }
        });
        f.getNode().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.isStillSincePress() && f.leftClicked(event.getSceneX(), event.getSceneY(), event.isShiftDown())) {
                event.consume();
            }
        });
        f.getNode().setOnDragDetected(event -> {
            this.blockDragBegin(f, event.getSceneX(), event.getSceneY());
            event.consume();
        });
        f.getNode().setOnMouseDragged(event -> {
            this.draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.isDragCopyKeyPressed((MouseEvent)event));
            event.consume();
        });
        f.getNode().setOnMouseReleased(event -> {
            if (!this.isDragging()) {
                return;
            }
            this.draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.isDragCopyKeyPressed((MouseEvent)event));
            this.blockDragEnd(JavaFXUtil.isDragCopyKeyPressed((MouseEvent)event));
            event.consume();
        });
    }

    public FrameCursor createCursor(FrameCanvas parent) {
        return new FrameCursor(this, parent);
    }

    @OnThread(value=Tag.Any)
    public TopLevelCodeElement getSource() {
        if (this.topLevelFrame == null) {
            return null;
        }
        return (TopLevelCodeElement)this.topLevelFrame.getCode();
    }

    private void regenerateCode() {
        if (this.topLevelFrame != null) {
            this.topLevelFrame.regenerateCode();
        }
    }

    public void flagErrorsAsOld() {
        this.topLevelFrame.flagErrorsAsOld();
    }

    public void removeOldErrors() {
        this.topLevelFrame.removeOldErrors();
        this.errors = null;
        this.updateErrorOverviewBar(false);
    }

    void updateErrorOverviewBar(boolean waitingForCompile) {
        if (this.topLevelFrame == null) {
            return;
        }
        List<ErrorOverviewBar.ErrorInfo> errors = this.getAllErrors().filter(e -> e.getRelevantNode() != null).map(e -> new ErrorOverviewBar.ErrorInfo(e.getMessage(), e.getRelevantNode(), e.visibleProperty(), (ObservableBooleanValue)e.focusedProperty(), () -> {
            if (this.getView() == Frame.View.BIRDSEYE) {
                this.disableBirdseyeView(e.getRelevantNode(), () -> e.jumpTo((InteractionManager)this));
            } else {
                e.jumpTo((InteractionManager)this);
            }
        })).collect(Collectors.toList());
        ErrorOverviewBar.ErrorState state = waitingForCompile || this.topLevelFrame.getAllFrames().anyMatch(Frame::isFresh) ? ErrorOverviewBar.ErrorState.EDITING : (errors.stream().filter(e -> e.isVisible()).count() == 0L ? ErrorOverviewBar.ErrorState.NO_ERRORS : ErrorOverviewBar.ErrorState.ERRORS);
        this.errorOverviewBar.update(errors, state);
    }

    private Stream<CodeError> getAllErrors() {
        return Stream.concat(this.topLevelFrame.getEditableSlots().flatMap(EditableSlot::getCurrentErrors), this.topLevelFrame.getAllFrames().flatMap(Frame::getCurrentErrors));
    }

    public void modifiedFrame(Frame f) {
        if (f != null) {
            f.trackBlank();
        }
        if (this.isLoading()) {
            return;
        }
        this.editor.codeModified();
        this.registerStackHighlight(null);
        this.updateErrorOverviewBar(true);
        this.getParent().scheduleCompilation();
        SuggestedFollowUpDisplay.modificationIn((InteractionManager)this);
    }

    public void setWindowVisible(boolean vis, boolean bringToFront) {
        if (this.getParent() == null) {
            this.parent.setValue((Object)this.project.getDefaultFXTabbedEditor());
        }
        if (vis) {
            this.getParent().addTab(this, vis, bringToFront);
        }
        this.getParent().setWindowVisible(vis, this);
        if (bringToFront) {
            this.getParent().bringToFront(this);
        }
    }

    public boolean isWindowVisible() {
        return this.getParent() != null && this.getParent().containsTab(this) && this.getParent().isWindowVisible();
    }

    public void withCompletions(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl, FXConsumer<List<AssistContentThreadSafe>> handler) {
        TopLevelCodeElement allCode = this.getSource();
        JavaFXUtil.bindFuture((Future)Utility.swingFuture(() -> Utility.mapList(Arrays.asList(this.editor.getCompletions(allCode, pos, completing, codeEl)), AssistContentThreadSafe::copy)), arg_0 -> handler.accept(arg_0));
    }

    public void withSuperConstructors(FXConsumer<List<AssistContentThreadSafe>> handler) {
        TopLevelCodeElement codeEl = this.getSource();
        JavaFXUtil.bindFuture((Future)Utility.swingFuture(() -> Utility.mapList((Collection)codeEl.getSuperConstructors(), c -> new AssistContentThreadSafe((AssistContent)new ConstructorCompletion(c, Collections.emptyMap(), this.editor.getJavadocResolver())))), arg_0 -> handler.accept(arg_0));
    }

    public List<AssistContentThreadSafe> getThisConstructors() {
        TopLevelCodeElement codeEl = this.getSource();
        return codeEl.getThisConstructors();
    }

    public void beginRecordingState(RecallableFocus f) {
        this.undoRedoManager.beginFrameState(this.getCurrentState(f));
    }

    public void endRecordingState(RecallableFocus f) {
        this.undoRedoManager.endFrameState(this.getCurrentState(f));
    }

    private FrameState getCurrentState(RecallableFocus f) {
        this.regenerateCode();
        return new FrameState(this.topLevelFrame, this.getSource(), f);
    }

    public void undo() {
        this.undoRedoManager.startRestoring();
        this.updateClassContents(this.undoRedoManager.undo());
        this.undoRedoManager.stopRestoring();
    }

    public void redo() {
        this.undoRedoManager.startRestoring();
        this.updateClassContents(this.undoRedoManager.redo());
        this.undoRedoManager.stopRestoring();
    }

    private void updateClassContents(FrameState state) {
        if (state != null) {
            ClassElement classElement = state.getClassElement(this.projectResolver);
            if (classElement == null) {
                return;
            }
            this.topLevelFrame.restoreCast((TopLevelCodeElement)classElement);
            this.topLevelFrame.regenerateCode();
            Node n = state.recallFocus(this.topLevelFrame);
            if (n != null) {
                this.ensureNodeVisible(n);
            }
        }
    }

    public void scrollTo(Node n, double yOffsetFromTop, Duration duration) {
        if (this.inScrollTo) {
            return;
        }
        this.inScrollTo = true;
        Bounds totalBound = this.scroll.getContent().localToScene(this.scroll.getContent().getBoundsInLocal());
        Bounds targetBound = n.localToScene(n.getBoundsInLocal());
        double totalMinusView = totalBound.getHeight() - this.scroll.getHeight();
        double targetV = Math.max(0.0, Math.min(1.0, (targetBound.getMinY() + yOffsetFromTop - totalBound.getMinY()) / totalMinusView));
        targetV = this.scroll.getVmin() + targetV * (this.scroll.getVmax() - this.scroll.getVmin());
        if (duration == null) {
            this.scroll.setVvalue(targetV);
        } else {
            this.animatingScroll = true;
            Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.scroll.vvalueProperty(), (Object)targetV)})});
            t.setOnFinished(e -> {
                this.animatingScroll = false;
            });
            t.play();
        }
        this.inScrollTo = false;
    }

    public FrameSelection getSelection() {
        return this.selection;
    }

    public Point2D sceneToScreen(Point2D scenePoint) {
        Scene scene = this.scrollAndOverlays.getScene();
        return scenePoint.add(scene.getX(), scene.getY()).add(scene.getWindow().getX(), scene.getWindow().getY());
    }

    public void saved() {
        this.topLevelFrame.saved();
        this.topLevelFrame.getEditableSlots().forEach(EditableSlot::saved);
    }

    public void withAccessibleMembers(JavaFragment.PosInSourceDoc pos, Set<AssistContent.CompletionKind> kinds, boolean includeOverriden, FXConsumer<List<AssistContentThreadSafe>> handler) {
        TopLevelCodeElement allCode = this.getSource();
        JavaFXUtil.bindFuture((Future)Utility.swingFuture(() -> Utility.mapList(this.editor.getAvailableMembers(allCode, pos, kinds, includeOverriden), AssistContentThreadSafe::copy)), arg_0 -> handler.accept(arg_0));
    }

    @OnThread(value=Tag.FX)
    public void regenerateAndReparse(ExpressionSlot<?> completing) {
        this.regenerateCode();
        if (this.topLevelFrame != null) {
            TopLevelCodeElement code = (TopLevelCodeElement)this.topLevelFrame.getCode();
            code.updateSourcePositions();
        }
    }

    private void updateDisplays() {
        CodeElement el;
        if (this.topLevelFrame != null && (el = this.topLevelFrame.getCode()) != null) {
            this.topLevelFrame.getAllFrames().forEach(f -> {
                if (f instanceof NormalMethodFrame) {
                    SwingUtilities.invokeLater(() -> ((NormalMethodFrame)f).updateOverrideDisplay((ClassElement)el));
                }
            });
        }
    }

    private void updateFontSize() {
        this.topLevelFrame.getNode().setStyle("-fx-font-size: " + (String)this.getFontSizeCSS().get() + ";");
    }

    void decreaseFontSize() {
        IntegerProperty fontSize;
        int prev = (fontSize = PrefMgr.strideFontSizeProperty()).get();
        fontSize.set(Math.max(6, prev >= 36 ? prev - 4 : (prev >= 16 ? prev - 2 : prev - 1)));
    }

    void increaseFontSize() {
        IntegerProperty fontSize;
        int prev = (fontSize = PrefMgr.strideFontSizeProperty()).get();
        fontSize.set(Math.min(160, prev < 32 ? (prev < 14 ? prev + 1 : prev + 2) : prev + 4));
    }

    public StringExpression getFontSizeCSS() {
        return PrefMgr.strideFontSizeProperty().asString().concat((Object)"pt");
    }

    private void calculateBirdseyeRectangle() {
        Node n = this.birdseyeManager.getNodeForRectangle();
        Point2D scene = n.localToScene(n.getBoundsInLocal().getMinX(), n.getBoundsInLocal().getMinY());
        Point2D onPane = this.topLevelFrame.getNode().sceneToLocal(scene);
        this.birdseyeSelection.setX(onPane.getX());
        this.birdseyeSelection.setY(onPane.getY() + 1.5);
        this.birdseyeSelection.setWidth(n.getBoundsInLocal().getWidth());
        this.birdseyeSelection.setHeight(n.getBoundsInLocal().getHeight() - 1.5);
        this.birdseyeSelection.setFocusTraversable(true);
        this.birdseyeSelection.requestFocus();
    }

    @OnThread(value=Tag.Swing)
    private List<AssistContentThreadSafe> getPrimitiveTypes() {
        if (prims == null) {
            prims = PrimitiveTypeCompletion.allPrimitiveTypes().stream().map(AssistContentThreadSafe::copy).collect(Collectors.toList());
        }
        return prims;
    }

    @OnThread(value=Tag.Any)
    public void withTypes(Class<?> superType, boolean includeSelf, Set<InteractionManager.Kind> kinds, FXConsumer<List<AssistContentThreadSafe>> handler) {
        ArrayList r = new ArrayList();
        SwingUtilities.invokeLater(() -> {
            if (kinds.contains(InteractionManager.Kind.PRIMITIVE)) {
                r.addAll(this.getPrimitiveTypes());
            }
            r.addAll(this.editor.getLocalTypes(superType, includeSelf, kinds));
            Utility.getBackground().schedule(() -> {
                r.addAll(this.getImportedTypes(superType, includeSelf, kinds).stream().sorted(Comparator.comparing(AssistContentThreadSafe::getName)).distinct().collect(Collectors.toList()));
                Platform.runLater(() -> handler.accept((Object)r));
            }, 0L, TimeUnit.MILLISECONDS);
        });
    }

    @OnThread(value=Tag.Any)
    public void withTypes(FXConsumer<List<AssistContentThreadSafe>> handler) {
        this.withTypes(null, true, InteractionManager.Kind.all(), handler);
    }

    public boolean insertAppendMethod(NormalMethodElement method) {
        if (this.topLevelFrame != null) {
            for (NormalMethodFrame normalMethodFrame : this.topLevelFrame.getMethods()) {
                if (!normalMethodFrame.getName().equals(method.getName())) continue;
                this.insertMethodContentsIntoMethodFrame((MethodWithBodyElement)method, (MethodFrameWithBody<? extends MethodWithBodyElement>)normalMethodFrame);
                return true;
            }
            this.insertMethodElementAtTheEnd((MethodWithBodyElement)method);
        } else {
            Debug.message((String)"insertAppendMethod @ FrameEditorTab: class frame is null!");
        }
        return false;
    }

    public boolean insertMethodCallInConstructor(String className, CallElement methodCall) {
        if (this.topLevelFrame != null) {
            if (this.topLevelFrame.getConstructors().isEmpty()) {
                this.topLevelFrame.addDefaultConstructor();
            }
            for (ConstructorFrame constructorFrame : this.topLevelFrame.getConstructors()) {
                for (CodeFrame innerFrame : constructorFrame.getMembersFrames()) {
                    CallFrame doFrame;
                    if (!(innerFrame instanceof CallFrame) || !(doFrame = (CallFrame)innerFrame).getCode().toJavaSource().toTemporaryJavaCodeString().equals(methodCall.toJavaSource().toTemporaryJavaCodeString())) continue;
                    return true;
                }
                this.insertElementIntoMethod((CodeElement)methodCall, (MethodFrameWithBody<? extends MethodWithBodyElement>)constructorFrame);
            }
        } else {
            Debug.message((String)"insertMethodCallInConstructor @ FrameEditorTab: class frame is null!");
        }
        return false;
    }

    public void insertElementIntoMethod(CodeElement element, MethodFrameWithBody<? extends MethodWithBodyElement> methodFrame) {
        Platform.runLater(() -> methodFrame.getLastInternalCursor().insertBlockAfter(element.createFrame((InteractionManager)this)));
    }

    private void insertMethodContentsIntoMethodFrame(MethodWithBodyElement methodElement, MethodFrameWithBody<? extends MethodWithBodyElement> methodFrame) {
        Platform.runLater(() -> {
            for (CodeElement element : methodElement.getContents()) {
                methodFrame.getLastInternalCursor().insertBlockAfter(element.createFrame((InteractionManager)this));
            }
        });
    }

    private void insertMethodElementAtTheEnd(MethodWithBodyElement method) {
        Platform.runLater(() -> this.topLevelFrame.insertAtEnd(method.createFrame((InteractionManager)this)));
    }

    @OnThread(value=Tag.Any)
    private Stream<AssistContentThreadSafe> getAllImportedTypes() {
        return Stream.concat(Stream.of(javaLangImports), this.importedTypes.stream()).map(FrameEditorTab::getFutureList).flatMap(Collection::stream);
    }

    @OnThread(value=Tag.Any)
    private List<AssistContentThreadSafe> getImportedTypes(Class<?> superType, boolean includeSelf, Set<InteractionManager.Kind> kinds) {
        if (superType == null) {
            return this.getAllImportedTypes().filter(ac -> kinds.contains(ac.getTypeKind())).collect(Collectors.toList());
        }
        return this.getAllImportedTypes().filter(ac -> kinds.contains(ac.getTypeKind())).filter(ac -> ac.getSuperTypes().contains(superType.getName()) || includeSelf && ac.getPackage() != null && (ac.getPackage() + "." + ac.getName()).equals(superType.getName())).collect(Collectors.toList());
    }

    public Collection<AssistContentThreadSafe> getOtherPopularImports() {
        HashMap popular = new HashMap();
        popularImports.stream().map(FrameEditorTab::getFutureList).flatMap(Collection::stream).filter(imp -> imp.getPackage() != null).forEach(imp -> popular.put(imp.getPackage() + "." + imp.getName(), imp));
        this.getAllImportedTypes().filter(imp -> imp.getPackage() != null).forEach(imp -> {
            AssistContentThreadSafe cfr_ignored_0 = (AssistContentThreadSafe)popular.remove(imp.getPackage() + "." + imp.getName());
        });
        return popular.values();
    }

    public void addImport(String importSrc) {
        this.topLevelFrame.addImport(importSrc);
    }

    public List<InteractionManager.FileCompletion> getAvailableFilenames() {
        File soundDir;
        ArrayList<InteractionManager.FileCompletion> r = new ArrayList<InteractionManager.FileCompletion>();
        File imageDir = new File(this.project.getProjectDir(), "images");
        if (imageDir.exists()) {
            File[] files = imageDir.listFiles(name -> name.getName().toLowerCase().endsWith(".png") || name.getName().toLowerCase().endsWith(".jpg") || name.getName().toLowerCase().endsWith(".jpeg"));
            r.addAll(Utility.mapList(Arrays.asList(files), ImageCompletion::new));
        }
        if ((soundDir = new File(this.project.getProjectDir(), "sounds")).exists()) {
            File[] files = soundDir.listFiles(name -> name.getName().toLowerCase().endsWith(".wav"));
            r.addAll(Utility.mapList(Arrays.asList(files), SoundCompletion::new));
        }
        return r;
    }

    public void nextError() {
        if (this.errors == null || !this.errors.hasNext()) {
            this.errors = this.getAllErrors().iterator();
        }
        while (this.errors.hasNext()) {
            CodeError e = this.errors.next();
            if (!e.visibleProperty().get()) continue;
            e.jumpTo((InteractionManager)this);
            return;
        }
    }

    public void registerStackHighlight(Frame frame) {
        if (this.stackHighlight != null && this.stackHighlight != frame) {
            this.stackHighlight.removeStackHighlight();
        }
        this.stackHighlight = frame;
    }

    public ObservableBooleanValue initialisedProperty() {
        return this.initialised;
    }

    public ObservableStringValue nameProperty() {
        return this.nameProperty;
    }

    public void setupFocusableSlotComponent(EditableSlot parent, Node node, boolean canCodeComplete, List<FrameCatalogue.Hint> hints) {
        node.focusedProperty().addListener((a, b, focused) -> {
            if (focused.booleanValue()) {
                this.selection.clear();
            }
            this.getParent().scheduleUpdateCatalogue(this, null, focused != false && canCodeComplete ? FXTabbedEditor.CodeCompletionState.POSSIBLE : FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, this.getView(), hints);
        });
        node.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            if (this.dragTarget == null && e.isShortcutDown()) {
                if (this.showingUnderlinesFor != parent) {
                    if (this.showingUnderlinesFor != null) {
                        this.showingUnderlinesFor.removeAllUnderlines();
                    }
                    this.showingUnderlinesFor = parent;
                    parent.findLinks().stream().forEach(l -> this.searchLink((PossibleLink)l, (FXConsumer<Optional<LinkedIdentifier>>)((FXConsumer)olid -> olid.ifPresent(lid -> lid.show()))));
                }
            } else if (this.showingUnderlinesFor == parent) {
                this.showingUnderlinesFor = null;
                parent.removeAllUnderlines();
            }
        });
        node.addEventHandler(MouseEvent.MOUSE_EXITED, e -> {
            if (this.showingUnderlinesFor == parent) {
                this.showingUnderlinesFor = null;
                parent.removeAllUnderlines();
            }
        });
        this.setupFocusable(new CursorOrSlot(parent), node);
    }

    private void setupFocusable(CursorOrSlot parent, final Node node) {
        node.focusedProperty().addListener((a, b, focused) -> {
            if (focused.booleanValue()) {
                this.focusedItem.set((Object)parent);
                if (this.menu != null) {
                    this.menu.hide();
                }
                if (parent.isInsideCanvas(this.topLevelFrame.getImportCanvas())) {
                    this.topLevelFrame.ensureImportCanvasShowing();
                }
                if (!(this.animatingScroll || this.anyButtonsPressed || this.manualScrolledSinceLastFocusChange)) {
                    this.ensureNodeVisible(node);
                }
                if (this.topLevelFrame != null) {
                    List<EditableSlot> lostFocusSlots = this.topLevelFrame.getEditableSlots().filter(s -> !parent.matchesSlot((EditableSlot)s)).collect(Collectors.toList());
                    lostFocusSlots.forEach(EditableSlot::lostFocus);
                    Frame focusedFrame = parent.getParentFrame();
                    HashSet<Frame> frameAndAncestors = new HashSet<Frame>();
                    Frame f = focusedFrame;
                    while (f != null) {
                        frameAndAncestors.add(f);
                        f = f.getParentCanvas() == null ? null : f.getParentCanvas().getParent().getFrame();
                    }
                    for (Frame f2 : Utility.iterableStream((Stream)this.topLevelFrame.getAllFrames())) {
                        if (frameAndAncestors.contains(f2)) continue;
                        f2.markNonFresh();
                    }
                }
            } else if (parent.equals(this.focusedItem.get())) {
                this.focusedItem.set(null);
            }
        });
        FXRunnable checkPositionChange = new FXRunnable(){
            Bounds lastBounds;
            {
                this.lastBounds = FrameEditorTab.this.boundsInScrollContent(node);
            }

            public void run() {
                if (node.isFocused()) {
                    Bounds boundsInScroll = FrameEditorTab.this.boundsInScrollContent(node);
                    if (Math.abs(boundsInScroll.getMinY() - this.lastBounds.getMinY()) >= 1.0 || Math.abs(boundsInScroll.getMaxY() - this.lastBounds.getMaxY()) >= 1.0) {
                        this.lastBounds = boundsInScroll;
                        if (!FrameEditorTab.this.anyButtonsPressed) {
                            FrameEditorTab.this.ensureNodeVisible(node);
                        }
                    } else {
                        this.lastBounds = boundsInScroll;
                    }
                }
            }
        };
        node.localToSceneTransformProperty().addListener((a, b, c) -> {
            if (node.isFocused()) {
                FXRunnable.runLater((FXRunnable)checkPositionChange);
            }
        });
        node.boundsInLocalProperty().addListener((a, b, c) -> {
            if (node.isFocused()) {
                FXRunnable.runLater((FXRunnable)checkPositionChange);
            }
        });
    }

    private void ensureNodeVisible(Node node) {
        Bounds boundsInScroll = this.boundsInScroll(node);
        if (boundsInScroll == null) {
            return;
        }
        if (boundsInScroll.getHeight() < 1.0) {
            JavaFXUtil.addSelfRemovingListener((ObservableValue)node.boundsInLocalProperty(), x -> this.ensureNodeVisible(node));
            return;
        }
        double MIN = 75.0;
        Duration SCROLL_TIME = Duration.millis((double)150.0);
        if (boundsInScroll.getMaxY() < 75.0) {
            this.scrollTo(node, -75.0, SCROLL_TIME);
        } else if (boundsInScroll.getMinY() > this.scroll.heightProperty().get() - 75.0) {
            this.scrollTo(node, -(this.scroll.heightProperty().get() - 75.0), SCROLL_TIME);
        }
    }

    private Bounds boundsInScroll(Node node) {
        Bounds local = node.getBoundsInLocal();
        Bounds scene = node.localToScene(local);
        if (local.getMinY() != scene.getMinY() && local.getMaxY() != scene.getMaxY()) {
            return this.scroll.sceneToLocal(scene);
        }
        return null;
    }

    private Bounds boundsInScrollContent(Node node) {
        return this.scrollContent.sceneToLocal(node.localToScene(node.getBoundsInLocal()));
    }

    public KeyCode getKey(InteractionManager.ShortcutKey keyPurpose) {
        switch (keyPurpose) {
            case YES_ANYWHERE: {
                return KeyCode.F2;
            }
            case NO_ANYWHERE: {
                return KeyCode.F3;
            }
        }
        return null;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean isEditable() {
        return this.viewProperty.get() != Frame.View.JAVA_PREVIEW;
    }

    public void setupSuggestionWindow(Stage window) {
        JavaFXUtil.addChangeListener((ObservableValue)window.focusedProperty(), focused -> this.getParent().scheduleUpdateCatalogue(this, null, focused != false ? FXTabbedEditor.CodeCompletionState.SHOWING : FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList()));
    }

    public Pane getDragTargetCursorPane() {
        return this.getParent().getDragCursorPane();
    }

    public void compiled() {
        if (this.topLevelFrame != null) {
            this.topLevelFrame.getAllFrames().forEach(Frame::compiled);
        }
        this.updateDisplays();
    }

    public void ensureImportsVisible() {
        if (this.topLevelFrame != null) {
            this.topLevelFrame.ensureImportCanvasShowing();
        }
    }

    void ignoreEdits(FXRunnable during) {
        this.loading = true;
        during.run();
        this.loading = false;
    }

    public void updateCatalog(FrameCursor f) {
        this.getParent().scheduleUpdateCatalogue(this, f, FXTabbedEditor.CodeCompletionState.NOT_POSSIBLE, !this.selection.getSelected().isEmpty(), this.getView(), Collections.emptyList());
    }

    @Override
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    public WindowOverlayPane getWindowOverlayPane() {
        return this.windowOverlayPane;
    }

    public CodeOverlayPane getCodeOverlayPane() {
        return this.codeOverlayPane;
    }

    public Observable getObservableScroll() {
        return this.observableScroll;
    }

    public DoubleExpression getObservableViewportHeight() {
        return this.viewportHeight;
    }

    Frame.View getView() {
        return (Frame.View)this.viewProperty.get();
    }

    public ReadOnlyObjectProperty<Frame.View> viewProperty() {
        return this.viewProperty;
    }

    public FrameCursor getFocusedCursor() {
        if (this.focusedItem.get() == null) {
            return null;
        }
        return ((CursorOrSlot)this.focusedItem.get()).getCursor();
    }

    public Observable focusedItemObservable() {
        return this.focusedItem;
    }

    public void updateErrorOverviewBar() {
        JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> this.updateErrorOverviewBar(false));
    }

    public Paint getHighlightColor() {
        return (Paint)this.contentRoot.cssHighlightColorProperty().get();
    }

    public void focusMethod(String methodName) {
        if (this.topLevelFrame != null) {
            for (NormalMethodFrame normalMethodFrame : this.topLevelFrame.getMethods()) {
                if (!normalMethodFrame.getName().equals(methodName)) continue;
                normalMethodFrame.focusName();
            }
        } else {
            Debug.message((String)"focusMethod @ FrameEditorTab: class frame is null!");
        }
    }

    @Override
    public void setParent(FXTabbedEditor parent) {
        this.parent.set((Object)parent);
    }

    @Override
    FXTabbedEditor getParent() {
        return (FXTabbedEditor)this.parent.get();
    }

    public ObservableValue<FXTabbedEditor> windowProperty() {
        return this.parent;
    }

    Project getProject() {
        return this.project;
    }

    @Override
    public ObservableStringValue windowTitleProperty() {
        return this.nameProperty();
    }

    @Override
    String getWebAddress() {
        return null;
    }

    private class ContentBorderPane
    extends BorderPane {
        private final CssMetaData<ContentBorderPane, Color> COLOR_META_DATA = JavaFXUtil.cssColor((String)"-bj-highlight-color", ContentBorderPane::cssHighlightColorProperty);
        private final SimpleStyleableObjectProperty<Color> cssHighlightColorProperty = new SimpleStyleableObjectProperty(this.COLOR_META_DATA);
        private final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss((List)BorderPane.getClassCssMetaData()).add(this.COLOR_META_DATA).build();

        private ContentBorderPane() {
        }

        public final SimpleStyleableObjectProperty<Color> cssHighlightColorProperty() {
            return this.cssHighlightColorProperty;
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return this.cssMetaDataList;
        }
    }

    private static class WeakFontSizeUpdater
    implements ChangeListener<Number> {
        private final WeakReference<FrameEditorTab> editorRef;

        public WeakFontSizeUpdater(FrameEditorTab ed) {
            this.editorRef = new WeakReference<FrameEditorTab>(ed);
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            FrameEditorTab ed = (FrameEditorTab)((Object)this.editorRef.get());
            if (ed == null) {
                observable.removeListener((ChangeListener)this);
            } else {
                ed.updateFontSize();
            }
        }
    }
}

