/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.FrameSelection;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.GreenfootFrameCategory;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.binding.ConcatListBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import nu.xom.Element;

public class FrameCatalogue
extends VBox {
    private final List<Updater> catalogueUpdate = new ArrayList<Updater>();
    private final ObservableList<Node> extensionItems = FXCollections.observableArrayList();
    private final ObservableList<Node> hintItems = FXCollections.observableArrayList();
    private FXRunnable cancelUpdateCatalogue;
    private FrameCursor currentCursor;
    private boolean filled = false;
    private static final double CATALOGUE_FRAME_WIDTH = 200.0;
    private final Node exampleHeader = this.makeSectionHeader(Config.getString((String)"frame.catalogue.examples"));

    FrameCatalogue() {
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"catalogue"});
        this.setFocusTraversable(false);
    }

    private void fillCatalogue(FrameEditorTab editor) {
        if (this.filled || editor == null) {
            return;
        }
        this.filled = true;
        ObservableList standardItems = FXCollections.observableArrayList();
        Node shortcutHeader = this.makeSectionHeader(Config.getString((String)"frame.catalogue.shortcuts"));
        standardItems.add((Object)shortcutHeader);
        this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
            shortcutHeader.setVisible(c == null);
            shortcutHeader.setManaged(c == null);
        });
        Node commandHeader = this.makeSectionHeader(Config.getString((String)"frame.catalogue.commands"));
        standardItems.add((Object)commandHeader);
        this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
            commandHeader.setVisible(c != null && !hasSelection);
            commandHeader.setManaged(c != null && !hasSelection);
        });
        editor.ignoreEdits(() -> {
            FrameDictionary<GreenfootFrameCategory> dictionary = editor.getDictionary();
            BorderPane p = new BorderPane();
            p.setMinWidth(200.0);
            p.setPrefWidth(200.0);
            p.setMaxWidth(200.0);
            Scene temp = new Scene((Parent)p);
            Config.addEditorStylesheets((Scene)temp);
            Comparator<FrameDictionary.Entry> comparator = Comparator.comparing(FrameDictionary.Entry::getCategory).thenComparing(e -> this.getDisplayShortcut(e.getShortcuts()));
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.TRANSPARENT);
            for (FrameDictionary.Entry e2 : Utility.iterableStream(dictionary.getAllBlocks().stream().sorted(comparator))) {
                Frame f = e2.getFactory().createBlock((InteractionManager)editor);
                p.setCenter(f.getNode());
                WritableImage image = p.snapshot(params, null);
                AnchorPane item = new AnchorPane();
                JavaFXUtil.addStyleClass((Styleable)item, (String[])new String[]{"catalogue-item"});
                JavaFXUtil.setPseudoclass((String)"bj-catalogue-clickable", (boolean)true, (Node[])new Node[]{item});
                item.setMinWidth(200.0);
                item.setMaxWidth(200.0);
                item.setMinHeight(30.0);
                JavaFXUtil.initializeCustomTooltipCatalogue((FXTabbedEditor)editor.getParent(), (Node)item, (String)("Click, or press '" + this.keyTooltipName(e2.getShortcuts()) + "' to insert " + e2.getName().toLowerCase() + " frame"), (Duration)Duration.millis((double)1500.0));
                ImageView imageView = new ImageView((Image)image);
                imageView.setPreserveRatio(true);
                Node header = f.getHeaderItems().findFirst().flatMap(h -> h.getComponents().stream().findFirst()).orElse(null);
                if (header != null) {
                    double headerY = header.localToScene(header.getBoundsInLocal()).getMinY();
                    imageView.setViewport(new Rectangle2D(0.0, headerY, 75.0, 18.0));
                } else {
                    imageView.setViewport(new Rectangle2D(0.0, 0.0, 75.0, 18.0));
                }
                imageView.setEffect((Effect)new ColorAdjust(0.0, 0.0, 0.2, 0.0));
                AnchorPane.setBottomAnchor((Node)imageView, (Double)0.0);
                AnchorPane.setRightAnchor((Node)imageView, (Double)0.0);
                item.getChildren().add((Object)imageView);
                HBox keyAndName = this.getKeyAndName(this.getDisplayShortcut(e2.getShortcuts()), e2.getName(), true);
                item.getChildren().addAll((Object[])new Node[]{keyAndName});
                this.setupClick((Node)item, (FrameFactory<? extends Frame>)e2.getFactory());
                f.cleanup();
                item.setVisible(false);
                item.setManaged(false);
                standardItems.add((Object)item);
                this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
                    boolean show = c != null && c.canInsert() && c.check().canInsert((GreenfootFrameCategory)e2.getCategory()) && (!hasSelection || e2.validOnSelection());
                    item.setVisible(show);
                    item.setManaged(show);
                    if (hasSelection && show) {
                        commandHeader.setVisible(true);
                        commandHeader.setManaged(true);
                    }
                });
            }
            Label ctrl = new Label("Ctrl");
            JavaFXUtil.addStyleClass((Styleable)ctrl, (String[])new String[]{"catalogue-key"});
            Label space = new Label("Space");
            JavaFXUtil.addStyleClass((Styleable)space, (String[])new String[]{"catalogue-key"});
            JavaFXUtil.setPseudoclass((String)"bj-wide", (boolean)true, (Node[])new Node[]{ctrl, space});
            Label plus = new Label("+");
            ctrl.setTextOverrun(OverrunStyle.CLIP);
            space.setTextOverrun(OverrunStyle.CLIP);
            plus.setTextOverrun(OverrunStyle.CLIP);
            Label name = new Label(Config.getString((String)"frame.catalogue.codecompletion"));
            name.setWrapText(true);
            name.styleProperty().set((Object)"-fx-label-padding: 0 0 0 3");
            HBox hbox = new HBox(new Node[]{ctrl, plus, space, name});
            hbox.setSpacing(1.0);
            hbox.setFillHeight(false);
            hbox.setAlignment(Pos.CENTER_LEFT);
            standardItems.add((Object)hbox);
            this.catalogueUpdate.add((c, codeCompletion, selection, birdseye) -> {
                hbox.setVisible(codeCompletion == FXTabbedEditor.CodeCompletionState.POSSIBLE);
                hbox.setManaged(codeCompletion == FXTabbedEditor.CodeCompletionState.POSSIBLE);
            });
            hbox.setVisible(false);
            hbox.setManaged(false);
            FXBiConsumer addCodeCompletionShortcut = (shortcut, actionName) -> {
                Node content = this.makeTextItem((String)shortcut, (String)actionName, false);
                standardItems.add((Object)content);
                this.catalogueUpdate.add((c, codeCompletion, selection, birdseye) -> {
                    content.setVisible(codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING);
                    content.setManaged(codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING);
                });
            };
            addCodeCompletionShortcut.accept((Object)"Esc", (Object)Config.getString((String)"frame.catalogue.codecompletion.hide"));
            addCodeCompletionShortcut.accept((Object)"\u2191", (Object)Config.getString((String)"frame.catalogue.codecompletion.up"));
            addCodeCompletionShortcut.accept((Object)"\u2193", (Object)Config.getString((String)"frame.catalogue.codecompletion.down"));
            addCodeCompletionShortcut.accept((Object)"\u21b5", (Object)Config.getString((String)"frame.catalogue.codecompletion.select"));
            FXBiConsumer addBirdseyeShortcut = (shortcut, actionName) -> {
                Node content = this.makeTextItem((String)shortcut, (String)actionName, false);
                standardItems.add((Object)content);
                this.catalogueUpdate.add((c, codeCompletion, selection, view) -> {
                    content.setVisible(view == Frame.View.BIRDSEYE);
                    content.setManaged(view == Frame.View.BIRDSEYE);
                });
            };
            addBirdseyeShortcut.accept((Object)"Esc", (Object)Config.getString((String)"frame.catalogue.birdseye.exit"));
            addBirdseyeShortcut.accept((Object)"\u2191", (Object)Config.getString((String)"frame.catalogue.birdseye.up"));
            addBirdseyeShortcut.accept((Object)"\u2193", (Object)Config.getString((String)"frame.catalogue.birdseye.down"));
            addBirdseyeShortcut.accept((Object)"\u21b5", (Object)Config.getString((String)"frame.catalogue.birdseye.select"));
            Node content = this.makeTextItem("Esc", Config.getString((String)"frame.catalogue.birdseye.exit"), false);
            standardItems.add((Object)content);
            this.catalogueUpdate.add((c, codeCompletion, selection, view) -> {
                content.setVisible(view == Frame.View.JAVA_PREVIEW);
                content.setManaged(view == Frame.View.JAVA_PREVIEW);
            });
        });
        ConcatListBinding.bind((ObservableList)this.getChildren(), (ObservableList)FXCollections.observableArrayList((Object[])new ObservableList[]{standardItems, this.extensionItems, this.hintItems}));
    }

    private HBox getKeyAndName(String shortcut, String title, boolean showingPreview) {
        Label keyLabel = new Label(shortcut);
        keyLabel.setMouseTransparent(true);
        JavaFXUtil.addStyleClass((Styleable)keyLabel, (String[])new String[]{"catalogue-key"});
        Label name = new Label(title);
        name.setWrapText(true);
        name.setMaxWidth(showingPreview ? 100.0 : 160.0);
        name.setMouseTransparent(true);
        HBox keyAndName = new HBox(new Node[]{keyLabel, name});
        keyAndName.setSpacing(5.0);
        AnchorPane.setLeftAnchor((Node)keyAndName, (Double)0.0);
        AnchorPane.setTopAnchor((Node)keyAndName, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)keyAndName, (Double)0.0);
        keyAndName.setFillHeight(false);
        keyAndName.setAlignment(Pos.CENTER_LEFT);
        return keyAndName;
    }

    private void setupClick(Node item, FrameFactory<? extends Frame> factory) {
        item.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.currentCursor != null) {
                FrameSelection selection = this.currentCursor.getEditor().getSelection();
                if (selection.getSelected().isEmpty()) {
                    Frame f2 = factory.createBlock(this.currentCursor.getEditor());
                    this.currentCursor.insertBlockAfter(f2);
                    f2.focusWhenJustAdded();
                } else {
                    List<Frame> selected = selection.getSelected();
                    List selectedCopy = Utility.mapList(selected, f -> Loader.loadElement((Element)((CodeFrame)f).getCode().toXML()).createFrame(this.currentCursor.getEditor()));
                    Frame newFrame = factory.createBlock(this.currentCursor.getEditor(), selectedCopy);
                    this.currentCursor.insertBlockBefore(newFrame);
                    selected.forEach(f -> f.getParentCanvas().removeBlock(f));
                    selection.clear();
                    newFrame.focusWhenJustAdded();
                }
            }
            e.consume();
        });
    }

    private void setupClick(Node item, FrameCursor c, FXRunnable action) {
        item.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.currentCursor == c) {
                action.run();
            }
            e.consume();
        });
    }

    private String getDisplayShortcut(String shortcut) {
        if (shortcut.equals("\n")) {
            return "\u21b5";
        }
        if (shortcut.equals("\b")) {
            return "\u21a4";
        }
        if (shortcut.equals(" ")) {
            return "\u02fd";
        }
        return shortcut;
    }

    private String keyTooltipName(String shortcut) {
        switch (shortcut) {
            case " ": {
                return "space";
            }
            case "\n": {
                return "return";
            }
            case "\b": {
                return "backspace";
            }
        }
        return shortcut;
    }

    void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, FXTabbedEditor.CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<Hint> hints) {
        this.currentCursor = c;
        if (this.cancelUpdateCatalogue != null) {
            this.cancelUpdateCatalogue.run();
        }
        this.cancelUpdateCatalogue = JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> {
            if (this.getScene().getWindow().isFocused() || codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING) {
                this.fillCatalogue(editor);
                this.catalogueUpdate.forEach(updater -> updater.update(c, codeCompletion, selection, viewMode));
                this.updateExtensions(selection ? null : c);
                this.replaceHints(hints);
            }
        });
    }

    private void updateExtensions(FrameCursor c) {
        this.extensionItems.clear();
        if (c != null) {
            Node item;
            Frame frameBefore = c.getFrameBefore();
            Frame frameAfter = c.getFrameAfter();
            HashSet<Character> keysAlreadyUsed = new HashSet<Character>();
            CanvasParent parent = c.getParentCanvas().getParent();
            if (parent != null && c.canInsert()) {
                for (ExtensionDescription ext : parent.getAvailableInnerExtensions(c.getParentCanvas(), c)) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || frameBefore != null && !ext.worksThroughout() || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(this.getDisplayShortcut("" + ext.getShortcutKey()), ext.getDescription(), true);
                    this.setupClick(item, c, () -> ((ExtensionDescription)ext).activate());
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
            if (frameAfter != null && frameAfter.isFrameEnabled()) {
                for (ExtensionDescription ext : frameAfter.getAvailablePrefixes()) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(this.getDisplayShortcut("" + ext.getShortcutKey()), ext.getDescription(), true);
                    this.setupClick(item, c, () -> ((ExtensionDescription)ext).activate());
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
            if (frameBefore != null && frameBefore.isFrameEnabled()) {
                for (ExtensionDescription ext : frameBefore.getAvailableExtensions()) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(this.getDisplayShortcut("" + ext.getShortcutKey()), ext.getDescription(), true);
                    this.setupClick(item, c, () -> ((ExtensionDescription)ext).activate());
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
        }
    }

    private Node makeTextItem(String shortcut, String description, boolean clickable) {
        AnchorPane item = new AnchorPane();
        JavaFXUtil.addStyleClass((Styleable)item, (String[])new String[]{"catalogue-item"});
        JavaFXUtil.setPseudoclass((String)"bj-catalogue-clickable", (boolean)clickable, (Node[])new Node[]{item});
        item.setMaxWidth(200.0);
        item.setMinHeight(30.0);
        item.getChildren().add((Object)this.getKeyAndName(shortcut, description, false));
        return item;
    }

    private Node makeHint(Hint h) {
        VBox item = new VBox();
        Label example = new Label(h.exampleCode);
        Label explanation = new Label(h.explanation);
        example.setWrapText(true);
        explanation.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)example, (String[])new String[]{"catalogue-example-code"});
        JavaFXUtil.addStyleClass((Styleable)explanation, (String[])new String[]{"catalogue-example-description"});
        VBox.setMargin((Node)explanation, (Insets)new Insets(3.0, 0.0, 0.0, 20.0));
        item.getChildren().addAll((Object[])new Node[]{example, explanation});
        item.setMaxWidth(200.0);
        item.setMinHeight(30.0);
        JavaFXUtil.addStyleClass((Styleable)example, (String[])new String[]{"catalogue-example"});
        return item;
    }

    private void replaceHints(List<Hint> hints) {
        this.hintItems.setAll((Collection)Utility.mapList(hints, h -> this.makeHint((Hint)h)));
        if (!this.hintItems.isEmpty()) {
            this.hintItems.add(0, (Object)this.exampleHeader);
        }
    }

    private Node makeSectionHeader(String title) {
        Label l = new Label(title);
        JavaFXUtil.addStyleClass((Styleable)l, (String[])new String[]{"catalogue-header"});
        VBox pane = new VBox(new Node[]{l});
        JavaFXUtil.addStyleClass((Styleable)pane, (String[])new String[]{"catalogue-item"});
        JavaFXUtil.setPseudoclass((String)"bj-catalogue-header", (boolean)true, (Node[])new Node[]{pane});
        pane.setMinWidth(200.0);
        return pane;
    }

    public static class Hint {
        public final String exampleCode;
        public final String explanation;

        public Hint(String exampleCode, String explanation) {
            this.exampleCode = exampleCode;
            this.explanation = explanation;
        }
    }

    private static interface Updater {
        public void update(FrameCursor var1, FXTabbedEditor.CodeCompletionState var2, boolean var3, Frame.View var4);
    }
}

