/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.WebTab;
import bluej.editor.stride.WindowOverlayPane;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.TabbedEditorWindow;
import bluej.prefmgr.PrefMgr;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FXTabbedEditor
implements TabbedEditorWindow {
    private final SimpleBooleanProperty showingCatalogue = new SimpleBooleanProperty(true);
    private final Project project;
    private final ArrayList<Frame> dragSourceFrames = new ArrayList();
    private final SimpleDoubleProperty mouseDragXProperty = new SimpleDoubleProperty();
    private final SimpleDoubleProperty mouseDragYProperty = new SimpleDoubleProperty();
    private final Rectangle startSize;
    private Stage stage;
    private Scene scene;
    private TabPane tabPane;
    private Pane dragPane;
    private Pane dragCursorPane;
    private WindowOverlayPane overlayPane;
    private FrameCatalogue cataloguePane;
    private MenuBar menuBar;
    private Tab hoverTab;
    private ScheduledFuture<?> hoverTabTask;
    private ImageView dragIcon = null;
    private String projectTitle;
    private AtomicInteger locationX = new AtomicInteger(0);
    private AtomicInteger locationY = new AtomicInteger(0);
    private AtomicInteger locationWidth = new AtomicInteger(700);
    private AtomicInteger locationHeight = new AtomicInteger(700);

    @OnThread(value=Tag.Any)
    public FXTabbedEditor(Project project, Rectangle startSize) {
        this.project = project;
        this.startSize = startSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Swing)
    public void initialise() {
        if (Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Unexpected call of initialise from FX thread");
        }
        Object o = new Object();
        this.projectTitle = this.project.getProjectName();
        Object object = o;
        synchronized (object) {
            Platform.runLater(() -> {
                this.stage = new Stage();
                this.stage.getIcons().add((Object)BlueJTheme.getApplicationFxIcon((String)"greenfoot", (boolean)true));
                this.initialiseFX();
                Object object = o;
                synchronized (object) {
                    o.notify();
                }
            });
            try {
                o.wait();
            }
            catch (InterruptedException e) {
                Debug.reportError((Throwable)e);
            }
        }
    }

    private void initialiseFX() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Main.getStoredContextClassLoader());
        }
        Config.loadFXFonts();
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.menuBar = new MenuBar();
        JavaFXUtil.addStyleClass((Styleable)this.menuBar, (String[])new String[]{"editor-menubar"});
        this.menuBar.setUseSystemMenuBar(true);
        this.dragPane = new Pane();
        this.dragPane.setMouseTransparent(true);
        this.dragCursorPane = new Pane();
        this.dragCursorPane.setMouseTransparent(true);
        this.cataloguePane = new FrameCatalogue();
        BorderPane menuAndTabPane = new BorderPane();
        menuAndTabPane.setTop((Node)this.menuBar);
        this.overlayPane = new WindowOverlayPane();
        menuAndTabPane.setCenter((Node)new StackPane(new Node[]{this.tabPane, this.dragPane, this.dragCursorPane}));
        ScrollPane catalogueScrollPane = new ScrollPane((Node)this.cataloguePane){

            public void requestFocus() {
            }
        };
        catalogueScrollPane.setMaxWidth(200.0);
        catalogueScrollPane.setMinWidth(0.0);
        catalogueScrollPane.setFitToWidth(true);
        catalogueScrollPane.setFocusTraversable(false);
        catalogueScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        catalogueScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        JavaFXUtil.addStyleClass((Styleable)catalogueScrollPane, (String[])new String[]{"catalogue-scroll"});
        BorderPane catalogueBackground = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)catalogueBackground, (String[])new String[]{"catalogue-background"});
        Label title = new Label(Config.getString((String)"frame.catalogue.title"));
        BorderPane.setAlignment((Node)title, (Pos)Pos.BOTTOM_RIGHT);
        catalogueBackground.setBottom((Node)title);
        StackPane catalogueScrollPaneStacked = new StackPane(new Node[]{catalogueBackground, catalogueScrollPane});
        BorderPane collapsibleCatalogueScrollPane = new BorderPane();
        collapsibleCatalogueScrollPane.setCenter((Node)catalogueScrollPaneStacked);
        catalogueScrollPaneStacked.setMinWidth(0.0);
        CollapseControl collapseControl = new CollapseControl((Region)catalogueScrollPaneStacked, (FXConsumer<Boolean>)((FXConsumer)showing -> catalogueScrollPane.setVbarPolicy(showing != false ? ScrollPane.ScrollBarPolicy.AS_NEEDED : ScrollPane.ScrollBarPolicy.NEVER)));
        JavaFXUtil.addChangeListener((ObservableValue)this.showingCatalogue, expanded -> PrefMgr.setFlag((String)"bluej.editor.stride.sidebarShowing", (boolean)expanded));
        Platform.runLater(() -> this.showingCatalogue.set(PrefMgr.getFlag((String)"bluej.editor.stride.sidebarShowing")));
        collapsibleCatalogueScrollPane.setLeft((Node)collapseControl);
        JavaFXUtil.addStyleClass((Styleable)collapsibleCatalogueScrollPane, (String[])new String[]{"catalogue-scroll-collapsible"});
        menuAndTabPane.setRight((Node)collapsibleCatalogueScrollPane);
        this.scene = new Scene((Parent)new StackPane(new Node[]{menuAndTabPane, this.overlayPane.getNode()}), 800.0, 700.0);
        this.stage.setScene(this.scene);
        Config.addEditorStylesheets((Scene)this.scene);
        this.tabPane.getStyleClass().add((Object)"tabbed-editor");
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((a, b, selTab) -> {
            if (selTab != null) {
                this.updateMenusForTab((FXTab)((Object)selTab));
            }
            if (this.isWindowVisible() && !(selTab instanceof FrameEditorTab)) {
                this.scheduleUpdateCatalogue(null, null, CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList());
            }
        });
        this.tabPane.getTabs().addListener(e -> {
            if (this.tabPane.getTabs().isEmpty()) {
                this.stage.close();
                this.project.removeFXTabbedEditor(this);
            }
        });
        this.stage.setOnHidden(e -> {
            ArrayList tabs = new ArrayList(this.tabPane.getTabs());
            tabs.forEach(t -> this.close((FXTab)((Object)((Object)t))));
        });
        this.tabPane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (!e.isShortcutDown()) {
                return;
            }
            int tab = this.tabPane.getSelectionModel().getSelectedIndex();
            switch (e.getCode()) {
                case DIGIT1: {
                    tab = 0;
                    break;
                }
                case DIGIT2: {
                    tab = 1;
                    break;
                }
                case DIGIT3: {
                    tab = 2;
                    break;
                }
                case DIGIT4: {
                    tab = 3;
                    break;
                }
                case DIGIT5: {
                    tab = 4;
                    break;
                }
                case DIGIT6: {
                    tab = 5;
                    break;
                }
                case DIGIT7: {
                    tab = 6;
                    break;
                }
                case DIGIT8: {
                    tab = 7;
                    break;
                }
                case DIGIT9: {
                    tab = 8;
                    break;
                }
                case TAB: {
                    if (e.isShiftDown()) {
                        if (--tab >= 0) break;
                        tab = this.tabPane.getTabs().size() - 1;
                        break;
                    }
                    tab = (tab + 1) % this.tabPane.getTabs().size();
                    break;
                }
                default: {
                    return;
                }
            }
            if (tab < this.tabPane.getTabs().size()) {
                this.tabPane.getSelectionModel().select(this.tabPane.getTabs().get(tab));
            }
            e.consume();
        });
        Config.loadFXFonts();
        this.stage.titleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{JavaFXUtil.apply((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty(), t -> ((FXTab)((Object)t)).windowTitleProperty(), (Object)"Unknown"), " - ", this.projectTitle}));
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.xProperty(), x -> this.locationX.set(x.intValue()));
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.yProperty(), y -> this.locationY.set(y.intValue()));
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.widthProperty(), w -> this.locationWidth.set(w.intValue()));
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.heightProperty(), h -> this.locationHeight.set(h.intValue()));
    }

    private void updateMenusForTab(FXTab selTab) {
        this.menuBar.getMenus().setAll(selTab.getMenus());
    }

    public BooleanProperty catalogueShowingProperty() {
        return this.showingCatalogue;
    }

    @OnThread(value=Tag.FX)
    public void addTab(FXTab panel, boolean visible, boolean toFront) {
        panel.setParent(this);
        panel.initialiseFX();
        if (!this.tabPane.getTabs().contains((Object)panel)) {
            this.tabPane.getTabs().add((Object)panel);
            if (toFront) {
                this.setWindowVisible(visible, panel);
                this.bringToFront(panel);
                Platform.runLater(panel::focusWhenShown);
            }
        }
    }

    public void openJavaCoreDocTab(String qualifiedClassName) {
        this.openJavaCoreDocTab(qualifiedClassName, "");
    }

    public void openJavaCoreDocTab(String qualifiedClassName, String suffix) {
        String target = Utility.getDocURL((String)qualifiedClassName, (String)suffix);
        this.openWebViewTab(target);
    }

    public void openGreenfootDocTab(String qualifiedClassName) {
        this.openGreenfootDocTab(qualifiedClassName, "");
    }

    public void openGreenfootDocTab(String qualifiedClassName, String suffix) {
        try {
            String target = Utility.getGreenfootApiDocURL((String)(qualifiedClassName.replace('.', '/') + ".html"));
            this.openWebViewTab(target + suffix);
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
    }

    public void setWindowVisible(boolean visible, Tab tab) {
        if (visible) {
            if (!this.stage.isShowing()) {
                if (this.startSize != null) {
                    this.stage.setX(this.startSize.getX());
                    this.stage.setY(this.startSize.getY());
                    this.stage.setWidth(this.startSize.getWidth());
                    this.stage.setHeight(this.startSize.getHeight());
                }
                this.stage.show();
            }
            if (!this.tabPane.getTabs().contains((Object)tab)) {
                this.tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.tabPane.getTabs().remove((Object)tab);
        }
    }

    public boolean isWindowVisible() {
        return this.stage.isShowing();
    }

    public void bringToFront(Tab tab) {
        this.stage.setIconified(false);
        Utility.bringToFrontFX((Stage)this.stage);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.Any)
    public void scheduleCompilation() {
        this.project.scheduleCompilation(false);
    }

    public void close(FXTab tab) {
        this.tabPane.getTabs().remove((Object)tab);
        tab.setParent(null);
    }

    public void openWebViewTab(String url) {
        try {
            URI target = new URI(url);
            for (FXTab tab : this.getFXTabs()) {
                URI tabURI;
                if (tab.getWebAddress() == null || !(tabURI = new URI(tab.getWebAddress())).equals(target)) continue;
                this.bringToFront(tab);
                return;
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError((String)("Error in URI when opening web view tab: \"" + url + "\""));
        }
        this.addTab(new WebTab(url), true, true);
    }

    public ObservableList<Tab> tabsProperty() {
        return this.tabPane.getTabs();
    }

    public Pane getDragPane() {
        return this.dragPane;
    }

    public Pane getDragCursorPane() {
        return this.dragCursorPane;
    }

    public void frameDragBegin(List<Frame> srcFrames, double mouseSceneX, double mouseSceneY) {
        if (this.dragIcon != null || !this.dragSourceFrames.isEmpty()) {
            throw new IllegalStateException("Drag begun while drag in progress");
        }
        this.dragSourceFrames.clear();
        this.dragSourceFrames.addAll(srcFrames);
        Image img = Frame.takeShot(this.dragSourceFrames, null);
        if (this.dragSourceFrames.stream().allMatch(Frame::canDrag) && img != null) {
            ImageView icon = new ImageView(img);
            icon.setEffect((Effect)new DropShadow(7.0, 2.0, 2.0, Color.BLACK));
            for (Frame src : this.dragSourceFrames) {
                src.setDragSourceEffect(true);
            }
            double srcSceneX = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getX();
            double srcSceneY = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getY();
            icon.layoutXProperty().bind((ObservableValue)this.mouseDragXProperty.subtract(mouseSceneX - srcSceneX));
            icon.layoutYProperty().bind((ObservableValue)this.mouseDragYProperty.subtract(mouseSceneY - srcSceneY));
            this.getDragPane().getChildren().add((Object)icon);
            this.dragIcon = icon;
            this.scene.setCursor(Cursor.CLOSED_HAND);
        } else {
            this.dragSourceFrames.clear();
        }
    }

    public void draggedTo(double sceneX, double sceneY, boolean copying) {
        if (!this.dragSourceFrames.isEmpty()) {
            Point2D p = this.dragPane.sceneToLocal(sceneX, sceneY);
            this.mouseDragXProperty.set(p.getX());
            this.mouseDragYProperty.set(p.getY());
            this.checkHoverDuringDrag(sceneX, sceneY, copying);
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).draggedToTab(this.dragSourceFrames, sceneX, sceneY, copying);
            }
        }
    }

    public boolean isDragging() {
        return !this.dragSourceFrames.isEmpty();
    }

    private void checkHoverDuringDrag(double sceneX, double sceneY, boolean copying) {
        for (Tab t : this.tabPane.getTabs()) {
            Bounds b = t.getGraphic().localToScene(t.getGraphic().getBoundsInLocal());
            if (!b.contains(sceneX, sceneY) || this.hoverTab == t || !(t instanceof FrameEditorTab)) continue;
            this.hoverTab = t;
            if (this.hoverTabTask != null) {
                this.hoverTabTask.cancel(false);
            }
            this.hoverTabTask = Utility.getBackground().schedule(() -> Platform.runLater(() -> {
                ((FrameEditorTab)((Object)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem())))).draggedToAnotherTab();
                this.tabPane.getSelectionModel().select((Object)t);
                ((FrameEditorTab)t).draggedTo(sceneX, sceneY, copying);
            }), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void frameDragEnd(boolean copying) {
        if (this.hoverTabTask != null) {
            this.hoverTabTask.cancel(false);
        }
        this.hoverTab = null;
        if (!this.dragSourceFrames.isEmpty()) {
            this.getDragPane().getChildren().remove((Object)this.dragIcon);
            this.dragIcon = null;
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).dragEndTab(this.dragSourceFrames, copying);
            }
            this.dragSourceFrames.clear();
            this.scene.setCursor(Cursor.DEFAULT);
        }
    }

    public void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<FrameCatalogue.Hint> hints) {
        this.cataloguePane.scheduleUpdateCatalogue(editor, (FrameCursor)(viewMode == Frame.View.NORMAL ? c : null), codeCompletion, selection, viewMode, hints);
    }

    public WindowOverlayPane getOverlayPane() {
        return this.overlayPane;
    }

    public boolean hasOneTab() {
        return this.tabPane.getTabs().size() == 1;
    }

    public boolean containsTab(Tab tab) {
        return this.tabPane.getTabs().contains((Object)tab);
    }

    public StringExpression titleProperty() {
        return this.stage.titleProperty();
    }

    private List<FXTab> getFXTabs() {
        return Utility.mapList((Collection)this.tabPane.getTabs(), t -> (FXTab)((Object)t));
    }

    @OnThread(value=Tag.Swing)
    public void setPosition(int x, int y) {
        Platform.runLater(() -> {
            this.stage.setX((double)x);
            this.stage.setY((double)y);
        });
    }

    @OnThread(value=Tag.Swing)
    public void setSize(int width, int height) {
        Platform.runLater(() -> {
            this.stage.setWidth((double)width);
            this.stage.setHeight((double)height);
        });
    }

    @OnThread(value=Tag.FX)
    public void moveToNewLater(FXTab tab) {
        SwingUtilities.invokeLater(() -> {
            FXTabbedEditor newWindow = this.project.createNewFXTabbedEditor();
            Platform.runLater(() -> this.moveTabTo(tab, newWindow));
        });
    }

    public void moveTabTo(FXTab tab, FXTabbedEditor destination) {
        this.close(tab);
        destination.addTab(tab, true, true);
    }

    public void updateMoveMenus() {
        this.tabPane.getTabs().forEach(t -> this.updateMenusForTab((FXTab)((Object)t)));
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) int getX() {
        return this.locationX.get();
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) int getY() {
        return this.locationY.get();
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) int getWidth() {
        return this.locationWidth.get();
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) int getHeight() {
        return this.locationHeight.get();
    }

    private class CollapseControl
    extends BorderPane {
        private final Duration EXPAND_COLLAPSE_DURATION = Duration.millis((double)200.0);
        private final Scale scale;
        private FXRunnable cancelHover;

        public CollapseControl(Region collapse, final FXConsumer<Boolean> listener) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"catalogue-collapse"});
            Canvas control = new Canvas(8.0, 12.0);
            GraphicsContext gc = control.getGraphicsContext2D();
            gc.setFill((Paint)Color.DARKGRAY);
            gc.fillPolygon(new double[]{1.0, control.getWidth() - 1.0, 1.0, 1.0}, new double[]{1.0, 6.0, 11.0, 1.0}, 4);
            this.setCenter((Node)control);
            this.setFocusTraversable(false);
            this.setMinWidth(10.0);
            this.scale = new Scale(1.0, 1.0, control.getWidth() / 2.0, control.getHeight() / 2.0);
            control.getTransforms().add((Object)this.scale);
            SimpleDoubleProperty shrinkExpand = new SimpleDoubleProperty(1.0);
            collapse.maxWidthProperty().bind((ObservableValue)shrinkExpand.multiply(collapse.getMaxWidth()));
            collapse.prefWidthProperty().bind((ObservableValue)collapse.maxWidthProperty());
            this.setOnMouseClicked(e -> FXTabbedEditor.this.showingCatalogue.set(!FXTabbedEditor.this.showingCatalogue.get()));
            JavaFXUtil.addChangeListener((ObservableValue)FXTabbedEditor.this.showingCatalogue, (FXConsumer)new FXConsumer<Boolean>((DoubleProperty)shrinkExpand){
                private Timeline animation = null;
                final /* synthetic */ DoubleProperty val$shrinkExpand;
                {
                    this.val$shrinkExpand = doubleProperty;
                }

                public void accept(Boolean nowExpanded) {
                    listener.accept((Object)nowExpanded);
                    this.animate(nowExpanded);
                }

                private void animate(boolean expand) {
                    if (this.animation != null) {
                        this.animation.stop();
                        this.animation = null;
                    }
                    this.animation = new Timeline(new KeyFrame[]{new KeyFrame(CollapseControl.this.EXPAND_COLLAPSE_DURATION, new KeyValue[]{new KeyValue((WritableValue)this.val$shrinkExpand, (Object)(expand ? 1.0 : 0.0), Interpolator.EASE_OUT), new KeyValue((WritableValue)CollapseControl.this.scale.xProperty(), (Object)(expand ? 1.0 : -1.0))})});
                    this.animation.play();
                }
            });
            this.setOnMouseEntered(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                }
                this.cancelHover = JavaFXUtil.runAfter((Duration)Duration.millis((double)200.0), () -> JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)true, (Node[])new Node[]{this}));
            });
            this.setOnMouseExited(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                    this.cancelHover = null;
                }
                JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)false, (Node[])new Node[]{this});
            });
        }
    }

    public static enum CodeCompletionState {
        NOT_POSSIBLE,
        SHOWING,
        POSSIBLE;

    }
}

