/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.editor.EditorWatcher;
import bluej.editor.SwingTabbedEditor;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorParameters;
import bluej.parser.entity.EntityResolver;
import bluej.pkgmgr.JavadocResolver;
import java.awt.Toolkit;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;

public final class MoeEditorManager
extends EditorManager {
    private final Properties resources;
    private final List<MoeEditor> editors = new ArrayList<MoeEditor>(4);
    private final boolean showLineNum;
    private final boolean showToolBar;

    public MoeEditorManager() {
        this.showToolBar = true;
        this.showLineNum = false;
        this.resources = Config.moeUserProps;
    }

    @Override
    public Editor openClass(String filename, String docFilename, Charset charset, String windowTitle, Supplier<SwingTabbedEditor> swingTabbedEditor, EditorWatcher watcher, boolean compiled, EntityResolver projectResolver, JavadocResolver javadocResolver, Runnable callbackOnOpen) {
        return this.openEditor(filename, docFilename, charset, true, windowTitle, swingTabbedEditor, watcher, compiled, projectResolver, javadocResolver, callbackOnOpen);
    }

    @Override
    public Editor openText(String filename, Charset charset, String windowTitle, Supplier<SwingTabbedEditor> swingTabbedEditor) {
        return this.openEditor(filename, null, charset, false, windowTitle, swingTabbedEditor, null, false, null, null, null);
    }

    @Override
    public void refreshAll() {
        for (Editor editor : this.editors) {
            if (!editor.isOpen()) continue;
            editor.refresh();
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void discardEditor(Editor ed) {
        ed.close();
        this.editors.remove(ed);
    }

    private Editor openEditor(String filename, String docFilename, Charset charset, boolean isCode, String windowTitle, Supplier<SwingTabbedEditor> swingTabbedEditor, EditorWatcher watcher, boolean compiled, EntityResolver projectResolver, JavadocResolver javadocResolver, Runnable callbackOnOpen) {
        MoeEditorParameters mep = new MoeEditorParameters(windowTitle, watcher, this.resources, projectResolver, javadocResolver);
        mep.setCode(isCode);
        mep.setShowToolbar(this.showToolBar);
        mep.setShowLineNum(this.showLineNum);
        mep.setCallbackOnOpen(callbackOnOpen);
        MoeEditor editor = new MoeEditor(mep, swingTabbedEditor);
        this.editors.add(editor);
        if (editor.showFile(filename, charset, compiled, docFilename)) {
            return editor;
        }
        editor.doClose();
        return null;
    }
}

