/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.CodeCompleteCellRenderer;
import bluej.editor.moe.MoeEditor;
import bluej.parser.AssistContent;
import bluej.parser.SourceLocation;
import bluej.parser.lexer.LocatableToken;
import bluej.prefmgr.PrefMgr;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;

public class CodeCompletionDisplay
extends JFrame
implements ListSelectionListener,
MouseListener {
    private static final Color msgTextColor = new Color(200, 170, 100);
    private MoeEditor editor;
    private final WindowListener editorListener;
    private TreeSet<AssistContent> values = new TreeSet<AssistContent>(new TreeComparator());
    private String prefix;
    private final String suggestionType;
    private final SourceLocation prefixBegin;
    private SourceLocation prefixEnd;
    private JList methodList;
    private JEditorPane methodDescription;
    private JComponent pane;
    private TreeSet<AssistContent> jListData;
    private ThreadPoolExecutor threadpool = new ThreadPoolExecutor(1, 1, 500L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
    private CodeCompleteGlassPane myGlassPane;

    public CodeCompletionDisplay(MoeEditor ed, String suggestionType, AssistContent[] assistContents, LocatableToken location) {
        Arrays.sort(assistContents, new TreeComparator());
        this.values.addAll(Arrays.asList(assistContents));
        this.suggestionType = suggestionType;
        this.makePanel();
        this.editor = ed;
        if (location != null) {
            this.prefixBegin = new SourceLocation(location.getLine(), location.getColumn());
            this.prefixEnd = new SourceLocation(location.getEndLine(), location.getEndColumn());
            this.prefix = location.getText();
        } else {
            this.prefixEnd = this.prefixBegin = this.editor.getCaretLocation();
            this.prefix = "";
        }
        this.populatePanel();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                CodeCompletionDisplay.this.methodList.requestFocusInWindow();
                CodeCompletionDisplay.this.editor.getSourcePane().getCaret().setVisible(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        });
        this.editorListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        };
    }

    public void doClose() {
        this.dispose();
    }

    private void makePanel() {
        GridLayout gridL = new GridLayout(1, 2);
        this.pane = (JComponent)this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridL);
        JPanel methodPanel = new JPanel();
        this.methodDescription = new JEditorPane();
        CompoundBorder mdBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this.methodDescription.setBorder(mdBorder);
        this.methodDescription.setEditable(false);
        if (!Config.isRaspberryPi()) {
            this.methodDescription.setOpaque(false);
        }
        this.methodDescription.setEditorKit(new HTMLEditorKit());
        this.methodDescription.setEditable(false);
        InputMap inputMap = new InputMap(){

            @Override
            public Object get(KeyStroke keyStroke) {
                Object action = super.get(keyStroke);
                if ("caret-up".equals(action) || "caret-down".equals(action)) {
                    return null;
                }
                return action;
            }
        };
        inputMap.setParent(this.methodDescription.getInputMap(0));
        this.methodDescription.setInputMap(0, inputMap);
        if (!Config.isRaspberryPi()) {
            this.methodDescription.setBackground(new Color(0, 0, 0, 0));
        } else {
            this.methodDescription.setBackground(new Color(0, 0, 0));
        }
        this.methodDescription.setFont(this.methodDescription.getFont().deriveFont((float)PrefMgr.getEditorFontSize()));
        this.methodList = new JList(new DefaultListModel());
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(this);
        this.methodList.addMouseListener(this);
        this.methodList.requestFocusInWindow();
        this.methodList.setCellRenderer(new CodeCompleteCellRenderer(this.suggestionType));
        if (!Config.isRaspberryPi()) {
            this.methodList.setOpaque(false);
        }
        inputMap = new InputMap(){

            @Override
            public Object get(final KeyStroke keyStroke) {
                char keyChar;
                if (keyStroke.getKeyCode() == 27) {
                    return null;
                }
                if (keyStroke.getKeyChar() == '\b' && keyStroke.getKeyEventType() == 400) {
                    return new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CodeCompletionDisplay.this.prefix.length() > 0) {
                                SourceLocation back = new SourceLocation(CodeCompletionDisplay.this.prefixEnd.getLine(), CodeCompletionDisplay.this.prefixEnd.getColumn() - 1);
                                CodeCompletionDisplay.this.editor.setSelection(back, CodeCompletionDisplay.this.prefixEnd);
                                CodeCompletionDisplay.this.editor.insertText("", false);
                                CodeCompletionDisplay.this.prefix = CodeCompletionDisplay.this.prefix.substring(0, CodeCompletionDisplay.this.prefix.length() - 1);
                                CodeCompletionDisplay.this.prefixEnd = CodeCompletionDisplay.this.editor.getCaretLocation();
                                CodeCompletionDisplay.this.updatePrefix();
                            }
                        }
                    };
                }
                Object actionName = super.get(keyStroke);
                if (actionName == null && keyStroke.getKeyEventType() == 400 && ((keyChar = keyStroke.getKeyChar()) >= ' ' && keyChar < '\u007f' || keyChar > '\u009f' && keyChar < '\uffff')) {
                    return new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CodeCompletionDisplay.this.editor.insertText("" + keyStroke.getKeyChar(), false);
                            CodeCompletionDisplay.this.prefix = CodeCompletionDisplay.this.prefix + keyStroke.getKeyChar();
                            CodeCompletionDisplay.this.prefixEnd = CodeCompletionDisplay.this.editor.getCaretLocation();
                            CodeCompletionDisplay.this.updatePrefix();
                        }
                    };
                }
                return actionName;
            }
        };
        inputMap.setParent(this.methodList.getInputMap(1));
        this.methodList.setInputMap(1, inputMap);
        ActionMap actionMap = new ActionMap(){

            @Override
            public Action get(Object key) {
                if (key instanceof Action) {
                    return (Action)key;
                }
                return super.get(key);
            }
        };
        actionMap.setParent(this.methodList.getActionMap());
        this.methodList.setActionMap(actionMap);
        Font mlFont = this.methodList.getFont();
        mlFont = mlFont.deriveFont((float)PrefMgr.getEditorFontSize());
        FontMetrics metrics = this.methodList.getFontMetrics(mlFont);
        Dimension size = new Dimension(metrics.charWidth('m') * 30, metrics.getHeight() * 15);
        JScrollPane scrollPane = !Config.isRaspberryPi() ? new GradientFillScrollPane(this.methodList, new Color(250, 246, 229), new Color(233, 210, 132)) : new FillScrollPane((Component)this.methodList, new Color(250, 246, 229));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(size);
        methodPanel.add(scrollPane);
        methodPanel.setFont(mlFont);
        scrollPane = !Config.isRaspberryPi() ? new GradientFillScrollPane(this.methodDescription, new Color(250, 246, 229), new Color(240, 220, 140)) : new FillScrollPane((Component)this.methodDescription, new Color(250, 246, 229));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(size);
        mainPanel.add(methodPanel);
        mainPanel.add(scrollPane);
        this.pane.add(mainPanel);
        inputMap = new InputMap();
        inputMap.setParent(this.pane.getRootPane().getInputMap(1));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "escapeAction");
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, "completeAction");
        this.pane.getRootPane().setInputMap(1, inputMap);
        actionMap = new ActionMap(){

            @Override
            public Action get(Object key) {
                if (key instanceof Action) {
                    return (Action)key;
                }
                return super.get(key);
            }
        };
        actionMap.put("escapeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        });
        actionMap.put("completeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionDisplay.this.codeComplete();
            }
        });
        this.pane.getRootPane().setActionMap(actionMap);
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setGlassPane(this.getCodeCompleteGlassPane());
        this.pack();
    }

    private void updatePrefix() {
        this.jListData = new TreeSet<AssistContent>(new TreeComparator());
        for (AssistContent value : this.values) {
            if (!value.getName().startsWith(this.prefix)) continue;
            this.jListData.add(value);
        }
        this.methodList.setListData(this.jListData.toArray(new AssistContent[this.jListData.size()]));
        this.methodList.setSelectedIndex(0);
        this.getCodeCompleteGlassPane().setWorking(false);
        this.getCodeCompleteGlassPane().setVisible(this.jListData.isEmpty());
    }

    public void addElements(List<AssistContent> elements) {
        int currentSelection = this.methodList.getSelectedIndex();
        this.values.addAll(elements);
        ArrayList<AssistContent> filteredElements = new ArrayList<AssistContent>();
        for (AssistContent element : elements) {
            if (!element.getName().startsWith(this.prefix)) continue;
            filteredElements.add(element);
        }
        this.jListData.addAll(filteredElements);
        this.methodList.setListData(this.jListData.toArray(new AssistContent[this.jListData.size()]));
        this.methodList.setSelectedIndex(currentSelection);
    }

    private void populatePanel() {
        this.updatePrefix();
    }

    private void codeComplete() {
        AssistContent selected = (AssistContent)this.methodList.getSelectedValue();
        if (selected != null) {
            String start = selected.getName();
            List params = selected.getParams();
            if (params != null) {
                start = start + "(";
            }
            this.editor.setSelection(this.prefixBegin, this.prefixEnd);
            this.editor.insertText(start, false);
            if (params != null) {
                SourceLocation selLoc = this.editor.getCaretLocation();
                if (!params.isEmpty()) {
                    this.editor.insertText(params.stream().map(AssistContent.ParamInfo::getDummyName).collect(Collectors.joining(", ")), false);
                }
                this.editor.insertText(")", false);
                if (params.size() > 0) {
                    this.editor.setSelection(selLoc.getLine(), selLoc.getColumn(), ((AssistContent.ParamInfo)params.get(0)).getDummyName().length());
                }
            }
        }
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int count = e.getClickCount();
        if (count == 2) {
            this.codeComplete();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AssistContent selected = (AssistContent)this.methodList.getSelectedValue();
        if (selected == null) {
            this.methodDescription.setText("");
            return;
        }
        AssistContent.JavadocCallback callback = new AssistContent.JavadocCallback(){

            public void gotJavadoc(AssistContent content) {
                AssistContent selected = (AssistContent)CodeCompletionDisplay.this.methodList.getSelectedValue();
                if (content == selected) {
                    CodeCompletionDisplay.this.setHtml(content, content.getJavadoc());
                }
            }
        };
        if (selected.getJavadocAsync(callback, (Executor)this.threadpool)) {
            String jdHtml = selected.getJavadoc();
            this.setHtml(selected, jdHtml);
        } else {
            this.setWorking();
        }
    }

    private void setHtml(AssistContent selected, String jdHtml) {
        jdHtml = jdHtml != null ? JavaUtils.javadocToHtml((String)jdHtml) : "";
        String sig = Utility.escapeAngleBrackets((String)selected.getType()) + " <b>" + Utility.escapeAngleBrackets((String)selected.getName()) + "</b>";
        if (selected.getParams() != null) {
            sig = sig + Utility.escapeAngleBrackets((String)("(" + selected.getParams().stream().map(AssistContent.ParamInfo::getUnqualifiedType).collect(Collectors.joining(", ")) + ")"));
        }
        jdHtml = "<h3>" + selected.getDeclaringClass() + "</h3>" + "<blockquote><tt>" + sig + "</tt></blockquote><br>" + jdHtml;
        this.methodDescription.setText(jdHtml);
        this.methodDescription.setCaretPosition(0);
    }

    public CodeCompleteGlassPane getCodeCompleteGlassPane() {
        if (this.myGlassPane == null) {
            this.myGlassPane = new CodeCompleteGlassPane();
        }
        return this.myGlassPane;
    }

    public void setCodeCompleteGlassPaneToWorkingPane(boolean isWorking) {
        if (this.myGlassPane == null) {
            this.myGlassPane = new CodeCompleteGlassPane();
        }
        this.myGlassPane.setWorking(isWorking);
    }

    public void setMethodDescriptionText(String text) {
        this.getCodeCompleteGlassPane().setVisible(false);
        this.getCodeCompleteGlassPane().setWorking(false);
        this.methodDescription.setText(text);
        this.methodDescription.setCaretPosition(0);
        this.getCodeCompleteGlassPane().setVisible(this.jListData.isEmpty());
    }

    public void setWorking() {
        this.methodDescription.setText("");
        this.setCodeCompleteGlassPaneToWorkingPane(true);
        this.setGlassPane(this.getCodeCompleteGlassPane());
        this.getCodeCompleteGlassPane().setVisible(true);
    }

    class TreeComparator
    implements Comparator<AssistContent> {
        TreeComparator() {
        }

        @Override
        public int compare(AssistContent o1, AssistContent o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    class CodeCompleteGlassPane
    extends JComponent {
        String message = Config.getString((String)"editor.completion.noMatch");
        boolean isWorking = false;

        CodeCompleteGlassPane() {
        }

        public void setWorking(boolean isW) {
            this.isWorking = isW;
            this.message = this.isWorking ? Config.getString((String)"editor.completion.working") : Config.getString((String)"editor.completion.noMatch");
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color origColor = g.getColor();
            Font origFont = g.getFont();
            g.setColor(msgTextColor);
            g.setFont(origFont.deriveFont(20.0f));
            if (this.isWorking) {
                g.drawString(this.message, 380, 60);
            } else {
                g.drawString(this.message, 30, 60);
            }
            g.setColor(origColor);
            g.setFont(origFont);
        }
    }

    private static class GradientFillScrollPane
    extends JScrollPane {
        private Color topColor;
        private Color bottomColor;

        private GradientFillScrollPane(Component view, Color topColor, Color bottomColor) {
            super(view);
            this.getViewport().setOpaque(false);
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.topColor, 0.0f, h, this.bottomColor);
                Paint origPaint = g2d.getPaint();
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, w, h);
                g2d.setPaint(origPaint);
            }
        }
    }

    private static class FillScrollPane
    extends JScrollPane {
        private Color c;
        private Component v;

        private FillScrollPane(Component view, Color color) {
            super(view);
            this.c = color;
            this.v = view;
            view.setBackground(this.c);
            if (this.v instanceof JEditorPane) {
                JEditorPane jEditorPane = (JEditorPane)this.v;
                Color bgColor = new Color(250, 246, 229);
                Utility.setJEditorPaneBackground((JEditorPane)jEditorPane, (Color)bgColor);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D && !(this.v instanceof JEditorPane)) {
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                Paint origPaint = g2d.getPaint();
                g2d.setPaint(this.c);
                g2d.fillRect(0, 0, w, h);
                g2d.setPaint(origPaint);
            }
        }
    }
}

