/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeErrorManager;
import bluej.editor.moe.MoePlainView;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEvent;
import bluej.editor.moe.Token;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public abstract class BlueJSyntaxView
extends MoePlainView {
    private static final boolean PAINT_METHOD_INNER = false;
    private static final int LEFT_INNER_SCOPE_MARGIN = 5;
    private static final int LEFT_OUTER_SCOPE_MARGIN = 2;
    private static final int RIGHT_SCOPE_MARGIN = 4;
    private static int strength = PrefMgr.getScopeHighlightStrength();
    public static final Color GREEN_BASE = new Color(225, 248, 225);
    public static final Color BLUE_BASE = new Color(233, 233, 248);
    public static final Color YELLOW_BASE = new Color(250, 250, 180);
    public static final Color PINK_BASE = new Color(248, 233, 248);
    public static final Color GREEN_OUTER_BASE = new Color(188, 218, 188);
    public static final Color BLUE_OUTER_BASE = new Color(188, 188, 210);
    public static final Color YELLOW_OUTER_BASE = new Color(215, 215, 205);
    public static final Color PINK_OUTER_BASE = new Color(210, 177, 210);
    public static final Color GREEN_INNER_BASE = new Color(210, 230, 210);
    private static Color C1;
    private static Color C2;
    private static Color C3;
    private static Color M1;
    private static Color M2;
    private static Color S1;
    private static Color S2;
    private static Color I1;
    private static Color I2;
    private static Map<?, ?> desktopHints;
    private Segment line;
    protected Font defaultFont;
    private boolean initialised;
    private Map<ParsedNode, Integer> nodeIndents;
    private final MoeErrorManager errors;

    public BlueJSyntaxView(Element elem, int leftMargin, MoeErrorManager errors) {
        super(elem, leftMargin);
        MoeSyntaxDocument.getColors();
        BlueJSyntaxView.resetColors();
        this.initialised = false;
        this.nodeIndents = new HashMap<ParsedNode, Integer>();
        this.line = new Segment();
        this.errors = errors;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        if (desktopHints != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(desktopHints);
        }
        super.paint(g, a);
    }

    @Override
    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        if (!this.initialised) {
            this.initialise(g);
        }
        MoeSyntaxDocument document = (MoeSyntaxDocument)((Object)this.getDocument());
        Color def = MoeSyntaxDocument.getDefaultColor();
        MoePlainView.MoeTabExpander tx = new MoePlainView.MoeTabExpander(this.tabSize, x);
        try {
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            document.getText(start, end - (start + 1), this.line);
            g.setColor(def);
            this.paintTaggedLine(this.line, lineIndex, g, x, y, document, this.errors, def, lineElement, tx);
        }
        catch (BadLocationException bl) {
            throw new RuntimeException(bl);
        }
    }

    protected void paintPlainLine(int lineIndex, Graphics g, int x, int y) {
        super.drawLine(lineIndex, g, x, y);
    }

    protected void paintTaggedLine(Segment line, int lineIndex, Graphics g, int x, int y, MoeSyntaxDocument document, MoeErrorManager errors, Color def, Element lineElement, TabExpander tx) {
        this.paintSyntaxLine(line, lineIndex, x, y, g, document, def, tx);
    }

    protected final void paintSyntaxLine(Segment line, int lineIndex, int x, int y, Graphics g, MoeSyntaxDocument document, Color def, TabExpander tx) {
        byte id;
        Color[] colors = MoeSyntaxDocument.getColors();
        Token tokens = document.getTokensForLine(lineIndex);
        int offset = 0;
        while ((id = tokens.id) != 100) {
            int length = tokens.length;
            Color color = id == 0 || id >= colors.length ? def : colors[id];
            g.setColor(color);
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, g, tx, offset);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
    }

    protected final void paintScopeMarkers(Graphics g, MoeSyntaxDocument document, Shape a, int firstLine, int lastLine, boolean onlyMethods) {
        this.paintScopeMarkers(g, document, a, firstLine, lastLine, onlyMethods, false);
    }

    protected void paintScopeMarkers(Graphics g, MoeSyntaxDocument document, Shape a, int firstLine, int lastLine, boolean onlyMethods, boolean small) {
        if (strength == 0) {
            return;
        }
        Element map = document.getDefaultRootElement();
        ParsedCUNode rootNode = document.getParsedNode();
        int aboveLine = firstLine - 1;
        LinkedList<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
        int curLine = firstLine;
        try {
            ThreeLines lines = new ThreeLines();
            lines.aboveLineSeg = new Segment();
            lines.thisLineSeg = new Segment();
            lines.belowLineSeg = new Segment();
            lines.aboveLineEl = null;
            if (aboveLine >= 0) {
                lines.aboveLineEl = map.getElement(aboveLine);
                document.getText(lines.aboveLineEl.getStartOffset(), lines.aboveLineEl.getEndOffset() - lines.aboveLineEl.getStartOffset(), lines.aboveLineSeg);
            }
            lines.belowLineEl = null;
            if (firstLine + 1 < map.getElementCount()) {
                lines.belowLineEl = map.getElement(firstLine + 1);
                document.getText(lines.belowLineEl.getStartOffset(), lines.belowLineEl.getEndOffset() - lines.belowLineEl.getStartOffset(), lines.belowLineSeg);
            }
            lines.thisLineEl = map.getElement(firstLine);
            document.getText(lines.thisLineEl.getStartOffset(), lines.thisLineEl.getEndOffset() - lines.thisLineEl.getStartOffset(), lines.thisLineSeg);
            this.getScopeStackAfter((ParsedNode)rootNode, 0, lines.thisLineEl.getStartOffset(), prevScopeStack);
            while (curLine <= lastLine && !prevScopeStack.isEmpty()) {
                this.drawScopes(a, g, document, lines, prevScopeStack, small, onlyMethods, 0);
                if (++curLine > lastLine) continue;
                lines.aboveLineEl = lines.thisLineEl;
                lines.thisLineEl = lines.belowLineEl;
                lines.belowLineEl = curLine + 1 < map.getElementCount() ? map.getElement(curLine + 1) : null;
                Segment oldAbove = lines.aboveLineSeg;
                lines.aboveLineSeg = lines.thisLineSeg;
                lines.thisLineSeg = lines.belowLineSeg;
                lines.belowLineSeg = oldAbove;
                if (lines.belowLineEl == null) continue;
                document.getText(lines.belowLineEl.getStartOffset(), lines.belowLineEl.getEndOffset() - lines.belowLineEl.getStartOffset(), lines.belowLineSeg);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void drawScopes(Shape a, Graphics g, MoeSyntaxDocument document, ThreeLines lines, List<NodeTree.NodeAndPosition<ParsedNode>> prevScopeStack, boolean small, boolean onlyMethods, int nodeDepth) throws BadLocationException {
        Color[] colors;
        int rbound;
        int napEnd;
        int napPos;
        NodeTree.NodeAndPosition nap;
        Rectangle lbounds = this.modelToView(lines.thisLineEl.getStartOffset(), a, Position.Bias.Forward).getBounds();
        int ypos = lbounds.y;
        int ypos2 = ypos + lbounds.height;
        int rightMargin = small ? 0 : 20;
        int fullWidth = a.getBounds().width + a.getBounds().x;
        ListIterator<NodeTree.NodeAndPosition<ParsedNode>> li = prevScopeStack.listIterator();
        DrawInfo drawInfo = new DrawInfo();
        drawInfo.g = g;
        drawInfo.lines = lines;
        drawInfo.small = small;
        drawInfo.ypos = ypos;
        drawInfo.ypos2 = ypos2;
        while (li.hasNext()) {
            nap = li.next();
            napPos = nap.getPosition();
            napEnd = nap.getEnd();
            if (napPos >= lines.thisLineEl.getEndOffset()) {
                return;
            }
            if (!this.drawNode(drawInfo, nap, onlyMethods)) continue;
            if (this.nodeSkipsEnd(napPos, napEnd, lines.thisLineEl, lines.thisLineSeg)) {
                ++nodeDepth;
                break;
            }
            int xpos = this.getNodeIndent(a, document, nap, lines.thisLineEl, lines.thisLineSeg);
            if (xpos != -1 && xpos <= a.getBounds().x + a.getBounds().width) {
                boolean starts = this.nodeSkipsStart(nap, lines.aboveLineEl, lines.aboveLineSeg);
                boolean ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl, lines.belowLineSeg);
                rbound = this.getNodeRBound(a, (NodeTree.NodeAndPosition<ParsedNode>)nap, fullWidth - rightMargin, nodeDepth, lines.thisLineEl, lines.thisLineSeg);
                drawInfo.node = (ParsedNode)nap.getNode();
                drawInfo.starts = starts;
                drawInfo.ends = ends;
                colors = this.colorsForNode(drawInfo.node);
                drawInfo.color1 = colors[0];
                drawInfo.color2 = colors[1];
                this.drawScopeLeft(drawInfo, xpos, rbound);
                this.drawScopeRight(drawInfo, rbound);
            }
            ++nodeDepth;
        }
        --nodeDepth;
        li = prevScopeStack.listIterator(prevScopeStack.size());
        nap = li.previous();
        napPos = nap.getPosition();
        napEnd = napPos + nap.getSize();
        while (napEnd <= lines.thisLineEl.getEndOffset()) {
            li.remove();
            if (this.drawNode(drawInfo, nap, onlyMethods)) {
                --nodeDepth;
            }
            if (!li.hasPrevious()) {
                return;
            }
            NodeTree.NodeAndPosition<ParsedNode> napParent = li.previous();
            li.next();
            NodeTree.NodeAndPosition nextNap = nap.nextSibling();
            napPos = napParent.getPosition();
            napEnd = napPos + napParent.getSize();
            nap = napParent;
            while (nextNap != null) {
                li.add((NodeTree.NodeAndPosition<ParsedNode>)nextNap);
                li.previous();
                li.next();
                napPos = nextNap.getPosition();
                napEnd = napPos + nextNap.getSize();
                if (napPos < lines.thisLineEl.getEndOffset() && !this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl, lines.thisLineSeg) && this.drawNode(drawInfo, (NodeTree.NodeAndPosition<ParsedNode>)nextNap, onlyMethods)) {
                    int xpos = this.getNodeIndent(a, document, (NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.thisLineEl, lines.thisLineSeg);
                    rbound = this.getNodeRBound(a, (NodeTree.NodeAndPosition<ParsedNode>)nextNap, fullWidth - rightMargin, ++nodeDepth, lines.thisLineEl, lines.thisLineSeg);
                    drawInfo.node = (ParsedNode)nextNap.getNode();
                    colors = this.colorsForNode(drawInfo.node);
                    drawInfo.color1 = colors[0];
                    drawInfo.color2 = colors[1];
                    drawInfo.starts = this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)nextNap, lines.aboveLineEl, lines.aboveLineSeg);
                    drawInfo.ends = this.nodeSkipsEnd(napPos, napEnd, lines.belowLineEl, lines.belowLineSeg);
                    if (xpos != -1 && xpos <= a.getBounds().x + a.getBounds().width) {
                        this.drawScopeLeft(drawInfo, xpos, rbound);
                        this.drawScopeRight(drawInfo, rbound);
                    }
                }
                nap = nextNap;
                nextNap = ((ParsedNode)nextNap.getNode()).findNodeAtOrAfter(napPos, napPos);
            }
        }
    }

    private boolean drawNode(DrawInfo info, NodeTree.NodeAndPosition<ParsedNode> nap, boolean onlyMethods) {
        int napPos = nap.getPosition();
        int napEnd = napPos + nap.getSize();
        if (napPos >= info.lines.thisLineEl.getEndOffset()) {
            return false;
        }
        if (!((ParsedNode)nap.getNode()).isContainer() && !((ParsedNode)nap.getNode()).isInner()) {
            return false;
        }
        if (onlyMethods) {
            return ((ParsedNode)nap.getNode()).getNodeType() == 2;
        }
        if (this.nodeSkipsStart(nap, info.lines.thisLineEl, info.lines.thisLineSeg)) {
            return false;
        }
        return !this.nodeSkipsEnd(napPos, napEnd, info.lines.thisLineEl, info.lines.thisLineSeg);
    }

    private Color[] colorsForNode(ParsedNode node) {
        if (node.isInner()) {
            return new Color[]{C3, MoeSyntaxDocument.getBackgroundColor()};
        }
        if (node.getNodeType() == 2) {
            return new Color[]{M1, M2};
        }
        if (node.getNodeType() == 3) {
            return new Color[]{I1, I2};
        }
        if (node.getNodeType() == 4 || node.getNodeType() == 0) {
            return new Color[]{S1, S2};
        }
        return new Color[]{C1, C2};
    }

    private void drawScopeLeft(DrawInfo info, int xpos, int rbound) {
        Graphics g = info.g;
        if (!info.small) {
            xpos -= info.node.isInner() ? 5 : 2;
        }
        int hoffs = info.small ? 0 : 4;
        int edgeTop = info.ypos + (info.starts ? hoffs : 0);
        int edgeBtm = info.ypos2 - (info.ends ? hoffs : 0);
        g.setColor(info.color2);
        g.fillRect(xpos, edgeTop, hoffs, edgeBtm - edgeTop);
        g.setColor(info.color1);
        g.drawLine(xpos, edgeTop, xpos, edgeBtm);
        if (info.starts) {
            g.setColor(info.color2);
            g.fillArc(xpos, info.ypos, hoffs * 2, hoffs * 2, 180, -90);
            g.setColor(info.color1);
            g.drawArc(xpos, info.ypos, hoffs * 2, hoffs * 2, 180, -90);
        }
        if (info.ends) {
            g.setColor(info.color2);
            g.fillArc(xpos, edgeBtm - hoffs, hoffs * 2, hoffs * 2, 180, 90);
            g.setColor(info.color1);
            g.drawArc(xpos, edgeBtm - hoffs, hoffs * 2, hoffs * 2, 180, 90);
        }
        this.drawScope(info, xpos + hoffs, rbound);
    }

    private void drawScopeRight(DrawInfo info, int xpos) {
        Graphics g = info.g;
        int hoffs = info.small ? 0 : 4;
        int edgeTop = info.ypos + (info.starts ? hoffs : 0);
        int edgeBtm = info.ypos2 - (info.ends ? hoffs + 1 : 0);
        g.setColor(info.color2);
        g.fillRect(xpos, edgeTop, hoffs, edgeBtm - edgeTop);
        g.setColor(info.color1);
        g.drawLine(xpos + hoffs, edgeTop, xpos + hoffs, edgeBtm);
        if (info.starts) {
            g.setColor(info.color2);
            g.fillArc(xpos - hoffs, info.ypos, hoffs * 2, hoffs * 2, 0, 90);
            g.setColor(info.color1);
            g.drawArc(xpos - hoffs, info.ypos, hoffs * 2, hoffs * 2, 0, 90);
        }
        if (info.ends) {
            g.setColor(info.color2);
            g.fillArc(xpos - hoffs, edgeBtm - hoffs, hoffs * 2, hoffs * 2, 0, -90);
            g.setColor(info.color1);
            g.drawArc(xpos - hoffs, edgeBtm - hoffs, hoffs * 2, hoffs * 2, 0, -90);
        }
    }

    private void drawScope(DrawInfo info, int xpos, int rbounds) {
        Graphics g = info.g;
        Color color1 = info.color1;
        Color color2 = info.color2;
        boolean startsThisLine = info.starts;
        boolean endsThisLine = info.ends;
        int ypos = info.ypos;
        int ypos2 = info.ypos2;
        g.setColor(color2);
        g.fillRect(xpos, ypos, rbounds - xpos, ypos2 - ypos);
        if (startsThisLine) {
            g.setColor(color1);
            g.drawLine(xpos, ypos, rbounds, ypos);
        }
        if (endsThisLine) {
            g.setColor(color1);
            g.drawLine(xpos, ypos2 - 1, rbounds, ypos2 - 1);
        }
    }

    private int getNodeRBound(Shape a, NodeTree.NodeAndPosition<ParsedNode> nap, int fullWidth, int nodeDepth, Element lineEl, Segment lineSeg) throws BadLocationException {
        int napEnd = nap.getEnd();
        int rbound = fullWidth - nodeDepth * 4;
        if (lineEl == null || napEnd >= lineEl.getEndOffset()) {
            return rbound;
        }
        if (napEnd < lineEl.getStartOffset()) {
            return rbound;
        }
        int nwsb = this.findNonWhitespaceComment(nap, lineEl, lineSeg, napEnd - lineEl.getStartOffset());
        if (nwsb != -1) {
            Rectangle ebounds = this.modelToView(napEnd, a, Position.Bias.Backward).getBounds();
            return Math.min(rbound, ebounds.x);
        }
        return rbound;
    }

    private boolean nodeSkipsStart(NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl, Segment segment) {
        if (lineEl == null) {
            return true;
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos > lineEl.getStartOffset() && napEnd > lineEl.getEndOffset()) {
            if (napPos >= lineEl.getEndOffset()) {
                return true;
            }
            int nws = this.findNonWhitespaceComment(nap, lineEl, segment, napPos - lineEl.getStartOffset());
            if (nws == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean nodeSkipsEnd(int napPos, int napEnd, Element lineEl, Segment segment) {
        if (lineEl == null) {
            return true;
        }
        if (napEnd < lineEl.getEndOffset() && napPos < lineEl.getStartOffset()) {
            if (napEnd <= lineEl.getStartOffset()) {
                return true;
            }
            if (napEnd >= lineEl.getEndOffset()) {
                return false;
            }
            int nws = this.findNonWhitespace(segment, 0);
            if (nws == -1 || lineEl.getStartOffset() + nws >= napEnd) {
                return true;
            }
        }
        return false;
    }

    private int getNodeIndent(Shape a, MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl, Segment segment) throws BadLocationException {
        int nws;
        if (lineEl == null) {
            return Integer.MAX_VALUE;
        }
        int napPos = nap.getPosition();
        int napEnd = nap.getEnd();
        if (napPos >= lineEl.getEndOffset()) {
            return Integer.MAX_VALUE;
        }
        if (napEnd <= lineEl.getStartOffset()) {
            return Integer.MAX_VALUE;
        }
        if (this.nodeSkipsStart(nap, lineEl, segment) || this.nodeSkipsEnd(napPos, napEnd, lineEl, segment)) {
            return Integer.MAX_VALUE;
        }
        Integer indent = this.nodeIndents.get(nap.getNode());
        if (indent == null) {
            indent = this.getNodeIndent(a, doc, nap);
            this.nodeIndents.put((ParsedNode)nap.getNode(), indent);
        }
        int xpos = indent;
        if (napPos > lineEl.getStartOffset() && (nws = this.findNonWhitespaceBwards(segment, napPos - lineEl.getStartOffset() - 1, 0)) != -1) {
            Rectangle lbounds = this.modelToView(lineEl.getStartOffset() + nws + 1, a, Position.Bias.Forward).getBounds();
            xpos = Math.max(xpos, lbounds.x);
        }
        return xpos;
    }

    private int getNodeIndent(Shape a, MoeSyntaxDocument doc, NodeTree.NodeAndPosition<ParsedNode> nap) {
        try {
            int indent = Integer.MAX_VALUE;
            int curpos = nap.getPosition();
            int napEnd = nap.getEnd();
            Element map = doc.getDefaultRootElement();
            Stack<Object> scopeStack = new Stack<Object>();
            scopeStack.add(nap);
            block2: while (curpos < napEnd) {
                NodeTree.NodeAndPosition top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                while (top.getEnd() <= curpos) {
                    scopeStack.remove(scopeStack.size() - 1);
                    top = (NodeTree.NodeAndPosition)scopeStack.get(scopeStack.size() - 1);
                }
                NodeTree.NodeAndPosition nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                while (nextChild != null && nextChild.getPosition() <= curpos) {
                    if (((ParsedNode)nextChild.getNode()).isInner()) {
                        curpos = nextChild.getEnd();
                        continue block2;
                    }
                    scopeStack.add(nextChild);
                    top = nextChild;
                    nextChild = ((ParsedNode)top.getNode()).findNodeAt(curpos + 1, top.getPosition());
                }
                int line = map.getElementIndex(curpos);
                Element lineEl = map.getElement(line);
                Segment segment = new Segment();
                doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
                int lineOffset = curpos - lineEl.getStartOffset();
                int nws = lineEl.getStartOffset() < nap.getPosition() && ((ParsedNode)nap.getNode()).isInner() ? this.findNonWhitespaceComment(nap, lineEl, segment, lineOffset) : this.findNonWhitespace(segment, lineOffset);
                if (nws == lineOffset) {
                    Rectangle cbounds = this.modelToView(curpos, a, Position.Bias.Forward).getBounds();
                    indent = Math.min(indent, cbounds.x);
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                if (nws == -1) {
                    curpos = lineEl.getEndOffset();
                    continue;
                }
                curpos += nws - lineOffset;
            }
            return indent == Integer.MAX_VALUE ? -1 : indent;
        }
        catch (BadLocationException ble) {
            return -1;
        }
    }

    private int[] reassessIndentsAdd(Shape a, int dmgStart, int dmgEnd) {
        MoeSyntaxDocument doc = (MoeSyntaxDocument)((Object)this.getDocument());
        ParsedCUNode pcuNode = doc.getParsedNode();
        if (pcuNode == null) {
            return new int[]{dmgStart, dmgEnd};
        }
        Element map = doc.getDefaultRootElement();
        int ls = map.getElementIndex(dmgStart);
        int le = map.getElementIndex(dmgEnd);
        Segment segment = new Segment();
        try {
            NodeTree.NodeAndPosition top;
            int[] dmgRange = new int[]{dmgStart, dmgEnd};
            int i = ls;
            LinkedList<NodeTree.NodeAndPosition> scopeStack = new LinkedList<NodeTree.NodeAndPosition>();
            int lineEndPos = map.getElement(le).getEndOffset();
            Element lineEl = map.getElement(ls);
            for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
            }
            if (top == null) {
                return dmgRange;
            }
            if (top.getPosition() >= lineEl.getEndOffset() && (i = map.getElementIndex(top.getPosition())) > le) {
                return dmgRange;
            }
            scopeStack.add(top);
            NodeTree.NodeAndPosition nap = ((ParsedNode)top.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, top.getPosition());
            while (nap != null) {
                scopeStack.add(nap);
                nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(lineEl.getStartOffset() + 1, nap.getPosition());
            }
            block4: while (true) {
                Integer oindent;
                doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
                int nws = this.findNonWhitespace(segment, 0);
                while (nws == -1) {
                    if (++i > le) break block4;
                    lineEl = map.getElement(i);
                    doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
                    nws = this.findNonWhitespace(segment, 0);
                }
                int curpos = lineEl.getStartOffset() + nws;
                ListIterator j = scopeStack.listIterator(scopeStack.size());
                NodeTree.NodeAndPosition topNap = null;
                while ((nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= curpos) {
                    topNap = nap;
                    j.remove();
                    if (j.hasPrevious()) continue;
                }
                if (topNap != null) {
                    while ((topNap = topNap.nextSibling()) != null && topNap.getEnd() <= curpos) {
                    }
                    while (topNap != null && topNap.getPosition() < lineEndPos) {
                        scopeStack.add(topNap);
                        topNap = ((ParsedNode)topNap.getNode()).findNodeAtOrAfter(curpos + 1, topNap.getPosition());
                    }
                }
                if (scopeStack.isEmpty()) break;
                Rectangle cbounds = this.modelToView(lineEl.getStartOffset() + nws, a, Position.Bias.Forward).getBounds();
                int indent = cbounds.x;
                j = scopeStack.listIterator(scopeStack.size());
                while (j.hasPrevious()) {
                    NodeTree.NodeAndPosition next = (NodeTree.NodeAndPosition)j.previous();
                    if (next.getPosition() <= curpos) {
                        this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent, this.nodeIndents.get(next.getNode()), dmgRange);
                    } else {
                        if (next.getPosition() >= lineEl.getEndOffset()) continue;
                        nws = this.findNonWhitespace(segment, next.getPosition() - lineEl.getStartOffset());
                        oindent = this.nodeIndents.get(next.getNode());
                        if (oindent != null && nws != -1) {
                            cbounds = this.modelToView(lineEl.getStartOffset() + nws, a, Position.Bias.Forward).getBounds();
                            indent = cbounds.x;
                            this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)next, indent, oindent, dmgRange);
                        }
                    }
                    if (!((ParsedNode)next.getNode()).isInner()) continue;
                    break;
                }
                j = scopeStack.listIterator(scopeStack.size());
                while (j.hasPrevious() && (nap = (NodeTree.NodeAndPosition)j.previous()).getEnd() <= lineEl.getEndOffset()) {
                    nap = nap.nextSibling();
                    j.remove();
                    if (nap == null) continue;
                    do {
                        scopeStack.add(nap);
                        if (nap.getPosition() >= lineEl.getEndOffset()) continue;
                        int spos = nap.getPosition() - lineEl.getStartOffset();
                        nws = this.findNonWhitespace(segment, spos);
                        oindent = this.nodeIndents.get(nap.getNode());
                        if (oindent == null || nws == -1) continue;
                        cbounds = this.modelToView(lineEl.getStartOffset() + nws, a, Position.Bias.Forward).getBounds();
                        indent = cbounds.x;
                        this.updateNodeIndent((NodeTree.NodeAndPosition<ParsedNode>)nap, indent, oindent, dmgRange);
                    } while ((nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(nap.getPosition(), nap.getPosition())) != null);
                    j = scopeStack.listIterator(scopeStack.size());
                }
                if (++i > le) break;
                lineEl = map.getElement(i);
            }
            return dmgRange;
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    private int[] reassessIndentsRemove(Shape a, int dmgPoint, boolean multiLine) {
        NodeTree.NodeAndPosition top;
        MoeSyntaxDocument doc = (MoeSyntaxDocument)((Object)this.getDocument());
        ParsedCUNode pcuNode = doc.getParsedNode();
        int[] dmgRange = new int[]{dmgPoint, dmgPoint};
        if (pcuNode == null) {
            return dmgRange;
        }
        Element map = doc.getDefaultRootElement();
        int ls = map.getElementIndex(dmgPoint);
        Element lineEl = map.getElement(ls);
        for (top = pcuNode.findNodeAtOrAfter(lineEl.getStartOffset(), 0); top != null && top.getEnd() == lineEl.getStartOffset(); top = top.nextSibling()) {
        }
        if (top == null) {
            return dmgRange;
        }
        if (top.getPosition() >= lineEl.getEndOffset()) {
            return dmgRange;
        }
        try {
            Segment segment = new Segment();
            doc.getText(lineEl.getStartOffset(), lineEl.getEndOffset() - lineEl.getStartOffset(), segment);
            LinkedList<NodeTree.NodeAndPosition<ParsedNode>> rscopeStack = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
            this.getScopeStackAfter((ParsedNode)doc.getParsedNode(), 0, dmgPoint, rscopeStack);
            rscopeStack.remove(0);
            boolean doContinue = true;
            Rectangle cbounds = this.modelToView(dmgPoint, a, Position.Bias.Forward).getBounds();
            int dpI = cbounds.x;
            block3: while (doContinue && !rscopeStack.isEmpty()) {
                NodeTree.NodeAndPosition rtop = (NodeTree.NodeAndPosition)rscopeStack.remove(rscopeStack.size() - 1);
                while (rtop != null && rtop.getPosition() < lineEl.getEndOffset()) {
                    Integer cachedIndent;
                    if (rtop.getPosition() <= dmgPoint && rtop.getEnd() >= lineEl.getEndOffset()) {
                        doContinue &= !((ParsedNode)rtop.getNode()).isInner();
                    }
                    if ((cachedIndent = this.nodeIndents.get(rtop.getNode())) == null) {
                        rtop = rtop.nextSibling();
                        continue;
                    }
                    if (!multiLine && cachedIndent < dpI) {
                        rtop = rtop.nextSibling();
                        continue;
                    }
                    if (this.nodeSkipsStart((NodeTree.NodeAndPosition<ParsedNode>)rtop, lineEl, segment)) {
                        if (rtop.getPosition() > dmgPoint) continue block3;
                        this.nodeIndents.remove(rtop.getNode());
                        dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                        dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                        continue block3;
                    }
                    int nwsP = Math.max(lineEl.getStartOffset(), rtop.getPosition());
                    int nws = this.findNonWhitespace(segment, nwsP - lineEl.getStartOffset());
                    if (nws == -1 || nws + lineEl.getStartOffset() >= rtop.getEnd()) {
                        if (rtop.getPosition() <= dmgPoint) {
                            this.nodeIndents.remove(rtop.getNode());
                            dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                            dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                        }
                        rtop = rtop.nextSibling();
                        continue;
                    }
                    cbounds = this.modelToView(nws + lineEl.getStartOffset(), a, Position.Bias.Forward).getBounds();
                    int newIndent = cbounds.x;
                    if (newIndent < cachedIndent) {
                        this.nodeIndents.put((ParsedNode)rtop.getNode(), newIndent);
                        dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                        dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    } else if (newIndent > cachedIndent && rtop.getPosition() <= dmgPoint) {
                        this.nodeIndents.remove(rtop.getNode());
                        dmgRange[0] = Math.min(dmgRange[0], rtop.getPosition());
                        dmgRange[1] = Math.max(dmgRange[1], rtop.getEnd());
                    }
                    rtop = rtop.nextSibling();
                }
            }
            return dmgRange;
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    private void updateNodeIndent(NodeTree.NodeAndPosition<ParsedNode> nap, int indent, Integer oindent, int[] dmgRange) {
        int dmgStart = dmgRange[0];
        int dmgEnd = dmgRange[1];
        if (oindent != null) {
            int noindent = oindent;
            if (indent < noindent) {
                this.nodeIndents.put((ParsedNode)nap.getNode(), indent);
            } else if (indent != noindent) {
                this.nodeIndents.remove(nap.getNode());
            }
            if (indent != noindent) {
                dmgStart = Math.min(dmgStart, nap.getPosition());
                dmgEnd = Math.max(dmgEnd, nap.getEnd());
                dmgRange[0] = dmgStart;
                dmgRange[1] = dmgEnd;
            }
        }
    }

    private void getScopeStackAfter(ParsedNode root, int rootPos, int position, List<NodeTree.NodeAndPosition<ParsedNode>> list) {
        list.add((NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)root, 0, root.getSize()));
        int curpos = rootPos;
        NodeTree.NodeAndPosition nap = root.findNodeAtOrAfter(position + 1, curpos);
        while (nap != null) {
            list.add((NodeTree.NodeAndPosition<ParsedNode>)nap);
            curpos = nap.getPosition();
            nap = ((ParsedNode)nap.getNode()).findNodeAtOrAfter(position + 1, curpos);
        }
    }

    private int findNonWhitespace(Segment segment, int startPos) {
        int endpos = segment.offset + segment.count;
        for (int i = segment.offset + startPos; i < endpos; ++i) {
            char c = segment.array[i];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i - segment.offset;
        }
        return -1;
    }

    private int findNonWhitespaceComment(NodeTree.NodeAndPosition<ParsedNode> nap, Element lineEl, Segment segment, int startPos) {
        int nws = this.findNonWhitespace(segment, startPos);
        if (nws != -1) {
            NodeTree.NodeAndPosition nnap;
            NodeTree.NodeAndPosition inNap;
            int pos = nws + lineEl.getStartOffset();
            if (nap.getEnd() > pos ? (inNap = ((ParsedNode)nap.getNode()).findNodeAt(pos, nap.getPosition())) != null && ((ParsedNode)inNap.getNode()).getNodeType() == 7 && inNap.getPosition() == pos && inNap.getEnd() == lineEl.getEndOffset() - 1 : (nnap = nap.nextSibling()) != null && ((ParsedNode)nnap.getNode()).getNodeType() == 7 && nnap.getPosition() == pos && nnap.getEnd() == lineEl.getEndOffset() - 1) {
                return -1;
            }
        }
        return nws;
    }

    private int findNonWhitespaceBwards(Segment segment, int startPos, int endPos) {
        int lastP = segment.offset + endPos;
        for (int i = segment.offset + startPos; i > lastP; --i) {
            char c = segment.array[i];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i - segment.offset;
        }
        return endPos - 1;
    }

    protected final boolean hasTag(Element line, String tag) {
        return Boolean.TRUE.equals(line.getAttributes().getAttribute(tag));
    }

    protected void initialise(Graphics g) {
        this.defaultFont = g.getFont();
        if (desktopHints == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            desktopHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
        }
        if (desktopHints != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(desktopHints);
        }
        this.initialised = true;
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        DocumentEvent.ElementChange ec;
        Container host;
        int[] r;
        if (a == null) {
            this.nodeIndents.clear();
            return;
        }
        MoeSyntaxDocument document = (MoeSyntaxDocument)((Object)this.getDocument());
        int damageStart = document.getLength();
        int damageEnd = 0;
        if (changes instanceof MoeSyntaxEvent) {
            NodeTree.NodeAndPosition<ParsedNode> nap;
            MoeSyntaxEvent mse = (MoeSyntaxEvent)changes;
            for (NodeTree.NodeAndPosition<ParsedNode> node : mse.getRemovedNodes()) {
                this.nodeRemoved((ParsedNode)node.getNode());
                damageStart = Math.min(damageStart, node.getPosition());
                damageEnd = Math.max(damageEnd, node.getEnd());
                nap = node;
                r = this.clearNap(nap, document, damageStart, damageEnd);
                damageStart = r[0];
                damageEnd = r[1];
            }
            for (MoeSyntaxEvent.NodeChangeRecord record : mse.getChangedNodes()) {
                nap = record.nap;
                this.nodeIndents.remove(nap.getNode());
                damageStart = Math.min(damageStart, nap.getPosition());
                damageStart = Math.min(damageStart, record.originalPos);
                damageEnd = Math.max(damageEnd, nap.getEnd());
                damageEnd = Math.max(damageEnd, record.originalPos + record.originalSize);
                r = this.clearNap(nap, document, damageStart, damageEnd);
                damageStart = r[0];
                damageEnd = r[1];
            }
        }
        if ((host = this.getContainer()) == null) {
            return;
        }
        Element map = this.getElement();
        if (changes.getType() == DocumentEvent.EventType.INSERT) {
            damageStart = Math.min(damageStart, changes.getOffset());
            damageEnd = Math.max(damageEnd, changes.getOffset() + changes.getLength());
            int[] r2 = this.reassessIndentsAdd(a, damageStart, damageEnd);
            damageStart = r2[0];
            damageEnd = r2[1];
        } else if (changes.getType() == DocumentEvent.EventType.REMOVE) {
            damageStart = Math.min(damageStart, changes.getOffset());
            DocumentEvent.ElementChange ec2 = changes.getChange(document.getDefaultRootElement());
            boolean multiLine = ec2 != null;
            r = this.reassessIndentsRemove(a, damageStart, multiLine);
            damageStart = r[0];
            damageEnd = r[1];
        }
        if (damageStart < damageEnd) {
            int line = map.getElementIndex(damageStart);
            int lastline = map.getElementIndex(damageEnd - 1);
            this.damageLineRange(line, lastline, a, host);
        }
        Element[] added = (ec = changes.getChange(map)) != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            super.updateDamage(changes, a, f);
        } else {
            super.updateDamage(changes, a, f);
            int choffset = changes.getOffset();
            int chlength = Math.max(changes.getLength(), 1);
            int line = map.getElementIndex(choffset);
            int lastline = map.getElementIndex(choffset + chlength - 1);
            this.damageLineRange(line, lastline, a, host);
        }
    }

    private int[] clearNap(NodeTree.NodeAndPosition<ParsedNode> nap, MoeSyntaxDocument document, int damageStart, int damageEnd) {
        if (((ParsedNode)nap.getNode()).isInner()) {
            LinkedList<NodeTree.NodeAndPosition> list = new LinkedList<NodeTree.NodeAndPosition>();
            NodeTree.NodeAndPosition top = new NodeTree.NodeAndPosition((RBTreeNode)document.getParsedNode(), 0, document.getLength());
            while (top != null && top.getNode() != nap.getNode()) {
                if (((ParsedNode)top.getNode()).isInner()) {
                    list.clear();
                }
                list.add(top);
                top = ((ParsedNode)top.getNode()).findNodeAt(nap.getEnd(), top.getPosition());
            }
            for (NodeTree.NodeAndPosition cnap : list) {
                damageStart = Math.min(damageStart, cnap.getPosition());
                damageEnd = Math.max(damageEnd, cnap.getEnd());
                this.nodeIndents.remove(cnap.getNode());
            }
        }
        return new int[]{damageStart, damageEnd};
    }

    private void nodeRemoved(ParsedNode node) {
        this.nodeIndents.remove(node);
    }

    public static void setHighlightStrength(int strength) {
        BlueJSyntaxView.strength = strength;
        BlueJSyntaxView.resetColors();
    }

    private static void resetColors() {
        C1 = BlueJSyntaxView.getGreenContainerBorder();
        C2 = BlueJSyntaxView.getGreenWash();
        C3 = BlueJSyntaxView.getGreenBorder();
        M1 = BlueJSyntaxView.getYellowBorder();
        M2 = BlueJSyntaxView.getYellowWash();
        S1 = BlueJSyntaxView.getBlueBorder();
        S2 = BlueJSyntaxView.getBlueWash();
        I1 = BlueJSyntaxView.getPinkBorder();
        I2 = BlueJSyntaxView.getPinkWash();
    }

    private static Color getReducedColor(Color c) {
        return BlueJSyntaxView.getReducedColor(c.getRed(), c.getGreen(), c.getBlue(), strength);
    }

    public static Color getReducedColor(int r, int g, int b, int strength) {
        Color bg = MoeSyntaxDocument.getBackgroundColor();
        double factor = (float)strength / 20.0f;
        double other = 1.0 - factor;
        int nr = Math.min((int)((double)r * factor + (double)bg.getRed() * other), 255);
        int ng = Math.min((int)((double)g * factor + (double)bg.getGreen() * other), 255);
        int nb = Math.min((int)((double)b * factor + (double)bg.getBlue() * other), 255);
        return new Color(nr, ng, nb);
    }

    private static Color getGreenWash() {
        return BlueJSyntaxView.getReducedColor(GREEN_BASE);
    }

    private static Color getGreenContainerBorder() {
        return BlueJSyntaxView.getReducedColor(GREEN_OUTER_BASE);
    }

    private static Color getGreenBorder() {
        return BlueJSyntaxView.getReducedColor(GREEN_INNER_BASE);
    }

    private static Color getYellowBorder() {
        return BlueJSyntaxView.getReducedColor(YELLOW_OUTER_BASE);
    }

    private static Color getYellowWash() {
        return BlueJSyntaxView.getReducedColor(YELLOW_BASE);
    }

    private static Color getBlueBorder() {
        return BlueJSyntaxView.getReducedColor(BLUE_OUTER_BASE);
    }

    private static Color getBlueWash() {
        return BlueJSyntaxView.getReducedColor(BLUE_BASE);
    }

    private static Color getPinkBorder() {
        return BlueJSyntaxView.getReducedColor(PINK_OUTER_BASE);
    }

    private static Color getPinkWash() {
        return BlueJSyntaxView.getReducedColor(PINK_BASE);
    }

    static {
        desktopHints = null;
    }

    private class DrawInfo {
        Graphics g;
        ThreeLines lines;
        boolean small;
        ParsedNode node;
        int ypos;
        int ypos2;
        boolean starts;
        boolean ends;
        Color color1;
        Color color2;

        private DrawInfo() {
        }
    }

    private class ThreeLines {
        Segment aboveLineSeg;
        Segment thisLineSeg;
        Segment belowLineSeg;
        Element aboveLineEl;
        Element thisLineEl;
        Element belowLineEl;

        private ThreeLines() {
        }
    }
}

