/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.TabbedEditorWindow;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class SwingTabbedEditor
implements TabbedEditorWindow {
    private final JFrame window;
    private final JTabbedPane tabPane;
    private final Project project;
    private final IdentityHashMap<Component, MoeEditor> panelToEditor = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, Component> editorToPanel = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, HeaderPanel> editorToHeader = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, MenuInfo> menuBars = new IdentityHashMap();
    private Rectangle startSize;

    public SwingTabbedEditor(final Project project, Rectangle startSize) {
        this.window = new JFrame(project.getProjectName() + " - Java");
        this.startSize = startSize;
        this.tabPane = new JTabbedPane();
        for (int i = 1; i <= 9; ++i) {
            this.tabPane.getInputMap(1).put(KeyStroke.getKeyStroke((int)Character.forDigit(i, 10), Config.isMacOS() ? 256 : 128), "selectTab" + i);
            final int tabIndex = i - 1;
            this.tabPane.getActionMap().put("selectTab" + i, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SwingTabbedEditor.this.tabPane.getTabCount() > tabIndex) {
                        SwingTabbedEditor.this.tabPane.setSelectedIndex(tabIndex);
                    }
                }
            });
        }
        this.window.add(this.tabPane);
        this.tabPane.addChangeListener(evt -> {
            MoeEditor editor = this.panelToEditor.get(this.tabPane.getSelectedComponent());
            if (this.menuBars.containsKey(editor)) {
                this.window.setJMenuBar(this.menuBars.get((Object)editor).menuBar);
            } else {
                this.window.setJMenuBar(null);
            }
            this.updateTitle();
            for (MoeEditor ed : this.editorToPanel.keySet()) {
                ed.notifyVisibleTab(ed == editor && this.window.isFocused());
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                for (MoeEditor ed : SwingTabbedEditor.this.editorToPanel.keySet()) {
                    ed.notifyVisibleTab(false);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MoeEditor editor = (MoeEditor)SwingTabbedEditor.this.panelToEditor.get(SwingTabbedEditor.this.tabPane.getSelectedComponent());
                Iterator iterator = SwingTabbedEditor.this.editorToPanel.keySet().iterator();
                while (iterator.hasNext()) {
                    MoeEditor ed;
                    ed.notifyVisibleTab((ed = (MoeEditor)iterator.next()) == editor);
                }
            }
        };
        this.window.addWindowFocusListener(windowFocusListener);
        this.window.setDefaultCloseOperation(2);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                super.windowClosed(ev);
                ArrayList editors = new ArrayList(SwingTabbedEditor.this.editorToPanel.keySet());
                editors.forEach(e -> SwingTabbedEditor.this.setEditorVisible(false, (MoeEditor)e));
                project.removeSwingTabbedEditor(SwingTabbedEditor.this);
            }
        });
        this.project = project;
    }

    private void updateTitle() {
        MoeEditor editor = this.panelToEditor.get(this.tabPane.getSelectedComponent());
        if (editor != null) {
            this.window.setTitle(editor.getTitle() + " - " + this.project.getProjectName());
        } else {
            this.window.setTitle(this.project.getProjectName());
        }
        this.project.updateSwingTabbedEditorDestinations();
    }

    public void setEditorVisible(boolean visible, MoeEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Cannot show null editor");
        }
        if (visible) {
            Component editorTab = this.getMoeEditorTab(editor);
            if (!this.window.isShowing()) {
                this.window.pack();
                this.window.setSize(700, 700);
                if (this.startSize != null) {
                    this.window.setLocation(this.startSize.x, this.startSize.y);
                    this.window.setSize(this.startSize.width, this.startSize.height);
                }
                this.window.setVisible(true);
                EventQueue.invokeLater(() -> {
                    if (this.window.getWidth() % 2 == 0) {
                        this.window.setSize(this.window.getWidth() + 1, this.window.getHeight());
                    } else {
                        this.window.setSize(this.window.getWidth() - 1, this.window.getHeight());
                    }
                });
            }
            this.bringToFront();
            this.tabPane.setSelectedComponent(editorTab);
        } else {
            Component tab = this.editorToPanel.get(editor);
            this.tabPane.remove(tab);
            this.panelToEditor.remove(tab);
            this.editorToPanel.remove(editor);
            this.editorToHeader.remove(editor);
            editor.setParent(null);
            if (this.tabPane.getTabCount() == 0) {
                this.window.dispose();
                this.project.removeSwingTabbedEditor(this);
            }
            this.editorToHeader.values().forEach(HeaderPanel::updateMoveNew);
        }
    }

    private Component getMoeEditorTab(MoeEditor editor) {
        if (!this.editorToPanel.containsKey(editor)) {
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.add((Component)editor, "Center");
            this.panelToEditor.put(tmp, editor);
            this.editorToPanel.put(editor, tmp);
            editor.setParent(this);
            HeaderPanel header = new HeaderPanel(editor);
            this.editorToHeader.put(editor, header);
            this.tabPane.addTab(editor.getTitle(), tmp);
            this.tabPane.setTabComponentAt(this.tabPane.indexOfComponent(tmp), header);
            this.editorToHeader.values().forEach(HeaderPanel::updateMoveNew);
        }
        return this.editorToPanel.get(editor);
    }

    public void bringToFront() {
        this.window.toFront();
        Utility.bringToFront((Window)this.window);
        MoeEditor editor = this.panelToEditor.get(this.tabPane.getSelectedComponent());
        editor.getSourcePane().requestFocusInWindow();
        editor.getSourcePane().setVisible(true);
    }

    public void scheduleCompilation(boolean immediate) {
        this.project.scheduleCompilation(immediate);
    }

    public JMenuBar getJMenuBar(MoeEditor e) {
        return this.menuBars.get((Object)e).menuBar;
    }

    public void setJMenuBar(MoeEditor e, JMenuBar menuBar, JMenu moveMenu) {
        this.menuBars.put(e, new MenuInfo(menuBar, moveMenu));
    }

    public void setTitle(MoeEditor moeEditor, String title) {
        this.editorToHeader.get(moeEditor).setTitle(title);
        this.updateTitle();
    }

    public void updateMoveDestinations() {
        this.editorToHeader.values().forEach(HeaderPanel::updateMoveMenuDestinations);
    }

    private String getTitle() {
        return this.window.getTitle();
    }

    public void moveTabTo(MoeEditor editor, SwingTabbedEditor window) {
        MenuInfo menuInfo = this.menuBars.get(editor);
        window.setJMenuBar(editor, menuInfo.menuBar, menuInfo.moveMenu);
        this.setEditorVisible(false, editor);
        window.setEditorVisible(true, editor);
        window.bringToFront();
    }

    public int getX() {
        return this.window.getX();
    }

    public int getY() {
        return this.window.getY();
    }

    public int getWidth() {
        return this.window.getWidth();
    }

    public int getHeight() {
        return this.window.getHeight();
    }

    private static class MenuInfo {
        public final JMenuBar menuBar;
        public final JMenu moveMenu;

        public MenuInfo(JMenuBar menuBar, JMenu moveMenu) {
            this.menuBar = menuBar;
            this.moveMenu = moveMenu;
        }
    }

    private class CloseIcon
    implements Icon {
        private int width = 16;
        private int height = 16;

        private CloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            this.width = this.height = g2d.getFontMetrics(g2d.getFont()).getHeight();
            int offset = 5;
            g2d.setColor(Color.BLACK);
            g2d.drawLine(x + offset, y + offset, this.width - offset, this.height - offset);
            g2d.drawLine(this.width - offset, y + offset, x + offset, this.height - offset);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private class HeaderPanel
    extends JPanel {
        private final JLabel label;
        private final JMenu contextMoveMenu;
        private final JMenuItem contextMoveNew;
        private final JMenuItem mainMoveNew;
        private final MoeEditor editor;

        public HeaderPanel(final MoeEditor editor) {
            this.editor = editor;
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.label = new JLabel(editor.getTitle());
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.label.setOpaque(false);
            this.label.setInheritsPopupMenu(true);
            this.add(this.label);
            CloseIcon closeIcon = new CloseIcon();
            JButton close = new JButton(closeIcon);
            close.setBorder(null);
            close.setBorderPainted(false);
            close.setOpaque(false);
            close.setContentAreaFilled(false);
            close.addActionListener(e -> SwingTabbedEditor.this.setEditorVisible(false, editor));
            close.setInheritsPopupMenu(true);
            this.add(close);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        SwingTabbedEditor.this.setEditorVisible(false, editor);
                    } else {
                        SwingTabbedEditor.this.setEditorVisible(true, editor);
                    }
                }
            });
            close.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingTabbedEditor.this.setEditorVisible(false, editor);
                }
            });
            JPopupMenu contextMenu = new JPopupMenu();
            JMenuItem closeItem = new JMenuItem(Config.getString((String)"editor.closeLabel"));
            closeItem.addActionListener(e -> SwingTabbedEditor.this.setEditorVisible(false, editor));
            contextMenu.add(closeItem);
            this.contextMoveMenu = new JMenu(Config.getString((String)"frame.classmenu.move"));
            ((MenuInfo)((SwingTabbedEditor)SwingTabbedEditor.this).menuBars.get((Object)editor)).moveMenu.setText(Config.getString((String)"frame.classmenu.move"));
            this.contextMoveNew = new JMenuItem(Config.getString((String)"frame.classmenu.move.new"));
            this.mainMoveNew = new JMenuItem(Config.getString((String)"frame.classmenu.move.new"));
            ActionListener moveToNew = e -> {
                SwingTabbedEditor newWindow = SwingTabbedEditor.this.project.createNewSwingTabbedEditor();
                SwingTabbedEditor.this.moveTabTo(editor, newWindow);
            };
            this.contextMoveNew.addActionListener(moveToNew);
            this.mainMoveNew.addActionListener(moveToNew);
            this.updateMoveNew();
            this.updateMoveMenuDestinations();
            contextMenu.add(this.contextMoveMenu);
            this.setComponentPopupMenu(contextMenu);
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public void updateMoveNew() {
            this.contextMoveNew.setEnabled(SwingTabbedEditor.this.tabPane.getTabCount() > 1);
            this.mainMoveNew.setEnabled(SwingTabbedEditor.this.tabPane.getTabCount() > 1);
        }

        public void updateMoveMenuDestinations() {
            this.contextMoveMenu.removeAll();
            this.contextMoveMenu.add(this.contextMoveNew);
            JMenu mainMoveMenu = ((MenuInfo)((SwingTabbedEditor)SwingTabbedEditor.this).menuBars.get((Object)this.editor)).moveMenu;
            mainMoveMenu.removeAll();
            mainMoveMenu.add(this.mainMoveNew);
            this.updateMoveNew();
            List editorWindows = SwingTabbedEditor.this.project.getAllSwingTabbedEditors();
            editorWindows.stream().filter(ste -> ste != SwingTabbedEditor.this).forEach(ste -> {
                if (this.contextMoveMenu.getItemCount() == 1) {
                    this.contextMoveMenu.addSeparator();
                }
                if (mainMoveMenu.getItemCount() == 1) {
                    mainMoveMenu.addSeparator();
                }
                JMenuItem contextMoveItem = new JMenuItem(Config.getString((String)"frame.classmenu.move.existing") + ": " + ((SwingTabbedEditor)ste).getTitle());
                JMenuItem mainMoveItem = new JMenuItem(Config.getString((String)"frame.classmenu.move.existing") + ": " + ((SwingTabbedEditor)ste).getTitle());
                ActionListener moveNew = e -> SwingTabbedEditor.this.moveTabTo(this.editor, (SwingTabbedEditor)ste);
                contextMoveItem.addActionListener(moveNew);
                mainMoveItem.addActionListener(moveNew);
                this.contextMoveMenu.add(contextMoveItem);
                mainMoveMenu.add(mainMoveItem);
            });
        }
    }
}

