/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.swing.tabcontrol.TabDataModel;

public class RowPerProjectTabDisplayer
extends MultiRowTabDisplayer {
    public RowPerProjectTabDisplayer(TabDataModel tabDataModel, int n, int n2) {
        super(tabDataModel, n);
        ProjectSupport.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                final int n = ProjectSupport.getDefault().getOpenProjects().length;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RowPerProjectTabDisplayer.this.adjustRows(n);
                    }
                });
            }
        });
    }

    @Override
    void initRows() {
        int n = ProjectSupport.getDefault().getOpenProjects().length + 1;
        for (int i = 0; i < n; ++i) {
            this.addRowTable();
        }
    }

    private void adjustRows(int n) {
        int n2 = n + 1;
        while (n2 < this.rowTables.size() && this.rowTables.size() > 1) {
            this.removeTable();
        }
        while (n2 > this.rowTables.size()) {
            this.addRowTable();
        }
        this.layoutManager.invalidate();
        this.invalidate();
        this.revalidate();
        this.doLayout();
    }

    private void removeTable() {
        if (this.rowTables.size() < 2) {
            return;
        }
        SingleRowTabTable singleRowTabTable = (SingleRowTabTable)this.rowTables.get(this.rowTables.size() - 1);
        singleRowTabTable.removeMouseWheelListener(this);
        singleRowTabTable.removeMouseListener(this.controller);
        singleRowTabTable.removeMouseListener(this.closeHandler);
        singleRowTabTable.removeMouseMotionListener(this.closeHandler);
        singleRowTabTable.getSelectionModel().removeListSelectionListener(this);
        singleRowTabTable.getColumnModel().getSelectionModel().removeListSelectionListener(this);
        this.rowTables.remove(singleRowTabTable);
        this.rowPanel.remove(singleRowTabTable);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.layoutManager.invalidate();
    }
}

