/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx.binding;

import bluej.utility.javafx.binding.DeepListBinding;
import java.util.Collection;
import java.util.stream.Stream;
import javafx.collections.ObservableList;

public class ConcatListBinding<T>
extends DeepListBinding<T> {
    private final ObservableList<ObservableList<T>> src;

    public static <T> void bind(ObservableList<T> dest, ObservableList<ObservableList<T>> src) {
        new ConcatListBinding<T>(dest, src).startListening();
    }

    private ConcatListBinding(ObservableList<T> dest, ObservableList<ObservableList<T>> src) {
        super(dest);
        this.src = src;
    }

    @Override
    protected Stream<ObservableList<?>> getListenTargets() {
        return Stream.concat(Stream.of(this.src), this.src.stream());
    }

    @Override
    protected Stream<T> calculateValues() {
        return this.src.stream().flatMap(Collection::stream);
    }
}

