/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.WindowOverlayPane;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCache;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXRunnable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaFXUtil {
    private static final FXCache<Font, FXCache<String, Double>> measured = new FXCache<Font, FXCache>(f -> new FXCache<String, Double>(s -> {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        Text text = new Text(s);
        text.setFont(f);
        return text.getLayoutBounds().getWidth();
    }, 10000), 3);

    public static void setPseudoclass(String pseudoClassName, boolean enabled, Node ... nodes) {
        if (!pseudoClassName.startsWith("bj-")) {
            throw new IllegalArgumentException("Our pseudoclasses should begin with bj- to avoid confusion with JavaFX's pseudo classes");
        }
        for (Node node : nodes) {
            node.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)pseudoClassName), enabled);
        }
    }

    public static boolean hasPseudoclass(Styleable node, String pseudoClassName) {
        return node.getPseudoClassStates().stream().filter(p -> p.getPseudoClassName().equals(pseudoClassName)).count() > 0L;
    }

    public static void selectPseudoClass(Node node, int index, String ... pseudoClasses) {
        for (int i = 0; i < pseudoClasses.length; ++i) {
            JavaFXUtil.setPseudoclass(pseudoClasses[i], i == index, node);
        }
    }

    public static void addStyleClass(Styleable node, String ... styleClasses) {
        for (String styleClass : styleClasses) {
            if (node.getStyleClass().contains((Object)styleClass)) continue;
            node.getStyleClass().add((Object)styleClass);
        }
    }

    @Deprecated
    public static void removeStyleClass(Styleable node, String ... styleClasses) {
        node.getStyleClass().removeAll((Object[])styleClasses);
    }

    public static double measureString(TextInputControl node, String str) {
        return JavaFXUtil.measureString(node, str, true, true);
    }

    public static double measureString(TextInputControl node, String str, boolean includeLeftInset, boolean includeRightInset) {
        return JavaFXUtil.measureString(node, str, node.getFont(), includeLeftInset, includeRightInset);
    }

    public static double measureString(TextInputControl node, String str, Font overrideFont, boolean includeLeftInset, boolean includeRightInset) {
        return measured.get(overrideFont).get(str) + (includeLeftInset ? node.getInsets().getLeft() : 0.0) + (includeRightInset ? node.getInsets().getRight() : 0.0);
    }

    public static double measureString(Labeled node, String str) {
        return measured.get(node.getFont()).get(str) + node.getLabelPadding().getLeft() + node.getLabelPadding().getRight() + node.getPadding().getLeft() + node.getPadding().getRight();
    }

    public static <T extends Styleable> CssMetaData<T, Number> cssSize(String propertyName, final Function<T, SimpleStyleableDoubleProperty> propGetter) {
        return new CssMetaData<T, Number>(propertyName, StyleConverter.getSizeConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Color> cssColor(String propertyName, final Function<T, SimpleStyleableObjectProperty<Color>> propGetter) {
        return new CssMetaData<T, Color>(propertyName, StyleConverter.getColorConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Color> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Insets> cssInsets(String propertyName, final Function<T, StyleableObjectProperty<Insets>> propGetter) {
        return new CssMetaData<T, Insets>(propertyName, StyleConverter.getInsetsConverter(), Insets.EMPTY){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Insets> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static void writeImageTo(WritableImage image, String filename) {
        File file = new File(filename);
        BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)image, null);
        try {
            ImageIO.write((RenderedImage)renderedImage, "png", file);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
    }

    public static void workAroundFunctionKeyBug(TextField field) {
        field.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            switch (e.getCode()) {
                case F1: 
                case F2: 
                case F3: 
                case F4: 
                case F5: 
                case F6: 
                case F7: 
                case F8: 
                case F9: 
                case F10: 
                case F11: 
                case F12: {
                    Runnable r = (Runnable)field.getScene().getAccelerators().get((Object)new KeyCodeCombination(e.getCode(), new KeyCombination.Modifier[0]));
                    if (r == null) break;
                    r.run();
                    e.consume();
                    break;
                }
            }
        });
    }

    public static Label cloneLabel(Label l, ObservableValue<String> fontSize) {
        Label copy = new Label();
        copy.textProperty().bind((ObservableValue)l.textProperty());
        JavaFXUtil.bindList(copy.getStyleClass(), l.getStyleClass());
        copy.styleProperty().bind((ObservableValue)l.styleProperty().concat((Object)"-fx-font-size:").concat(fontSize).concat((Object)";"));
        JavaFXUtil.bindPseudoclasses((Node)copy, (ObservableSet<PseudoClass>)l.getPseudoClassStates());
        return copy;
    }

    public static void blitImage(WritableImage dest, int xOffset, int yOffset, Image src) {
        dest.getPixelWriter().setPixels(xOffset, yOffset, (int)Math.ceil(src.getWidth()), (int)Math.ceil(src.getHeight()), src.getPixelReader(), 0, 0);
    }

    public static <S, T> ObservableValue<T> apply(ObservableValue<S> object, FXFunction<S, ObservableValue<T>> property, T def) {
        SimpleObjectProperty r = new SimpleObjectProperty(object.getValue() == null ? def : property.apply(object.getValue()).getValue());
        JavaFXUtil.addChangeListener(object, arg_0 -> JavaFXUtil.lambda$apply$997((ObjectProperty)r, def, property, arg_0));
        return r;
    }

    public static ReadOnlyBooleanProperty delay(ObservableBooleanValue source, final Duration delayToTrue, final Duration delayToFalse) {
        final SimpleBooleanProperty delayed = new SimpleBooleanProperty(source.get());
        source.addListener((ChangeListener)new ChangeListener<Boolean>(){
            private FXRunnable cancel = null;

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (this.cancel != null) {
                    this.cancel.run();
                }
                this.cancel = newValue != false ? JavaFXUtil.runAfter(delayToTrue, () -> delayed.set(true)) : JavaFXUtil.runAfter(delayToFalse, () -> delayed.set(false));
            }
        });
        return delayed;
    }

    public static ListBuilder<CssMetaData<? extends Styleable, ?>> extendCss(List<CssMetaData<? extends Styleable, ?>> superClassCssMetaData) {
        return new ListBuilder(superClassCssMetaData);
    }

    public static void listenForContextMenu(Node node, BiFunction<Double, Double, Boolean> showContextMenu) {
        EventHandler popupHandler = e -> {
            if (e.isPopupTrigger() && ((Boolean)showContextMenu.apply(e.getScreenX(), e.getScreenY())).booleanValue()) {
                e.consume();
            }
        };
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, popupHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, popupHandler);
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            Scene scene;
            Point2D scenePt;
            Point2D screenPt;
            if (e.getCode() == KeyCode.CONTEXT_MENU && ((Boolean)showContextMenu.apply((screenPt = (scenePt = node.localToScene(5.0, 5.0)).add((scene = node.getScene()).getWindow().getX() + scene.getX(), scene.getWindow().getY() + scene.getY())).getX(), screenPt.getY())).booleanValue()) {
                e.consume();
            }
        });
    }

    public static MenuItem makeMenuItem(String text, FXRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeMenuItem(StringExpression text, FXRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem();
        item.textProperty().bind((ObservableValue)text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeDisabledMenuItem(String text, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        item.setDisable(true);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, KeyCombination shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().bindBidirectional(state);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static Menu makeMenu(String text, MenuItem ... items) {
        Menu menu = new Menu(text);
        menu.getItems().setAll((Object[])items);
        return menu;
    }

    public static void initializeCustomTooltipCatalogue(final FXTabbedEditor window, Node target, String tooltipText, final Duration delay) {
        final Label l = new Label(tooltipText);
        l.visibleProperty().bind((ObservableValue)l.textProperty().isNotEmpty());
        l.setMouseTransparent(true);
        l.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)l, "frame-tooltip");
        JavaFXUtil.setPseudoclass("bj-tight-border", true, new Node[]{l});
        l.setMaxWidth(300.0);
        final FXRunnable show = () -> {
            WindowOverlayPane overlayPane = window.getOverlayPane();
            double x = overlayPane.sceneXToWindowOverlayX(target.localToScene(target.getBoundsInLocal()).getMinX());
            double y = overlayPane.sceneYToWindowOverlayY(target.localToScene(target.getBoundsInLocal()).getMaxY() + 10.0);
            overlayPane.addOverlay((Node)l, (ObservableDoubleValue)new ReadOnlyDoubleWrapper(x), (ObservableDoubleValue)new ReadOnlyDoubleWrapper(y), true);
            FadeTransition ft = new FadeTransition(Duration.millis((double)100.0), (Node)l);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.play();
        };
        target.addEventFilter(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){
            FXRunnable cancel;

            public void handle(MouseEvent event) {
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.cancel = JavaFXUtil.runAfter(delay, show);
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancel != null) {
                        this.cancel.run();
                        this.cancel = null;
                    }
                    window.getOverlayPane().removeOverlay((Node)l);
                }
            }
        });
    }

    public static void initializeCustomHelp(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip, boolean onHoverToo) {
        TooltipListener listener = new TooltipListener(editor, parent, requestTooltip);
        parent.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)listener);
        parent.focusedProperty().addListener((ChangeListener)listener);
        if (onHoverToo) {
            parent.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)listener);
            parent.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)listener);
        }
    }

    public static <T6> void onceNotNull(ObservableValue<T6> observable, final FXConsumer<T6> callback) {
        Object t = observable.getValue();
        if (t != null) {
            callback.accept(t);
            return;
        }
        ChangeListener listener = new ChangeListener<T6>(){

            public void changed(ObservableValue<? extends T6> observable, T6 oldValue, T6 newVal) {
                if (newVal != null) {
                    callback.accept(newVal);
                    observable.removeListener((ChangeListener)this);
                }
            }
        };
        observable.addListener(listener);
    }

    public static <SRC2, DEST2> void bindMap(final List<DEST2> dest, final ObservableList<SRC2> src, final Function<SRC2, DEST2> func) {
        dest.clear();
        dest.addAll(Utility.mapList(src, func));
        src.addListener(new ListChangeListener<SRC2>(){

            public void onChanged(ListChangeListener.Change<? extends SRC2> changes) {
                while (changes.next()) {
                    int i;
                    if (changes.wasPermutated() || changes.wasUpdated()) {
                        for (i = changes.getFrom(); i < changes.getTo(); ++i) {
                            dest.set(i, func.apply(src.get(i)));
                        }
                        continue;
                    }
                    for (i = 0; i < changes.getRemovedSize(); ++i) {
                        dest.remove(changes.getFrom());
                    }
                    for (i = 0; i < changes.getAddedSubList().size(); ++i) {
                        dest.add(i + changes.getFrom(), func.apply(changes.getAddedSubList().get(i)));
                    }
                }
            }
        });
    }

    public static <T> void bindFuture(Future<T> future, FXConsumer<T> andThen) {
        Utility.runBackground(() -> {
            try {
                Object x = future.get();
                Platform.runLater(() -> andThen.accept(x));
            }
            catch (InterruptedException | ExecutionException e) {
                Debug.reportError(e);
            }
        });
    }

    public static <T> ObservableList<T> listBool(BooleanExpression putInList, T ... items) {
        ObservableList r = FXCollections.observableArrayList();
        if (putInList.get()) {
            r.setAll((Object[])items);
        }
        putInList.addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                r.setAll(items);
            } else {
                r.clear();
            }
        });
        return r;
    }

    public static <T> FXRunnable addSelfRemovingListener(final ObservableValue<T> prop, final FXConsumer<T> callback) {
        ChangeListener l = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                callback.accept(newValue);
                prop.removeListener((ChangeListener)this);
            }
        };
        prop.addListener(l);
        return () -> JavaFXUtil.lambda$addSelfRemovingListener$1009(prop, (ChangeListener)l);
    }

    public static <T> FXRunnable bindList(ObservableList<T> dest, ObservableList<T> src) {
        ListChangeListener obs = c -> dest.setAll((Collection)src);
        src.addListener(obs);
        dest.setAll(src);
        return () -> src.removeListener(obs);
    }

    public static <T> FXRunnable addChangeListener(ObservableValue<T> property, FXConsumer<T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    public static FXRunnable sequence(FXRunnable ... actions) {
        return () -> Arrays.stream(actions).forEach(FXRunnable::run);
    }

    public static FXRunnable runAfter(Duration delay, FXRunnable task) {
        if (delay.lessThanOrEqualTo(Duration.ZERO)) {
            task.run();
            return () -> {};
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(delay, arg_0 -> JavaFXUtil.lambda$runAfter$1016((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
        return () -> JavaFXUtil.lambda$runAfter$1017((BooleanProperty)okToRun, timeline);
    }

    public static FXRunnable runRegular(Duration interval, FXRunnable task) {
        if (interval.lessThanOrEqualTo(Duration.ZERO)) {
            throw new IllegalArgumentException("Cannot run at a regular interval of zero or less");
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(interval, arg_0 -> JavaFXUtil.lambda$runRegular$1018((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(false);
        timeline.play();
        return () -> JavaFXUtil.lambda$runRegular$1019((BooleanProperty)okToRun, timeline);
    }

    public static boolean isDragCopyKeyPressed(MouseEvent event) {
        return Config.isMacOS() ? event.isAltDown() : event.isShortcutDown();
    }

    public static void bindPseudoclasses(Node to, ObservableSet<PseudoClass> from) {
        from.addListener(c -> {
            if (c.wasAdded()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementAdded(), true);
            }
            if (c.wasRemoved()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementRemoved(), false);
            }
        });
        from.forEach(c -> to.pseudoClassStateChanged(c, true));
    }

    private static /* synthetic */ void lambda$runRegular$1019(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runRegular$1018(BooleanProperty okToRun, FXRunnable task, ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$runAfter$1017(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runAfter$1016(BooleanProperty okToRun, FXRunnable task, ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$addSelfRemovingListener$1009(ObservableValue prop, ChangeListener l) {
        prop.removeListener(l);
    }

    private static /* synthetic */ void lambda$apply$997(ObjectProperty r, Object def, FXFunction property, Object value) {
        r.unbind();
        if (value == null) {
            r.setValue(def);
        } else {
            r.bind((ObservableValue)property.apply(value));
        }
    }

    @OnThread(value=Tag.FX)
    private static class TooltipListener
    implements EventHandler<InputEvent>,
    ChangeListener<Boolean> {
        private Label l;
        private final InteractionManager editor;
        private final Node parent;
        private final FXConsumer<FXConsumer<String>> requestTooltip;
        private FXRunnable cancelHoverShow = null;
        private boolean showing = false;
        private boolean mouseShown = false;

        private TooltipListener(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip) {
            this.editor = editor;
            this.parent = parent;
            this.requestTooltip = requestTooltip;
        }

        public void handle(InputEvent original) {
            if (original instanceof KeyEvent) {
                KeyEvent event = (KeyEvent)original;
                if (event.getCode() == KeyCode.F1 && !this.showing) {
                    this.mouseShown = false;
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    this.show();
                    event.consume();
                }
                if (event.getCode() == KeyCode.ESCAPE && this.showing && !this.mouseShown) {
                    this.hide();
                }
            } else if (original instanceof MouseEvent) {
                MouseEvent event = (MouseEvent)original;
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (!this.showing) {
                        this.cancelHoverShow = JavaFXUtil.runAfter(Duration.millis((double)1000.0), () -> {
                            this.mouseShown = true;
                            this.show();
                        });
                    }
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (this.showing && this.mouseShown) {
                        this.hide();
                    }
                }
            }
        }

        private void show() {
            if (this.showing) {
                this.hide();
            }
            this.l = new Label();
            this.l.visibleProperty().bind((ObservableValue)this.l.textProperty().isNotEmpty());
            this.l.setMouseTransparent(true);
            this.l.setWrapText(true);
            JavaFXUtil.addStyleClass((Styleable)this.l, "frame-tooltip");
            this.requestTooltip.accept(arg_0 -> ((Label)this.l).setText(arg_0));
            this.editor.getCodeOverlayPane().addOverlay((Node)this.l, this.parent, null, (DoubleExpression)this.l.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.showing = true;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newVal) {
            if (!newVal.booleanValue() && this.showing && !this.mouseShown) {
                this.hide();
            }
        }

        private void hide() {
            if (this.showing) {
                this.editor.getCodeOverlayPane().removeOverlay((Node)this.l);
                this.l = null;
                this.showing = false;
            }
        }
    }

    public static class ListBuilder<T> {
        private ArrayList<T> list;

        private ListBuilder(List<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public ListBuilder<T> add(T t) {
            this.list.add(t);
            return this;
        }

        public List<T> build() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

