/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.Debug;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class BetterVBox
extends Pane {
    private final double minWidth;
    private final DoubleProperty spacingProperty = new SimpleDoubleProperty(0.0);

    public final DoubleProperty spacingProperty() {
        return this.spacingProperty;
    }

    public BetterVBox(double minWidth) {
        this.minWidth = minWidth;
    }

    protected void layoutChildren() {
        Insets padding = this.getPadding();
        double y = (int)padding.getTop();
        double contentWidth = this.getWidth() - (double)((int)padding.getLeft()) - (double)((int)padding.getRight());
        for (Node n : this.getManagedChildren()) {
            double w = Math.min(contentWidth - (double)((int)this.getLeftMarginFor(n)) - (double)((int)this.getRightMarginFor(n)), n.maxWidth(-1.0));
            double h = n.prefHeight(w);
            n.resizeRelocate((double)((int)padding.getLeft() + (int)this.getLeftMarginFor(n)), y += this.getTopMarginFor(n), w, h);
            y += h + this.spacingProperty.get() + this.getBottomMarginFor(n);
        }
    }

    public boolean isResizable() {
        return true;
    }

    protected double computeMinWidth(double height) {
        return this.minWidth;
    }

    protected double computeMinHeight(double width) {
        Insets padding = this.getPadding();
        double contentWidth = width - (double)((int)padding.getLeft()) - (double)((int)padding.getRight());
        double reqMin = this.getMinHeight() == -1.0 || this.getMinHeight() == Double.NEGATIVE_INFINITY ? 0.0 : this.getMinHeight();
        return Math.max(reqMin, this.getManagedChildren().stream().mapToDouble(n -> this.getTopMarginFor((Node)n) + this.getBottomMarginFor((Node)n) + n.prefHeight(contentWidth)).sum()) + (double)((int)padding.getTop()) + (double)((int)padding.getBottom());
    }

    protected double computePrefWidth(double height) {
        return 2000.0;
    }

    protected double computePrefHeight(double width) {
        if (width == -1.0 || width == 2000.0) {
            Debug.printCallStack("Problem in BetterVBox: calculating height first, which should not happen -- are you running ScenicView?");
        }
        Insets padding = this.getPadding();
        double contentWidth = width - (double)((int)padding.getLeft()) - (double)((int)padding.getRight());
        double reqMin = this.getMinHeight() == -1.0 || this.getMinHeight() == Double.NEGATIVE_INFINITY ? 0.0 : this.getMinHeight();
        return Math.max(reqMin, this.getManagedChildren().stream().mapToDouble(n -> this.getTopMarginFor((Node)n) + this.getBottomMarginFor((Node)n) + n.prefHeight(contentWidth - this.getLeftMarginFor((Node)n) - this.getRightMarginFor((Node)n))).sum()) + (double)((int)padding.getTop()) + (double)((int)padding.getBottom());
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    public double getTopMarginFor(Node n) {
        return 0.0;
    }

    public double getBottomMarginFor(Node n) {
        return 0.0;
    }

    public double getLeftMarginFor(Node n) {
        return 0.0;
    }

    public double getRightMarginFor(Node n) {
        return 0.0;
    }
}

