/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Boot;
import bluej.parser.ImportedTypeCompletion;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.utility.Debug;
import bluej.utility.Utility;
import com.google.common.base.Predicate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportScanner {
    private final Object monitor = new Object();
    private CompletableFuture<PackageInfo> root;
    private Reflections reflections;
    private Project project;

    public ImportScanner(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private CompletableFuture<PackageInfo> getRoot() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.root != null) {
                return this.root;
            }
            this.root = new CompletableFuture();
            Utility.getBackground().submit(new Runnable(){

                @Override
                @OnThread(value=Tag.Unique)
                public void run() {
                    ImportScanner.this.root.complete(ImportScanner.this.findAllTypes());
                }
            });
            return this.root;
        }
    }

    @OnThread(value=Tag.Any)
    public List<AssistContentThreadSafe> getImportedTypes(String importSrc, JavadocResolver javadocResolver) {
        try {
            return this.getRoot().get().getImportedTypes("", Arrays.asList(importSrc.split("\\.", -1)).iterator(), javadocResolver);
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError(e);
            return Collections.emptyList();
        }
    }

    @OnThread(value=Tag.Unique)
    private ConfigurationBuilder getClassloaderConfig() {
        ArrayList<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
        try {
            SwingUtilities.invokeAndWait(() -> classLoadersList.add(this.project.getClassLoader()));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Debug.reportError(e);
        }
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(ClasspathHelper.forClassLoader((ClassLoader[])classLoadersList.toArray(new ClassLoader[0])));
        urls.addAll(Arrays.asList(Boot.getInstance().getRuntimeUserClassPath()));
        try {
            urls.add(Boot.getJREJar((String)"rt.jar"));
        }
        catch (MalformedURLException e) {
            Debug.reportError(e);
        }
        urls.removeIf(u -> u.toExternalForm().endsWith("jnilib") || u.toExternalForm().endsWith("zip"));
        urls.removeIf(u -> {
            if ("file".equals(u.getProtocol())) {
                try {
                    File f = new File(u.toURI());
                    if (f.getName().startsWith(".")) {
                        return true;
                    }
                    if (f.getName().endsWith(".so")) {
                        return true;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        });
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]));
        return new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false)}).setUrls(urls).addClassLoader((ClassLoader)cl);
    }

    @OnThread(value=Tag.Unique)
    private Reflections getReflections(List<String> importSrcs) {
        FilterBuilder filter = new FilterBuilder();
        for (String importSrc : importSrcs) {
            if (importSrc.endsWith(".*")) {
                String importSrcRegex = importSrc.substring(0, importSrc.length() - 1).replace(".", "\\.");
                filter = filter.include(importSrcRegex + ".*");
                continue;
            }
            filter = filter.include(importSrc.replace(".", "\\.") + ".*");
        }
        filter = filter.exclude(".*\\$\\d.*");
        filter = filter.exclude("com\\.sun\\..*");
        try {
            return new Reflections((Configuration)this.getClassloaderConfig().filterInputsBy((Predicate)filter));
        }
        catch (Throwable e) {
            Debug.reportError(e);
            return null;
        }
    }

    @OnThread(value=Tag.Unique)
    private PackageInfo findAllTypes() {
        HashSet<String> classes;
        this.reflections = this.getReflections(Collections.emptyList());
        if (this.reflections == null) {
            return new PackageInfo();
        }
        try {
            classes = this.reflections.getSubTypeNamesOf(Object.class);
        }
        catch (Throwable t) {
            Debug.reportError(t);
            classes = new HashSet<String>();
        }
        classes.add(Object.class.getName());
        PackageInfo r = new PackageInfo();
        classes.forEach(c -> r.addClass((String)c));
        return r;
    }

    public void startScanning() {
        this.getRoot();
    }

    private class PackageInfo {
        public final HashMap<String, AssistContentThreadSafe> types = new HashMap();
        public final HashMap<String, PackageInfo> subPackages = new HashMap();

        private PackageInfo() {
        }

        public void addClass(String name) {
            String[] splitParts = name.split("\\.", -1);
            this.addClass(Arrays.asList(Arrays.copyOf(splitParts, splitParts.length - 1)).iterator(), splitParts[splitParts.length - 1]);
        }

        private void addClass(Iterator<String> packageIdents, String name) {
            if (packageIdents.hasNext()) {
                String ident = packageIdents.next();
                PackageInfo subPkg = this.subPackages.get(ident);
                if (subPkg == null) {
                    subPkg = new PackageInfo();
                    this.subPackages.put(ident, subPkg);
                }
                subPkg.addClass(packageIdents, name);
            } else {
                this.types.put(name, null);
            }
        }

        private AssistContentThreadSafe getType(String prefix, String name, JavadocResolver javadocResolver) {
            return this.types.computeIfAbsent(name, s -> {
                Class c = ImportScanner.this.reflections.typeNameToClass(prefix + s);
                CompletableFuture f = new CompletableFuture();
                try {
                    SwingUtilities.invokeAndWait(() -> f.complete(new AssistContentThreadSafe(new ImportedTypeCompletion(c, javadocResolver))));
                    return (AssistContentThreadSafe)f.get();
                }
                catch (Exception e) {
                    Debug.reportError(e);
                    return null;
                }
            });
        }

        public List<AssistContentThreadSafe> getImportedTypes(String prefix, Iterator<String> idents, JavadocResolver javadocResolver) {
            if (!idents.hasNext()) {
                return Collections.emptyList();
            }
            String s = idents.next();
            if (s.equals("*")) {
                return this.types.keySet().stream().map(t -> this.getType(prefix, (String)t, javadocResolver)).filter(ac -> ac != null).collect(Collectors.toList());
            }
            if (idents.hasNext()) {
                if (this.subPackages.containsKey(s)) {
                    return this.subPackages.get(s).getImportedTypes(prefix + s + ".", idents, javadocResolver);
                }
                return Collections.emptyList();
            }
            AssistContentThreadSafe ac2 = this.getType(prefix, s, javadocResolver);
            if (ac2 != null) {
                return Collections.singletonList(ac2);
            }
            return Collections.emptyList();
        }
    }
}

