/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class DialogManager {
    private static final String DLG_FILE_NAME = "dialogues";
    private static final String GREENFOOT_DLG_FILE_NAME = "greenfoot/dialogues";

    public static void showMessage(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"), 1);
        }
    }

    public static void showMessageWithText(Component parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, message + "\n" + text);
        }
    }

    public static void showMessageWithText(Component parent, String msgID, String[] subs) {
        String message = DialogManager.getMessage(msgID);
        message = Utility.mergeStrings(message, subs);
        message = message.replace("\n:\n", "\n\n");
        if ((message = message.replace("\r\n:\r\n", "\r\n\r\n")) != null) {
            JOptionPane.showMessageDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.message"), 1);
        }
    }

    public static void showMessageWithPrefixText(Component parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, text + "\n" + message);
        }
    }

    public static void showMessageWithPrefixText(Component parent, String msgID, String text, String innerText) {
        String message = DialogManager.getMessage(msgID);
        String messageDialog = Utility.mergeStrings(message, innerText);
        if (message != null) {
            JOptionPane.showMessageDialog(parent, text + "\n" + messageDialog);
        }
    }

    public static void showText(Component parent, String text) {
        JOptionPane.showMessageDialog(parent, text);
    }

    public static void showTextWithCopyButton(Component parent, String text, String title) {
        if (JOptionPane.showOptionDialog(parent, text, title, 0, 0, null, new String[]{Config.getString("okay"), Config.getString("editor.copy-to-clipboardLabel")}, null) == 1) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        }
    }

    public static void showError(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            DialogManager.showErrorText(parent, message);
        }
    }

    public static void showErrorText(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.error"), 0);
    }

    public static void showErrorWithText(Component parent, String msgID, String text) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            DialogManager.showErrorText(parent, message + "\n" + text);
        }
    }

    public static int askQuestion(Component parent, String msgID) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            message = message.substring(0, button1Index);
            Object[] options = "null".equals(button3) ? new Object[]{button1, button2} : new Object[]{button1, button2, button3};
            return JOptionPane.showOptionDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"), -1, 2, null, options, options[0]);
        }
        return 0;
    }

    public static int askQuestion(Component parent, String msgID, String[] subs) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int button3Index = message.lastIndexOf("\n");
            int button2Index = message.lastIndexOf("\n", button3Index - 1);
            int button1Index = message.lastIndexOf("\n", button2Index - 1);
            String button3 = message.substring(button3Index + 1);
            String button2 = message.substring(button2Index + 1, button3Index);
            String button1 = message.substring(button1Index + 1, button2Index);
            message = message.substring(0, button1Index);
            message = Utility.mergeStrings(message, subs);
            Object[] options = "null".equals(button3) ? new Object[]{button1, button2} : new Object[]{button1, button2, button3};
            return JOptionPane.showOptionDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"), -1, 2, null, options, options[0]);
        }
        return 0;
    }

    public static String askString(Component parent, String msgID) {
        String response = "";
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String defaultText = message.substring(defaultTextIndex + 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            if ("null".equals(defaultText)) {
                defaultText = null;
            }
            response = (String)JOptionPane.showInputDialog(parent, message, title, -1, null, null, defaultText);
        }
        return response;
    }

    public static String askString(Component parent, String msgID, String defaultText) {
        String response = "";
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int defaultTextIndex = message.lastIndexOf("\n");
            int titleIndex = message.lastIndexOf("\n", defaultTextIndex - 1);
            String title = message.substring(titleIndex + 1, defaultTextIndex);
            message = message.substring(0, titleIndex);
            response = (String)JOptionPane.showInputDialog(parent, message, title, -1, null, null, defaultText);
        }
        return response;
    }

    @OnThread(value=Tag.Any)
    public static String getMessage(String msgID) {
        File filename;
        String message = null;
        if (Config.isGreenfoot() && (message = BlueJFileReader.readHelpText(filename = Config.getLanguageFile(GREENFOOT_DLG_FILE_NAME), msgID, true)) == null) {
            filename = Config.getDefaultLanguageFile(GREENFOOT_DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            filename = Config.getLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null && !Config.language.equals("english")) {
            filename = Config.getDefaultLanguageFile(DLG_FILE_NAME);
            message = BlueJFileReader.readHelpText(filename, msgID, true);
        }
        if (message == null) {
            message = "BlueJ configuration problem:\ntext not found for message ID\n" + msgID;
            Debug.message(message);
        }
        return message;
    }

    public static void NYI(Component frame) {
        DialogManager.showMessage(frame, "not-yet-implemented");
    }

    public static void centreDialog(JDialog dialog) {
        DialogManager.centreWindow(dialog, (Window)dialog.getParent());
    }

    public static void centreWindow(Window child, Window parent) {
        child.setLocationRelativeTo(parent);
    }

    public static void tileWindow(Window child, Window parent) {
        if (parent.isShowing()) {
            Point p_topleft = parent.getLocationOnScreen();
            child.setLocation(p_topleft.x + 20, p_topleft.y + 20);
        }
    }

    public static int askQuestion(Component parent, String msgID, int numOptions) {
        String message = DialogManager.getMessage(msgID);
        if (message != null) {
            int btnIndex = message.length() + 1;
            int prevBtnIndex = message.length();
            Object[] options = new String[numOptions];
            for (int i = 0; i < numOptions; ++i) {
                String buttonName;
                btnIndex = message.lastIndexOf("\n", btnIndex - 1);
                options[numOptions - i - 1] = buttonName = message.substring(btnIndex + 1, prevBtnIndex);
                prevBtnIndex = btnIndex;
            }
            message = message.substring(0, btnIndex);
            return JOptionPane.showOptionDialog(parent, message, Config.getApplicationName() + ":  " + Config.getString("dialogmgr.question"), -1, 2, null, options, options[0]);
        }
        return 0;
    }

    public static void addOKCancelButtons(JPanel panel, JButton okButton, JButton cancelButton) {
        if (Config.isMacOS()) {
            panel.add(cancelButton);
            panel.add(okButton);
        } else {
            panel.add(okButton);
            panel.add(cancelButton);
        }
    }
}

