/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.editor.stride.FrameCatalogue;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SuggestedFollowUpDisplay;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.TextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;

public class TypeTextSlot
extends TextSlot<TypeSlotFragment> {
    private boolean isReturnType;
    private SlotValueListener validCharactersListener = (slot, oldValue, newValue, parent) -> newValue.chars().allMatch(c -> Character.isJavaIdentifierPart(c) || c == 46 || c == 60 || c == 62 || c == 44 || c == 91 || c == 93);
    private static final List<FrameCatalogue.Hint> HINTS = Arrays.asList(new FrameCatalogue.Hint("int", "An integer (whole number)"), new FrameCatalogue.Hint("double", "A number value"), new FrameCatalogue.Hint("String", "Some text"), new FrameCatalogue.Hint("Actor", "A Greenfoot actor"));

    public <T extends Frame> TypeTextSlot(InteractionManager editor, T frameParent, FrameContentRow row, CompletionCalculator completionCalculator, String stylePrefix) {
        super(editor, frameParent, (CodeFrame)((Object)frameParent), row, completionCalculator, stylePrefix, HINTS);
        this.addValueListener(this.validCharactersListener);
    }

    public TypeTextSlot(InteractionManager editor, Frame frameParent, CodeFrame<? extends CodeElement> codeFrameParent, FrameContentRow row, CompletionCalculator completionCalculator, String stylePrefix) {
        super(editor, frameParent, codeFrameParent, row, completionCalculator, stylePrefix, HINTS);
        this.addValueListener(this.validCharactersListener);
    }

    @Override
    public TypeSlotFragment createFragment(String content) {
        return new TypeSlotFragment(content, this);
    }

    @Override
    public void valueChangedLostFocus(String oldValue, String newValue) {
        if (this.isReturnType) {
            List removeActions;
            if ((oldValue.equals("void") || oldValue.equals("")) && !newValue.equals("void") && !newValue.equals("")) {
                for (Frame f2 : Utility.iterableStream(this.getParentFrame().getAllFrames())) {
                    if (!(f2 instanceof ReturnFrame)) continue;
                    ReturnFrame rf2 = (ReturnFrame)f2;
                    rf2.showValue();
                }
            } else if (!oldValue.equals("void") && newValue.equals("void") && !(removeActions = this.getParentFrame().getAllFrames().filter(f -> f instanceof ReturnFrame).map(f -> (ReturnFrame)f).map(rf -> rf.getRemoveFilledValueAction()).filter(a -> a != null).collect(Collectors.toList())).isEmpty()) {
                SuggestedFollowUpDisplay disp = new SuggestedFollowUpDisplay(this.editor, "Return type changed to void.  Would you like to remove return values from all return frames in this method?", () -> removeActions.forEach(FXRunnable::run));
                disp.showBefore((Node)this.getNode());
            }
        }
    }

    public void markReturnType() {
        this.isReturnType = true;
    }

    @Override
    protected Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getExtraContextMenuItems() {
        final EditableSlot.SortedMenuItem scanningItem = EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(new MenuItem("Scanning..."));
        scanningItem.getItem().setDisable(true);
        return Collections.singletonMap(EditableSlot.TopLevelMenu.VIEW, new EditableSlot.MenuItems(FXCollections.observableArrayList()){

            public void removeScanning() {
                if (this.items.size() == 1 && this.items.get(0) == scanningItem) {
                    this.items.clear();
                }
            }

            @Override
            public void onShowing() {
                this.items.setAll((Object[])new EditableSlot.SortedMenuItem[]{scanningItem});
                TypeTextSlot.this.findLinks().forEach(l -> TypeTextSlot.this.editor.searchLink((PossibleLink)l, optLink -> {
                    this.removeScanning();
                    optLink.ifPresent(defLink -> this.items.add((Object)EditableSlot.MenuItemOrder.GOTO_DEFINITION.item(JavaFXUtil.makeMenuItem("Go to definition of \"" + defLink.getName() + "\"", defLink.getOnClick(), null))));
                }));
            }

            @Override
            public void onHidden() {
                this.items.clear();
            }
        });
    }

    @Override
    public List<PossibleTypeLink> findLinks() {
        return Collections.singletonList(new PossibleTypeLink(this.getText(), 0, this.getText().length(), this));
    }
}

