/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.TypeTextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TypeList
implements SlotValueListener {
    private final ObservableList<HeaderItem> headerItems = FXCollections.observableArrayList();
    protected final ObservableList<TypeTextSlot> typeSlots = FXCollections.observableArrayList();
    private final Supplier<TypeTextSlot> slotGenerator;
    private final Frame parentFrame;
    private final FXRunnable focusOnNext;
    private InteractionManager editor;
    private final BooleanProperty focusedProperty = new SimpleBooleanProperty(false);

    protected TypeList(String label, Frame parentFrame, Supplier<TypeTextSlot> slotGenerator, FXRunnable focusOnNext, InteractionManager editor) {
        this.parentFrame = parentFrame;
        this.slotGenerator = slotGenerator;
        this.focusOnNext = focusOnNext;
        this.editor = editor;
        final SlotLabel prefixLabel = new SlotLabel(label, new String[0]);
        new DeepListBinding<HeaderItem>(this.headerItems){

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.of(TypeList.this.typeSlots);
            }

            @Override
            protected Stream<HeaderItem> calculateValues() {
                if (TypeList.this.typeSlots.isEmpty()) {
                    return Stream.empty();
                }
                ArrayList<SlotLabel> commas = new ArrayList<SlotLabel>();
                for (int i = 0; i < TypeList.this.typeSlots.size() - 1; ++i) {
                    commas.add(new SlotLabel(", ", new String[0]));
                }
                return Utility.concat(Stream.of(prefixLabel), Utility.interleave(TypeList.this.typeSlots.stream().map(h -> h), commas.stream()));
            }
        }.startListening();
        ChangeListener focusListener = (a, b, newVal) -> this.updateFocusedProperty();
        this.typeSlots.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(slot -> slot.effectivelyFocusedProperty().addListener(focusListener));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(slot -> slot.effectivelyFocusedProperty().removeListener(focusListener));
            }
            this.updateFocusedProperty();
        });
    }

    private void updateFocusedProperty() {
        this.focusedProperty.set(this.typeSlots.stream().anyMatch(slot -> (Boolean)slot.effectivelyFocusedProperty().getValue()));
    }

    public ObservableList<HeaderItem> getHeaderItems() {
        return this.headerItems;
    }

    private TypeTextSlot addTypeSlot(int index) {
        TypeTextSlot slot = this.slotGenerator.get();
        slot.addValueListener(this);
        slot.addFocusListener(this.parentFrame);
        slot.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.typeSlots.add(index, (Object)slot);
        return slot;
    }

    @Override
    public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
        if (newValue.contains(",")) {
            TypeTextSlot newSlot = this.addTypeSlot(this.typeSlots.indexOf((Object)slot) + 1);
            String right = newValue.substring(newValue.indexOf(",") + 1);
            Platform.runLater(() -> ((TypeTextSlot)slot).setText(newValue.substring(0, newValue.indexOf(","))));
            newSlot.setText(right);
            newSlot.requestFocus(Focus.LEFT);
            return false;
        }
        return true;
    }

    @Override
    public void backSpacePressedAtStart(HeaderItem slot) {
        int index = this.typeSlots.indexOf((Object)slot);
        String remainder = this.delete((TypeTextSlot)slot);
        if (index - 1 >= 0 && index - 1 < this.typeSlots.size()) {
            TypeTextSlot prev = (TypeTextSlot)this.typeSlots.get(index - 1);
            prev.setText(prev.getText() + remainder);
            prev.requestFocus();
            prev.recallFocus(prev.getText().length() - remainder.length());
        } else {
            this.focusOnNext.run();
        }
    }

    @Override
    public void deletePressedAtEnd(HeaderItem slot) {
        int index = this.typeSlots.indexOf((Object)slot);
        if (index < this.typeSlots.size() - 1) {
            String remainder = this.delete((TypeTextSlot)this.typeSlots.get(index + 1));
            String prev = ((TypeTextSlot)this.typeSlots.get(index)).getText();
            ((TypeTextSlot)this.typeSlots.get(index)).setText(prev + remainder);
            ((TypeTextSlot)this.typeSlots.get(index)).recallFocus(prev.length());
        } else {
            this.delete((TypeTextSlot)slot);
            this.focusOnNext.run();
        }
    }

    private String delete(TypeTextSlot slot) {
        slot.cleanup();
        this.typeSlots.remove((Object)slot);
        this.editor.modifiedFrame(this.parentFrame);
        return slot.getText();
    }

    public void addTypeSlotAtEnd(String content, boolean requestFocus) {
        TypeTextSlot slot = this.addTypeSlot(this.typeSlots.size());
        slot.setText(content);
        if (requestFocus) {
            slot.requestFocus(Focus.LEFT);
        }
    }

    public void setTypes(List<String> types) {
        while (this.typeSlots.size() > 0) {
            this.delete((TypeTextSlot)this.typeSlots.get(this.typeSlots.size() - 1));
        }
        types.forEach(t -> this.addTypeSlotAtEnd((String)t, false));
    }

    public Stream<TypeTextSlot> getTypeSlots() {
        return this.typeSlots.stream();
    }

    public void ensureAtLeastOneSlot() {
        if (this.typeSlots.isEmpty()) {
            this.addTypeSlotAtEnd("", false);
        }
    }

    public void clearIfSingleEmpty() {
        if (this.typeSlots.size() == 1 && ((TypeTextSlot)this.typeSlots.get(0)).isEmpty()) {
            this.delete((TypeTextSlot)this.typeSlots.get(0));
        }
    }

    public ReadOnlyBooleanProperty focusedProperty() {
        return this.focusedProperty;
    }

    public void removeIndex(int index) {
        if (index >= 0 && index < this.typeSlots.size()) {
            this.delete((TypeTextSlot)this.typeSlots.get(index));
        }
    }
}

